/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.defense;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;

@PowerManifest(name="Adaptability", type=PowerType.DEFENSE, author="sirrus86", concept="diamondmario", icon=Material.LEATHER_CHESTPLATE, description="When damaged, develop resistance to that damage type, reducing all following damage of the same type starting at [initial-adapt]%, increasing up to [maximum-adapt]%. While resistant to one type, damage from all other types increased to [damage-increase]%. [adapt-cooldown] cooldown.[prevent-armor] Power prevents you from wearing armor.[/prevent-armor]")
public final class Adaptability
extends Power {
    private Map<PowerUser, AdaptUser> aUsers;
    private double incrAmt;
    private PowerOption<List<String>> explosionTypes;
    private PowerOption<List<String>> fireTypes;
    private PowerOption<List<String>> iceTypes;
    private PowerOption<List<String>> lightningTypes;
    private PowerOption<List<String>> magicTypes;
    private PowerOption<List<String>> natureTypes;
    private PowerOption<List<String>> physicalTypes;
    private PowerOption<List<String>> poisonTypes;
    private PowerOption<List<String>> projectileTypes;
    private PowerOption<List<String>> shadowTypes;
    private PowerOption<List<String>> waterTypes;
    private PowerOption<Boolean> noArmor;
    private PowerOption<Double> dmgIncr;
    private PowerOption<Double> initAmt;
    private PowerOption<Double> maxAmt;
    private PowerOption<Integer> steps;
    private String nowAdapting;
    private String resistIncrease;
    private String preventArmor;

    @Override
    protected void onEnable() {
        this.aUsers = new HashMap<PowerUser, AdaptUser>();
    }

    @Override
    protected void onDisable(PowerUser user) {
        this.aUsers.remove(user);
    }

    @Override
    protected void config() {
        this.cooldown = this.option("adapt-cooldown", PowerTime.toMillis(3, 0), "Minimum time between incoming damage that user may further adapt.");
        this.dmgIncr = this.option("damage-increase", 200.0, "Percentage of damage done from adaptable sources that aren't being adapted to.");
        this.explosionTypes = this.option("damage-types.explosion", List.of("BLOCK_EXPLOSION", "ENTITY_EXPLOSION"), "Damage causes which should attribute to explosion resistance.");
        this.fireTypes = this.option("damage-types.fire", List.of("FIRE", "FIRE_TICK", "HOT_FLOOR", "LAVA"), "Damage causes which should attribute to fire resistance.");
        this.iceTypes = this.option("damage-types.ice", List.of("FREEZE"), "Damage causes which should attribute to ice resistance.");
        this.initAmt = this.option("initial-adapt", 25.0, "Initial percent of damage mitigation after user changes adapt type.");
        this.lightningTypes = this.option("damage-types.lightning", List.of("LIGHTNING"), "Damage causes which should attribute to lightning resistance.");
        this.magicTypes = this.option("damage-types.magic", List.of("MAGIC"), "Damage causes which should attribute to magic resistance.");
        this.maxAmt = this.option("maximum-adapt", 100.0, "Maximum percent of damage mitigation for a given adapt type.");
        this.natureTypes = this.option("damage-types.nature", List.of("CONTACT", "THORNS"), "Damage causes which should attribute to nature resistance.");
        this.noArmor = this.option("prevent-armor", true, "Prevents users from wearing armor.");
        this.physicalTypes = this.option("damage-types.physical", List.of("ENTITY_ATTACK", "ENTITY_SWEEP_ATTACK", "FALLING_BLOCK"), "Damage causes which should attribute to physical resistance.");
        this.poisonTypes = this.option("damage-types.poison", List.of("POISON", "WITHER"), "Damage causes which should attribute to poison resistance.");
        this.projectileTypes = this.option("damage-types.projectile", List.of("PROJECTILE"), "Damage causes which should attribute to projectile resistance.");
        this.shadowTypes = this.option("damage-types.shadow", List.of("DRAGON_BREATH"), "Damage causes which should attribute to shadow resistance.");
        this.steps = this.option("adapt-increment-steps", 10, "Number of increments it takes to reach maximum adapt from initial.");
        this.waterTypes = this.option("damage-types.water", List.of(), "Damage causes which should attribute to water resistance.");
        this.nowAdapting = this.locale("message.now-adapting", ChatColor.YELLOW + "Now adapting to [type] damage.");
        this.preventArmor = this.locale("message.prevents-armor", ChatColor.RED + "Your power prevents you from wearing armor.");
        this.resistIncrease = this.locale("message.resistance-increase", ChatColor.YELLOW + "Resistance to [type] increased to [amount]%.");
    }

    private double adapt(PowerUser user, AdaptType type) {
        double amt = 1.0;
        if (this.aUsers.get(user).getType() != type) {
            amt = user.getOption(this.dmgIncr);
            if (user.getCooldown(this) <= 0L) {
                user.sendMessage(this.nowAdapting.replace("[type]", type.name().toLowerCase()));
                this.aUsers.get(user).setType(type).setAmount(user.getOption(this.initAmt));
                user.setCooldown(this, (Long)user.getOption(this.cooldown));
            }
        } else {
            amt = this.aUsers.get(user).getAmount();
            if (user.getCooldown(this) <= 0L && this.aUsers.get(user).getAmount() < user.getOption(this.maxAmt)) {
                this.incrAmt = (user.getOption(this.maxAmt) - user.getOption(this.initAmt)) / (double)user.getOption(this.steps).intValue();
                this.aUsers.get(user).increaseAmount(this.incrAmt);
                user.sendMessage(this.resistIncrease.replace("[type]", type.name().toLowerCase()).replace("[amount]", Double.toString(this.aUsers.get(user).getAmount())));
                user.setCooldown(this, (Long)user.getOption(this.cooldown));
            }
        }
        return (amt <= 100.0 ? 100.0 - amt : amt) / 100.0;
    }

    private AdaptType getAdaptType(PowerUser user, EntityDamageEvent.DamageCause cause) {
        if (user.getOption(this.explosionTypes).contains(cause.name())) {
            return AdaptType.EXPLOSION;
        }
        if (user.getOption(this.fireTypes).contains(cause.name())) {
            return AdaptType.FIRE;
        }
        if (user.getOption(this.iceTypes).contains(cause.name())) {
            return AdaptType.ICE;
        }
        if (user.getOption(this.lightningTypes).contains(cause.name())) {
            return AdaptType.LIGHTNING;
        }
        if (user.getOption(this.magicTypes).contains(cause.name())) {
            return AdaptType.MAGIC;
        }
        if (user.getOption(this.natureTypes).contains(cause.name())) {
            return AdaptType.NATURE;
        }
        if (user.getOption(this.physicalTypes).contains(cause.name())) {
            return AdaptType.PHYSICAL;
        }
        if (user.getOption(this.poisonTypes).contains(cause.name())) {
            return AdaptType.POISON;
        }
        if (user.getOption(this.projectileTypes).contains(cause.name())) {
            return AdaptType.PROJECTILE;
        }
        if (user.getOption(this.shadowTypes).contains(cause.name())) {
            return AdaptType.SHADOW;
        }
        if (user.getOption(this.waterTypes).contains(cause.name())) {
            return AdaptType.WATER;
        }
        return null;
    }

    @EventHandler
    private void onClose(InventoryCloseEvent event) {
        PowerUser user;
        if (event.getPlayer() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)event.getPlayer()))).allowPower(this) && user.getOption(this.noArmor).booleanValue() && user.getPlayer().getInventory().getArmorContents() != null) {
            boolean hadArmor = false;
            for (ItemStack armor : user.getPlayer().getInventory().getArmorContents()) {
                if (armor == null || armor.getType() == Material.AIR) continue;
                user.getPlayer().getWorld().dropItem(user.getPlayer().getLocation(), armor);
                hadArmor = true;
            }
            if (hadArmor) {
                user.sendMessage(this.preventArmor);
            }
            user.getPlayer().getInventory().setArmorContents(null);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onDmg(EntityDamageEvent event) {
        if (event.getEntity() instanceof Player) {
            PowerUser user = this.getUser((OfflinePlayer)((Player)event.getEntity()));
            AdaptType type = this.getAdaptType(user, event.getCause());
            if (user.allowPower(this) && type != null) {
                if (!this.aUsers.containsKey(user)) {
                    this.aUsers.put(user, new AdaptUser(null, 0.0));
                }
                double dmg = this.adapt(user, type);
                event.setDamage(event.getDamage() * dmg);
            }
        }
    }

    private class AdaptUser {
        private double amount;
        private AdaptType type;

        public AdaptUser(AdaptType type, double amount) {
            this.type = type;
            this.amount = amount;
        }

        public double getAmount() {
            return this.amount;
        }

        public AdaptType getType() {
            return this.type;
        }

        public void increaseAmount(double amount) {
            this.amount += amount;
        }

        public AdaptUser setAmount(double amount) {
            this.amount = amount;
            return this;
        }

        public AdaptUser setType(AdaptType type) {
            this.type = type;
            return this;
        }
    }

    private static enum AdaptType {
        EXPLOSION,
        FIRE,
        ICE,
        LIGHTNING,
        MAGIC,
        NATURE,
        PHYSICAL,
        POISON,
        PROJECTILE,
        SHADOW,
        WATER;

    }
}

