/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import me.sirrus86.s86powers.S86Powers;
import me.sirrus86.s86powers.config.ConfigOption;
import me.sirrus86.s86powers.localization.LocaleString;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerStat;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.users.PowerUser;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Explosive;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public abstract class Power
implements Comparable<Power>,
Listener {
    private Map<PowerOption<?>, Object> options = new HashMap();
    private List<ItemStack> supplies = new ArrayList<ItemStack>();
    private Map<PowerStat, Integer> stats = new HashMap<PowerStat, Integer>();
    private Set<Integer> tasks = new HashSet<Integer>();
    private Set<PowerUser> users = new HashSet<PowerUser>();
    private File cFile;
    private File defLocFile;
    private File locFile;
    private YamlConfiguration config;
    private YamlConfiguration defLocConfig;
    private YamlConfiguration locConfig;
    private boolean enabled = true;
    private boolean locked = false;
    private final Permission aPerm;
    private final Permission perm;
    @Deprecated
    protected boolean incomplete = false;
    private final PowerManifest manifest = this.getClass().getAnnotation(PowerManifest.class);
    private static final S86Powers plugin = (S86Powers)JavaPlugin.getPlugin(S86Powers.class);
    private String description;
    private String name;
    private String tag = this.getClass().getSimpleName();
    protected static final Random random = new Random();
    protected static final NamespacedKey collectorKey = new NamespacedKey((Plugin)plugin, "powercollector.power-key");
    protected PowerOption<Long> cooldown;
    protected PowerOption<ItemStack> consumable;
    protected PowerOption<ItemStack> item;
    protected PowerOption<Boolean> wAxe;
    protected PowerOption<Boolean> wItem;
    protected PowerOption<Boolean> wSword;

    protected void onEnable() {
    }

    protected void onEnable(PowerUser user) {
    }

    protected void onDisable() {
    }

    protected void onDisable(PowerUser user) {
    }

    protected abstract void config();

    public Power() {
        File[] files;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        File locFolder = new File(plugin.getPowerDirectory(), "localization");
        if (!locFolder.exists()) {
            locFolder.mkdirs();
        }
        this.cFile = new File(plugin.getPowerDirectory(), this.tag + ".yml");
        this.defLocFile = new File(locFolder, this.tag + "-enUS.yml");
        for (File file : files = new File[]{this.cFile, this.defLocFile}) {
            if (file.exists()) continue;
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                plugin.getLogger().severe(LocaleString.FILE_CREATE_FAIL.build(file));
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.cFile);
        if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
            plugin.getLogger().info(LocaleString.LOAD_SUCCESS.build(this.cFile));
        }
        this.defLocConfig = YamlConfiguration.loadConfiguration((File)this.defLocFile);
        if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
            plugin.getLogger().info(LocaleString.LOAD_SUCCESS.build(this.defLocFile));
        }
        this.locFile = new File(locFolder, this.tag + "-" + ConfigOption.Plugin.LOCALIZATION + ".yml");
        this.locConfig = this.locFile.exists() ? YamlConfiguration.loadConfiguration((File)this.locFile) : this.defLocConfig;
        this.aPerm = new Permission("s86powers.assign." + this.tag, "Allows player to assign " + this.getName() + ".", PermissionDefault.TRUE);
        this.perm = new Permission("s86powers.power." + this.tag, "Allows player to use  " + this.getName() + " regardless if assigned or not.", PermissionDefault.FALSE);
        if (!plugin.getServer().getPluginManager().getPermissions().contains(this.aPerm)) {
            plugin.getServer().getPluginManager().addPermission(this.aPerm);
        }
        if (!plugin.getServer().getPluginManager().getPermissions().contains(this.perm)) {
            plugin.getServer().getPluginManager().addPermission(this.perm);
        }
        this.getTag();
        this.getName();
        this.getDescription();
    }

    public void addUser(PowerUser user) {
        this.users.add(user);
    }

    protected void callEvent(Event event) {
        plugin.getServer().getPluginManager().callEvent(event);
    }

    protected void cancelTask(int taskId) {
        if (plugin.getServer().getScheduler().isCurrentlyRunning(taskId) || plugin.getServer().getScheduler().isQueued(taskId)) {
            plugin.getServer().getScheduler().cancelTask(taskId);
        }
    }

    public boolean canUseAnyAxe() {
        return this.hasOption(this.wAxe) ? this.getOption(this.wAxe) : false;
    }

    public boolean canUseSpecificItem() {
        return this.hasOption(this.wItem) ? this.getOption(this.wItem) : true;
    }

    public boolean canUseAnySword() {
        return this.hasOption(this.wSword) ? this.getOption(this.wSword) : false;
    }

    @Override
    public int compareTo(Power p) {
        String o1Str = this.getName();
        String o2Str = p.getName();
        List<String> tmp = Arrays.asList(o1Str, o2Str);
        Collections.sort(tmp);
        if (tmp.get(0).equalsIgnoreCase(this.getName())) {
            return -1;
        }
        return 1;
    }

    protected NamespacedKey createNamespacedKey(String key) {
        return new NamespacedKey((Plugin)plugin, this.tag.toLowerCase() + "." + key.toLowerCase());
    }

    public void disable() {
        for (PowerUser user : this.getUsers()) {
            this.disable(user);
        }
        this.onDisable();
        if (Arrays.asList(this.getClass().getInterfaces()).contains(Listener.class)) {
            HandlerList.unregisterAll((Listener)this);
        }
        Iterator<Comparable<PowerUser>> iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (!plugin.getServer().getScheduler().isCurrentlyRunning(i) && !plugin.getServer().getScheduler().isQueued(i)) continue;
            plugin.getServer().getScheduler().cancelTask(i);
        }
        this.tasks.clear();
        this.enabled = false;
    }

    public void disable(PowerUser user) {
        this.onDisable(user);
    }

    public void enable() {
        if (Arrays.asList(this.getClass().getInterfaces()).contains(Listener.class)) {
            plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        }
        this.reload();
        this.enabled = true;
        for (PowerUser user : this.getUsers()) {
            this.enable(user);
        }
    }

    public void enable(PowerUser user) {
        this.onEnable(user);
    }

    public final Permission getAssignPermission() {
        return this.aPerm;
    }

    public String getAuthor() {
        return this.manifest.author();
    }

    public String getConcept() {
        return this.manifest.concept();
    }

    protected ItemStack getConsumable() {
        return this.hasOption(this.consumable) ? this.getOption(this.consumable) : null;
    }

    protected long getCooldown() {
        return this.hasOption(this.cooldown) ? this.getOption(this.cooldown) : 0L;
    }

    public final YamlConfiguration getConfig() {
        return this.config;
    }

    public final String getDescription() {
        if (this.description == null) {
            this.description = this.locale("manifest.description", this.manifest.description());
        }
        return this.description;
    }

    public Object getFieldValue(String option) {
        Field field = null;
        Object object = null;
        try {
            field = this.getClass().getDeclaredField(option);
            field.setAccessible(true);
            object = field.get(this);
        }
        catch (NoSuchFieldException e) {
            try {
                field = this.getClass().getSuperclass().getDeclaredField(option);
                field.setAccessible(true);
                object = field.get(this);
            }
            catch (Exception e1) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return object;
    }

    public Material getIcon() {
        return this.manifest.icon();
    }

    protected Power getInstance() {
        return this;
    }

    public final String getName() {
        if (this.name == null) {
            this.name = this.locale("manifest.name", this.manifest.name());
        }
        return this.name;
    }

    public <O> O getOption(PowerOption<O> option) {
        return (O)this.options.get(option);
    }

    public PowerOption<?> getOptionByName(String path) {
        for (PowerOption<?> option : this.options.keySet()) {
            if (!option.getPath().equalsIgnoreCase(path)) continue;
            return option;
        }
        return null;
    }

    public PowerOption<?> getOptionByField(String field) {
        return (PowerOption)this.getFieldValue(field);
    }

    public Map<PowerOption<?>, Object> getOptions() {
        return this.options;
    }

    public static NamespacedKey getCollectorKey() {
        return collectorKey;
    }

    public ItemStack getRequiredItem() {
        return this.hasOption(this.item) ? this.getOption(this.item) : null;
    }

    public PowerStat getStat(String name) {
        for (PowerStat stat : this.stats.keySet()) {
            if (!stat.getPath().equalsIgnoreCase(name)) continue;
            return stat;
        }
        return null;
    }

    public Map<PowerStat, Integer> getStats() {
        return this.stats;
    }

    public int getStatValue(PowerStat stat) {
        return this.stats.containsKey(stat) ? this.stats.get(stat) : 0;
    }

    public List<ItemStack> getSupplies() {
        return this.supplies;
    }

    public final String getTag() {
        if (this.tag == null) {
            this.tag = this.locale("manifest.tag", this.getClass().getSimpleName());
        }
        return this.tag;
    }

    public final PowerType getType() {
        return this.manifest.type();
    }

    public final Permission getUsePermission() {
        return this.perm;
    }

    protected final PowerUser getUser(OfflinePlayer player) {
        return S86Powers.getConfigManager().getUser(player.getUniqueId());
    }

    protected final PowerUser getUser(String name) {
        return S86Powers.getConfigManager().getUser(name);
    }

    protected final PowerUser getUser(UUID uuid) {
        return S86Powers.getConfigManager().getUser(uuid);
    }

    public Set<PowerUser> getUsers() {
        this.updateUsers();
        return this.users;
    }

    private boolean hasOption(PowerOption<?> option) {
        return this.options.containsKey(option);
    }

    boolean hasSupply(int index) {
        return index >= 0 && index < this.supplies.size();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isLocked() {
        return this.locked;
    }

    protected boolean isTaskLive(int taskId) {
        return plugin.getServer().getScheduler().isCurrentlyRunning(taskId) || plugin.getServer().getScheduler().isQueued(taskId);
    }

    protected String locale(String path, String defValue) {
        if (!this.defLocConfig.contains(path) || !this.defLocConfig.getString(path).equals(defValue)) {
            this.defLocConfig.set(path, (Object)defValue);
            try {
                this.defLocConfig.save(this.defLocFile);
                if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
                    S86Powers.log(Level.INFO, LocaleString.SAVE_SUCCESS.build(this.defLocFile));
                }
            }
            catch (IOException e) {
                if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
                    S86Powers.log(Level.SEVERE, LocaleString.SAVE_FAIL.build(this.defLocFile));
                }
                e.printStackTrace();
            }
        }
        return this.locConfig.getString(path, this.defLocConfig.getString(path));
    }

    protected void monitorExplosive(Explosive explosive) {
        plugin.getBlockListener().addExplosive(explosive);
    }

    protected <O> PowerOption<O> option(String path, O defValue, String desc) {
        return this.option(path, defValue, desc, false);
    }

    protected <O> PowerOption<O> option(String path, O defValue, String desc, boolean locked) {
        PowerOption<Object> option = this.getOptionByName(path);
        if (option == null) {
            option = new PowerOption(this, path, defValue, this.locale("options." + path + ".description", desc), locked);
        }
        if (!this.options.containsKey(option) && !locked) {
            if (!this.config.contains("options." + option.getPath())) {
                this.config.set("options." + option.getPath(), defValue);
                this.saveConfig();
            }
            this.options.put(option, defValue instanceof Long ? Long.valueOf(this.config.getLong("options." + option.getPath(), ((Long)defValue).longValue())) : (defValue instanceof Float ? Float.valueOf((float)this.config.getDouble("options." + option.getPath(), (double)((Float)defValue).floatValue())) : this.config.get("options." + option.getPath(), defValue)));
        }
        return option;
    }

    public void refreshOptions() {
        this.config();
    }

    public void registerEvents(Listener listener) {
        plugin.getServer().getPluginManager().registerEvents(listener, (Plugin)plugin);
    }

    public void reload() {
        this.onEnable();
        this.config();
    }

    public void removeUser(PowerUser user) {
        this.onDisable(user);
        this.users.remove(user);
    }

    public void removeSupply(int index) {
        this.supplies.remove(index);
    }

    public BukkitTask runTask(Runnable runnable) {
        BukkitTask task = plugin.getServer().getScheduler().runTask((Plugin)plugin, runnable);
        this.tasks.add(task.getTaskId());
        return task;
    }

    public BukkitTask runTaskLater(Runnable runnable, long delay) {
        BukkitTask task = plugin.getServer().getScheduler().runTaskLater((Plugin)plugin, runnable, delay);
        this.tasks.add(task.getTaskId());
        return task;
    }

    public BukkitTask runTaskTimer(Runnable runnable, long delay, long period) {
        BukkitTask task = plugin.getServer().getScheduler().runTaskTimer((Plugin)plugin, runnable, delay, period);
        this.tasks.add(task.getTaskId());
        return task;
    }

    public void saveConfig() {
        for (PowerOption<?> option : this.options.keySet()) {
            this.config.createSection("options." + option.getPath());
            this.config.set("options." + option.getPath(), this.options.get(option));
        }
        for (PowerStat stat : this.stats.keySet()) {
            this.config.createSection("stats." + stat.getPath());
            this.config.set("stats." + stat.getPath(), (Object)this.stats.get(stat));
        }
        for (int i = 0; i < this.supplies.size(); ++i) {
            this.config.createSection("supplies.item" + i);
            this.config.set("supplies.item" + i, (Object)this.supplies.get(i));
        }
        if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
            plugin.getLogger().info(LocaleString.SAVE_ATTEMPT.build(this.cFile));
        }
        try {
            this.config.save(this.cFile);
            if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
                plugin.getLogger().info(LocaleString.SAVE_SUCCESS.build(this.cFile));
            }
        }
        catch (IOException e) {
            plugin.getLogger().severe(LocaleString.SAVE_FAIL.build(this.cFile));
            e.printStackTrace();
        }
    }

    public boolean setEnabled(boolean enable) {
        if (!this.locked) {
            if (enable) {
                this.enable();
                return true;
            }
            this.disable();
            return true;
        }
        return false;
    }

    public void setLocked(boolean lock) {
        this.locked = lock;
    }

    public void setOption(PowerOption<?> option, Object value) {
        this.options.put(option, value);
        if (ConfigOption.Plugin.AUTO_SAVE) {
            this.saveConfig();
        }
        this.refreshOptions();
    }

    public void setStatValue(PowerStat stat, int value) {
        if (this.stats.containsKey(stat)) {
            this.stats.put(stat, value);
        }
    }

    public void setSupply(int index, ItemStack stack) {
        if (index >= this.supplies.size()) {
            this.supplies.add(stack);
        } else {
            this.supplies.set(index, stack);
        }
        if (ConfigOption.Plugin.AUTO_SAVE) {
            this.saveConfig();
        }
        this.refreshOptions();
    }

    public void showDebug(String message) {
        S86Powers.showDebug(this.tag + " > " + message);
    }

    protected PowerStat stat(String path, int defValue, String description, String reward) {
        PowerStat stat = this.getStat(path);
        if (stat == null) {
            stat = new PowerStat(this, path, defValue, this.locale("stats." + path + ".description", description), this.locale("stats." + path + ".reward", reward));
        }
        if (!this.stats.containsKey(stat)) {
            if (!this.config.contains("stats." + stat.getPath())) {
                this.config.set("stats." + stat.getPath(), (Object)defValue);
            }
            this.stats.put(stat, this.config.getInt("stats." + stat.getPath(), defValue));
        }
        return stat;
    }

    protected void supplies(ItemStack ... stacks) {
        if (this.supplies.isEmpty()) {
            this.supplies.addAll(Lists.newArrayList((Object[])stacks));
        }
    }

    public void unregisterEvents(Listener listener) {
        HandlerList.unregisterAll((Listener)listener);
    }

    private void updateUsers() {
        for (PowerUser user : Sets.newHashSet(this.users)) {
            if (user.hasPower(this)) continue;
            this.users.remove(user);
        }
        for (PowerUser user : S86Powers.getConfigManager().getUserList()) {
            if (!user.hasPower(this) || this.users.contains(user)) continue;
            this.users.add(user);
        }
    }

    @EventHandler
    private void onLoad(ServerLoadEvent event) {
        for (PowerUser user : this.getUsers()) {
            this.onEnable(user);
        }
    }
}

