/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.localization;

import java.io.File;
import java.io.IOException;
import me.sirrus86.s86powers.S86Powers;
import me.sirrus86.s86powers.config.ConfigOption;
import me.sirrus86.s86powers.localization.LocaleString;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public final class LocaleLoader {
    private final YamlConfiguration defYaml;
    private final File locDir = new File(plugin.getDataFolder(), "localization");
    private static File locFile;
    protected static YamlConfiguration LOCALIZATION_YAML;
    private final String header = "To create your own localization file, make a copy of this file, name the copied file\nsomething with no spaces, then replace the text to the right of the colon with what\nshould be read. To ensure a given line is readable by the plugin, leave any single quotes\nas-is. If any given line is deleted or unreadable, the plugin will use the default enUS\nline when needed.\n\nWords following an ampersand '&' are replaced by the plugin with the below data:\n&class - Gets the name of the specified class\n&cooldown - Renders the number as a long string, e.g. one minute five seconds\n&file - Gets the name of the specified file\n&group - Gets the name of the specified group\n&int - Gets a number supplied by the plugin\n&player - Gets the name of the specified player\n&power - Gets the name of the specified power\n&string - Is replaced by an expected string\n&syntax - Gets the help syntax for a specified command\n&type - Gets the name of the specified power type\n&value - Gets the expected value and outputs as string\n\nWhen changing a message, be sure to keep the above words in the message.\nRemoving a special word from a message leaves it with no way to render unique info.\nAdding special words that weren't originally in the message has no effect.\n\nOnce the new file is created, run the following command in-game or from the console:\n/p config set plugin.localization newfile\nReplacing newfile with the file you created, minus the .yml extension.\nYou can alternatively edit the config.yml file directly while the server is inactive.\n\nNote: Editing this file (enUS.yml) is pointless as it is overwritten every time the\nserver restarts.";
    private static final S86Powers plugin;

    public LocaleLoader() throws IOException {
        if (!this.locDir.exists()) {
            this.locDir.mkdirs();
        }
        locFile = new File(this.locDir, ConfigOption.Plugin.LOCALIZATION + ".yml");
        LOCALIZATION_YAML = YamlConfiguration.loadConfiguration((File)locFile);
        File defLocFile = new File(this.locDir, "enUS.yml");
        if (!defLocFile.exists()) {
            defLocFile.createNewFile();
        }
        this.defYaml = YamlConfiguration.loadConfiguration((File)defLocFile);
        this.defYaml.options().header("To create your own localization file, make a copy of this file, name the copied file\nsomething with no spaces, then replace the text to the right of the colon with what\nshould be read. To ensure a given line is readable by the plugin, leave any single quotes\nas-is. If any given line is deleted or unreadable, the plugin will use the default enUS\nline when needed.\n\nWords following an ampersand '&' are replaced by the plugin with the below data:\n&class - Gets the name of the specified class\n&cooldown - Renders the number as a long string, e.g. one minute five seconds\n&file - Gets the name of the specified file\n&group - Gets the name of the specified group\n&int - Gets a number supplied by the plugin\n&player - Gets the name of the specified player\n&power - Gets the name of the specified power\n&string - Is replaced by an expected string\n&syntax - Gets the help syntax for a specified command\n&type - Gets the name of the specified power type\n&value - Gets the expected value and outputs as string\n\nWhen changing a message, be sure to keep the above words in the message.\nRemoving a special word from a message leaves it with no way to render unique info.\nAdding special words that weren't originally in the message has no effect.\n\nOnce the new file is created, run the following command in-game or from the console:\n/p config set plugin.localization newfile\nReplacing newfile with the file you created, minus the .yml extension.\nYou can alternatively edit the config.yml file directly while the server is inactive.\n\nNote: Editing this file (enUS.yml) is pointless as it is overwritten every time the\nserver restarts.");
        for (LocaleString string : LocaleString.values()) {
            this.defYaml.set(string.getPath(), (Object)string.getDefaultText());
        }
        this.defYaml.save(defLocFile);
        LOCALIZATION_YAML.setDefaults((Configuration)this.defYaml);
    }

    static {
        plugin = (S86Powers)JavaPlugin.getPlugin(S86Powers.class);
    }
}

