/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.listeners;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.sirrus86.s86powers.S86Powers;
import me.sirrus86.s86powers.config.ConfigOption;
import me.sirrus86.s86powers.events.PowerDamageEvent;
import me.sirrus86.s86powers.events.PowerIgniteEvent;
import me.sirrus86.s86powers.powers.PowerFire;
import me.sirrus86.s86powers.tools.PowerTools;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Fire;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Explosive;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BlockListener
implements Listener {
    private Map<Block, PowerFire> bList = new HashMap<Block, PowerFire>();
    private Map<Entity, PowerFire> burnList = new ConcurrentHashMap<Entity, PowerFire>();
    private Set<Explosive> eList = new HashSet<Explosive>();
    private final Fire fireData = (Fire)Material.FIRE.createBlockData();
    private final S86Powers plugin;
    private Runnable manage = new BukkitRunnable(){

        public void run() {
            for (Entity entity : BlockListener.this.burnList.keySet()) {
                if (entity.getFireTicks() > 0) continue;
                BlockListener.this.burnList.remove(entity);
            }
        }
    };

    public BlockListener(S86Powers plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        plugin.getServer().getScheduler().runTaskTimer((Plugin)plugin, this.manage, 0L, 5L);
    }

    public void addExplosive(Explosive exp) {
        this.eList.add(exp);
    }

    public void addIgnite(Entity entity, PowerFire fire) {
        this.burnList.put(entity, fire);
    }

    @EventHandler(ignoreCancelled=true)
    private void onBreak(BlockBreakEvent event) {
        if (S86Powers.getProtocolLib() != null && PowerTools.hasDisguise(event.getBlock())) {
            PowerTools.blockUpdate(event.getBlock());
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onBurn(BlockBurnEvent event) {
        for (BlockFace face : BlockFace.values()) {
            if (!this.bList.containsKey(event.getBlock().getRelative(face)) || !ConfigOption.Powers.PREVENT_GRIEFING) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onFade(BlockFadeEvent event) {
        if (this.bList.containsKey(event.getBlock()) && event.getNewState().getType() != Material.FIRE) {
            this.bList.remove(event.getBlock());
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onIgnite(BlockIgniteEvent event) {
        block3: {
            try {
                if (!this.bList.containsKey(event.getIgnitingBlock()) || !ConfigOption.Powers.PREVENT_GRIEFING) break block3;
                event.setCancelled(true);
            }
            catch (Exception e) {
                for (BlockFace face : BlockFace.values()) {
                    if (!this.bList.containsKey(event.getBlock().getRelative(face)) || !ConfigOption.Powers.PREVENT_GRIEFING) continue;
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onSpread(BlockSpreadEvent event) {
        if (this.bList.containsKey(event.getBlock()) && ConfigOption.Powers.PREVENT_GRIEFING) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onCombust(EntityCombustEvent event) {
        for (Block block : PowerTools.getNearbyBlocks(event.getEntity().getLocation(), 1.5)) {
            if (block.getType() != Material.FIRE || !this.bList.containsKey(block)) continue;
            this.burnList.put(event.getEntity(), this.bList.get(block));
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onDamage(EntityDamageEvent event) {
        if (this.burnList.containsKey(event.getEntity()) && event.getCause().name().startsWith("FIRE")) {
            PowerFire pFire = this.burnList.get(event.getEntity());
            PowerDamageEvent pEvent = new PowerDamageEvent(pFire.getPower(), pFire.getUser(), event, Double.MAX_VALUE);
            this.plugin.getServer().getPluginManager().callEvent((Event)pEvent);
        }
    }

    @EventHandler
    private void onDeath(EntityDeathEvent event) {
        if (this.burnList.containsKey(event.getEntity())) {
            this.burnList.remove(event.getEntity());
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onExplode(EntityExplodeEvent event) {
        if (this.eList.contains(event.getEntity())) {
            if (ConfigOption.Powers.PREVENT_GRIEFING) {
                event.blockList().clear();
            }
            this.eList.remove(event.getEntity());
        }
    }

    @EventHandler
    private void onIgnite(PowerIgniteEvent event) {
        if (event.getBlock() != null && event.getBlock().getType() == Material.AIR) {
            Block block = event.getBlock();
            BlockPlaceEvent bEvent = new BlockPlaceEvent(block, block.getState(), event.getBlockFace() != null ? block.getRelative(event.getBlockFace().getOppositeFace()) : block, new ItemStack(Material.FIRE), event.getUser().getPlayer(), true, EquipmentSlot.HAND);
            this.plugin.getServer().getPluginManager().callEvent((Event)bEvent);
            if (!bEvent.isCancelled()) {
                block.setType(Material.FIRE);
                for (BlockFace face : this.fireData.getAllowedFaces()) {
                    this.fireData.setFace(face, false);
                }
                if (event.getBlockFace() != null && this.fireData.getAllowedFaces().contains(event.getBlockFace().getOppositeFace())) {
                    this.fireData.setFace(event.getBlockFace().getOppositeFace(), true);
                }
                if (!this.fireData.getFaces().isEmpty()) {
                    block.setBlockData((BlockData)this.fireData);
                }
                this.bList.put(block, new PowerFire(event.getPower(), event.getUser()));
            }
        } else if (event.getEntity() != null) {
            event.getEntity().setFireTicks(10);
            this.burnList.put(event.getEntity(), new PowerFire(event.getPower(), event.getUser()));
        }
    }
}

