/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.gui;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.sirrus86.s86powers.gui.GUIAbstract;
import me.sirrus86.s86powers.gui.GUIAbstractList;
import me.sirrus86.s86powers.gui.GUIAction;
import me.sirrus86.s86powers.gui.GUIBase;
import me.sirrus86.s86powers.localization.LocaleString;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerGroup;
import me.sirrus86.s86powers.users.PowerUser;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GUIPowerList
extends GUIAbstractList<Power> {
    static Map<Power, ItemStack> powerItems = new HashMap<Power, ItemStack>();

    public GUIPowerList(int page, Collection<Power> list) {
        super(page, list);
    }

    private void setItem(int slot, Power power, GUIAction action) {
        if (!powerItems.containsKey(power)) {
            String powerName = ChatColor.RESET + "" + power.getType().getColor() + power.getName();
            String powerDesc = PowerTools.getFilteredText(power, power.getDescription());
            List<String> lore = PowerTools.wordSplit(ChatColor.RESET.toString() + ChatColor.GRAY.toString(), powerDesc, 30);
            powerItems.put(power, GUIPowerList.createItem(power.getIcon(), powerName, lore));
        }
        this.setItem(slot, powerItems.get(power), action);
    }

    @Override
    void setItems() {
        if (this.page > 0) {
            int index;
            for (int i = index = this.page * 45 - 45; i < Math.min(this.list.size(), index + 45); ++i) {
                Power power = (Power)this.list.get(i);
                this.setItem(i - index, power, (Player player) -> {
                    if (selectedGroup.containsKey(player.getUniqueId())) {
                        PowerGroup group = (PowerGroup)selectedGroup.get(player.getUniqueId());
                        if (group.hasPower(power)) {
                            player.closeInventory();
                            player.performCommand("powers group " + group.getName() + " remove " + power.getTag());
                        } else {
                            player.closeInventory();
                            player.performCommand("powers group " + group.getName() + " add " + power.getTag());
                        }
                    } else if (selectedUser.containsKey(player.getUniqueId())) {
                        PowerUser user = (PowerUser)selectedUser.get(player.getUniqueId());
                        if (user.hasPower(power)) {
                            player.closeInventory();
                            player.performCommand("powers player " + (user.getName() != null ? user.getName() : "!NULL") + " remove " + power.getTag());
                        } else {
                            player.closeInventory();
                            player.performCommand("powers player " + (user.getName() != null ? user.getName() : "!NULL") + " add " + power.getTag());
                        }
                    } else {
                        selectedPower.put(player.getUniqueId(), power);
                        this.openNext(player, GUIBase.POWER_GUI);
                    }
                });
            }
            this.setItem(48, BACK, (Player player) -> this.openLast(player));
            if (this.page > 1) {
                this.setItem(49, PAGE1, LocaleString.PAGE.toString() + " " + Integer.toString(this.page - 1), null, player -> this.openGUI(player, (GUIAbstract)this.sourceList.get(this.page - 2)));
            }
            if (this.page < this.sourceList.size()) {
                this.setItem(50, PAGE2, LocaleString.PAGE.toString() + " " + Integer.toString(this.page + 1), null, player -> this.openGUI(player, (GUIAbstract)this.sourceList.get(this.page)));
            }
        }
    }
}

