/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.sirrus86.s86powers.S86Powers;
import me.sirrus86.s86powers.gui.GUIAbstract;
import me.sirrus86.s86powers.gui.GUIAbstractList;
import me.sirrus86.s86powers.gui.GUIOptionList;
import me.sirrus86.s86powers.gui.GUIPowerList;
import me.sirrus86.s86powers.localization.LocaleString;
import me.sirrus86.s86powers.permissions.S86Permission;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.tools.PowerTools;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public final class GUIPower
extends GUIAbstract {
    private static Map<Power, List<GUIOptionList>> powerOptionList = new HashMap<Power, List<GUIOptionList>>();
    static List<GUIPowerList> POWER_LIST_GUI = new ArrayList<GUIPowerList>();
    static final ItemStack INFO = GUIPower.createItem(Material.FILLED_MAP, LocaleString.INFO.toString(), PowerTools.wordSplit(ChatColor.RESET.toString() + ChatColor.GRAY.toString(), LocaleString.POWER_INFO_HELP.toString(), 30));
    static final ItemStack OPTIONS = GUIPower.createItem(Material.FILLED_MAP, LocaleString.OPTIONS.toString(), PowerTools.wordSplit(ChatColor.RESET.toString() + ChatColor.GRAY.toString(), LocaleString.POWER_OPTION_HELP.toString(), 30));
    static final ItemStack ENABLE = GUIPower.createItem(Material.REDSTONE_TORCH, LocaleString.ENABLE.toString(), PowerTools.wordSplit(ChatColor.RESET.toString() + ChatColor.GRAY.toString(), LocaleString.POWER_ENABLE_HELP.toString(), 30));
    static final ItemStack DISABLE = GUIPower.createItem(Material.BARRIER, LocaleString.DISABLE.toString(), PowerTools.wordSplit(ChatColor.RESET.toString() + ChatColor.GRAY.toString(), LocaleString.POWER_DISABLE_HELP.toString(), 30));

    public GUIPower() {
        super(2, LocaleString.POWER.toString());
        this.refresh();
    }

    @Override
    void refresh() {
        POWER_LIST_GUI = GUIAbstractList.createLists(GUIPowerList.class, S86Powers.getConfigManager().getPowers(), new Collection[0]);
        for (int i = 0; i < POWER_LIST_GUI.size(); ++i) {
            POWER_LIST_GUI.get(i).setSourceList(POWER_LIST_GUI);
        }
    }

    @Override
    void setItems() {
        this.setItem(0, INFO, player -> {
            Power power = (Power)selectedPower.get(player.getUniqueId());
            player.closeInventory();
            player.performCommand("powers power " + power.getTag() + " info");
        });
        this.setItem(2, OPTIONS, player -> {
            Power power = (Power)selectedPower.get(player.getUniqueId());
            if (player.hasPermission(S86Permission.POWER_OPTION)) {
                powerOptionList.put(power, GUIAbstractList.createLists(GUIOptionList.class, power.getOptions().keySet(), new Collection[0]));
                for (int i = 0; i < powerOptionList.get(power).size(); ++i) {
                    powerOptionList.get(power).get(i).setSourceList(powerOptionList.get(power));
                }
                this.openNext(player, powerOptionList.get(power).get(0));
            } else {
                player.closeInventory();
                player.performCommand("powers power " + power.getTag() + " option");
            }
        });
        this.setItem(7, ENABLE, player -> {
            Power power = (Power)selectedPower.get(player.getUniqueId());
            player.closeInventory();
            player.performCommand("powers power " + power.getTag() + " enable");
        });
        this.setItem(8, DISABLE, player -> {
            Power power = (Power)selectedPower.get(player.getUniqueId());
            player.closeInventory();
            player.performCommand("powers power " + power.getTag() + " disable");
        });
        this.setItem(12, BACK, player -> this.openLast(player));
    }
}

