/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.gui;

import java.util.Collection;
import me.sirrus86.s86powers.gui.GUIAbstract;
import me.sirrus86.s86powers.gui.GUIAbstractList;
import me.sirrus86.s86powers.gui.GUIAction;
import me.sirrus86.s86powers.gui.GUIBase;
import me.sirrus86.s86powers.localization.LocaleString;
import me.sirrus86.s86powers.users.PowerGroup;
import me.sirrus86.s86powers.users.PowerUser;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class GUIPlayerList
extends GUIAbstractList<PowerUser> {
    public GUIPlayerList(int page, Collection<PowerUser> list) {
        super(page, list);
    }

    private void setItem(int slot, OfflinePlayer player, String name, GUIAction action) {
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta meta = item.hasItemMeta() ? item.getItemMeta() : Bukkit.getServer().getItemFactory().getItemMeta(Material.PLAYER_HEAD);
        meta.setDisplayName(ChatColor.RESET + name);
        meta.addItemFlags(ItemFlag.values());
        if (meta instanceof SkullMeta) {
            SkullMeta skullMeta = (SkullMeta)meta;
            skullMeta.setOwningPlayer(player);
        }
        item.setItemMeta(meta);
        this.guiInv.setItem(slot, item);
        if (action != null) {
            this.actions.put(slot, action);
        }
    }

    @Override
    protected void setItems() {
        if (this.page > 0) {
            int index;
            for (int i = index = this.page * 45 - 45; i < Math.min(this.list.size(), index + 45); ++i) {
                PowerUser user = (PowerUser)this.list.get(i);
                String userName = user.getName();
                this.setItem(i - index, user.getOfflinePlayer(), ChatColor.RESET + userName, player -> {
                    if (selectedGroup.containsKey(player.getUniqueId())) {
                        PowerGroup group = (PowerGroup)selectedGroup.get(player.getUniqueId());
                        if (group.hasMember(user)) {
                            player.closeInventory();
                            player.performCommand("powers group " + group.getName() + " kick " + (user.getName() != null ? user.getName() : "!NULL"));
                        } else {
                            player.closeInventory();
                            player.performCommand("powers group " + group.getName() + " assign " + (user.getName() != null ? user.getName() : "!NULL"));
                        }
                    } else {
                        selectedUser.put(player.getUniqueId(), user);
                        this.openNext(player, GUIBase.PLAYER_GUI);
                    }
                });
            }
            this.setItem(48, BACK, player -> this.openLast(player));
            if (this.page > 1) {
                this.setItem(49, PAGE1, LocaleString.PAGE.toString() + " " + Integer.toString(this.page - 1), null, player -> this.openGUI(player, (GUIAbstract)this.sourceList.get(this.page - 2)));
            }
            if (this.page < this.sourceList.size()) {
                this.setItem(50, PAGE2, LocaleString.PAGE.toString() + " " + Integer.toString(this.page + 1), null, player -> this.openGUI(player, (GUIAbstract)this.sourceList.get(this.page)));
            }
        }
    }
}

