/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.sirrus86.s86powers.S86Powers;
import me.sirrus86.s86powers.gui.GUIAbstract;
import me.sirrus86.s86powers.gui.GUIAbstractList;
import me.sirrus86.s86powers.gui.GUIPlayerList;
import me.sirrus86.s86powers.gui.GUIPowerList;
import me.sirrus86.s86powers.localization.LocaleString;
import me.sirrus86.s86powers.permissions.S86Permission;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class GUIPlayer
extends GUIAbstract {
    private static Map<PowerUser, List<GUIPowerList>> userAddPowerList = new HashMap<PowerUser, List<GUIPowerList>>();
    private static Map<PowerUser, List<GUIPowerList>> userRemovePowerList = new HashMap<PowerUser, List<GUIPowerList>>();
    static List<GUIPlayerList> PLAYER_LIST_GUI = new ArrayList<GUIPlayerList>();
    static final ItemStack ADD_POWER = GUIPlayer.createItem(Material.BLAZE_POWDER, LocaleString.ADD_POWER.toString(), PowerTools.wordSplit(ChatColor.RESET.toString() + ChatColor.GRAY.toString(), LocaleString.PLAYER_ADD_HELP.toString(), 30));
    static final ItemStack REMOVE_POWER = GUIPlayer.createItem(Material.BLAZE_POWDER, LocaleString.REMOVE_POWER.toString(), PowerTools.wordSplit(ChatColor.RESET.toString() + ChatColor.GRAY.toString(), LocaleString.PLAYER_REMOVE_HELP.toString(), 30));
    static final ItemStack INFO = GUIPlayer.createItem(Material.FILLED_MAP, LocaleString.INFO.toString(), PowerTools.wordSplit(ChatColor.RESET.toString() + ChatColor.GRAY.toString(), LocaleString.PLAYER_INFO_HELP.toString(), 30));

    public GUIPlayer() {
        super(2, LocaleString.PLAYER.toString());
        this.refresh();
    }

    @Override
    void refresh() {
        PLAYER_LIST_GUI = GUIAbstractList.createLists(GUIPlayerList.class, S86Powers.getConfigManager().getUserList(), new Collection[0]);
        for (int i = 0; i < PLAYER_LIST_GUI.size(); ++i) {
            PLAYER_LIST_GUI.get(i).setSourceList(PLAYER_LIST_GUI);
        }
    }

    @Override
    void setItems() {
        this.setItem(0, ADD_POWER, player -> {
            PowerUser user = (PowerUser)selectedUser.get(player.getUniqueId());
            if (player.hasPermission(S86Permission.PLAYER_ADD)) {
                userAddPowerList.put(user, GUIAbstractList.createLists(GUIPowerList.class, S86Powers.getConfigManager().getPowers(), S86Powers.getConfigManager().getPowersByType(PowerType.UTILITY), user.getPowers()));
                for (int i = 0; i < userAddPowerList.get(user).size(); ++i) {
                    userAddPowerList.get(user).get(i).setSourceList(userAddPowerList.get(user));
                }
                this.openNext(player, userAddPowerList.get(user).get(0));
            } else {
                player.closeInventory();
                player.performCommand("powers player " + (user.getName() != null ? user.getName() : "!NULL") + " add");
            }
        });
        this.setItem(1, REMOVE_POWER, player -> {
            PowerUser user = (PowerUser)selectedUser.get(player.getUniqueId());
            if (player.hasPermission(S86Permission.PLAYER_REMOVE)) {
                userRemovePowerList.put(user, GUIAbstractList.createLists(GUIPowerList.class, user.getPowers(), new Collection[0]));
                for (int i = 0; i < userRemovePowerList.get(user).size(); ++i) {
                    userRemovePowerList.get(user).get(i).setSourceList(userRemovePowerList.get(user));
                }
                this.openNext(player, userRemovePowerList.get(user).get(0));
            } else {
                player.closeInventory();
                player.performCommand("powers player " + (user.getName() != null ? user.getName() : "!NULL") + " remove");
            }
        });
        this.setItem(3, INFO, player -> {
            PowerUser user = (PowerUser)selectedUser.get(player.getUniqueId());
            player.closeInventory();
            player.performCommand("powers player " + (user.getName() != null ? user.getName() : "!NULL") + " info");
        });
        this.setItem(12, BACK, player -> this.openLast(player));
    }
}

