/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.gui;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.sirrus86.s86powers.gui.GUIAbstract;
import me.sirrus86.s86powers.gui.GUIAbstractList;
import me.sirrus86.s86powers.localization.LocaleString;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.tools.PowerTools;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class GUIOptionList
extends GUIAbstractList<PowerOption<?>> {
    static Map<PowerOption<?>, ItemStack> optionItems = new HashMap();

    public GUIOptionList(int page, Collection<PowerOption<?>> list) {
        super(page, list);
    }

    @Override
    void setItems() {
        if (this.page > 0) {
            int index;
            for (int i = index = this.page * 45 - 45; i < Math.min(this.list.size(), index + 45); ++i) {
                PowerOption option = (PowerOption)this.list.get(i);
                if (!optionItems.containsKey(option)) {
                    Power power = option.getPower();
                    String optionName = option.getPath();
                    String optionDesc = option.getDescription();
                    String optionValue = ChatColor.RESET + LocaleString.VALUE.toString() + ": " + ChatColor.GRAY + power.getOption(option).toString();
                    List<String> lore = PowerTools.wordSplit(ChatColor.RESET.toString() + ChatColor.GRAY.toString(), optionDesc, 30);
                    lore.addAll(PowerTools.wordSplit(optionValue, 30));
                    optionItems.put(option, GUIOptionList.createItem(Material.PAPER, ChatColor.RESET + optionName, lore));
                }
                this.setItem(i - index, optionItems.get(option), null);
            }
            this.setItem(48, BACK, player -> this.openLast(player));
            if (this.page > 1) {
                this.setItem(49, PAGE1, LocaleString.PAGE.toString() + " " + Integer.toString(this.page - 1), null, player -> this.openGUI(player, (GUIAbstract)this.sourceList.get(this.page - 2)));
            }
            if (this.page < this.sourceList.size()) {
                this.setItem(50, PAGE2, LocaleString.PAGE.toString() + " " + Integer.toString(this.page + 1), null, player -> this.openGUI(player, (GUIAbstract)this.sourceList.get(this.page)));
            }
        }
    }
}

