/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.sirrus86.s86powers.S86Powers;
import me.sirrus86.s86powers.gui.GUIAbstract;
import me.sirrus86.s86powers.gui.GUIAbstractList;
import me.sirrus86.s86powers.gui.GUIGroupList;
import me.sirrus86.s86powers.gui.GUIPlayerList;
import me.sirrus86.s86powers.gui.GUIPowerList;
import me.sirrus86.s86powers.localization.LocaleString;
import me.sirrus86.s86powers.permissions.S86Permission;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerGroup;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class GUIGroup
extends GUIAbstract {
    private static Map<PowerGroup, List<GUIPlayerList>> groupAddPlayerList = new HashMap<PowerGroup, List<GUIPlayerList>>();
    private static Map<PowerGroup, List<GUIPlayerList>> groupRemovePlayerList = new HashMap<PowerGroup, List<GUIPlayerList>>();
    private static Map<PowerGroup, List<GUIPowerList>> groupAddPowerList = new HashMap<PowerGroup, List<GUIPowerList>>();
    private static Map<PowerGroup, List<GUIPowerList>> groupRemovePowerList = new HashMap<PowerGroup, List<GUIPowerList>>();
    static List<GUIGroupList> GROUP_LIST_GUI = new ArrayList<GUIGroupList>();
    static final ItemStack ADD_PLAYER = GUIGroup.createItem(Material.PLAYER_HEAD, LocaleString.ADD_PLAYER.toString(), PowerTools.wordSplit(ChatColor.RESET.toString() + ChatColor.GRAY.toString(), LocaleString.GROUP_ASSIGN_HELP.toString(), 30));
    static final ItemStack ADD_POWER = GUIGroup.createItem(Material.BLAZE_POWDER, LocaleString.ADD_POWER.toString(), PowerTools.wordSplit(ChatColor.RESET.toString() + ChatColor.GRAY.toString(), LocaleString.GROUP_ADD_HELP.toString(), 30));
    static final ItemStack REMOVE_PLAYER = GUIGroup.createItem(Material.PLAYER_HEAD, LocaleString.REMOVE_PLAYER.toString(), PowerTools.wordSplit(ChatColor.RESET.toString() + ChatColor.GRAY.toString(), LocaleString.GROUP_KICK_HELP.toString(), 30));
    static final ItemStack REMOVE_POWER = GUIGroup.createItem(Material.BLAZE_POWDER, LocaleString.REMOVE_POWER.toString(), PowerTools.wordSplit(ChatColor.RESET.toString() + ChatColor.GRAY.toString(), LocaleString.GROUP_REMOVE_HELP.toString(), 30));
    static final ItemStack INFO = GUIGroup.createItem(Material.FILLED_MAP, LocaleString.INFO.toString(), PowerTools.wordSplit(ChatColor.RESET.toString() + ChatColor.GRAY.toString(), LocaleString.GROUP_INFO_HELP.toString(), 30));
    static final ItemStack DELETE = GUIGroup.createItem(Material.BARRIER, LocaleString.DELETE.toString(), PowerTools.wordSplit(ChatColor.RESET.toString() + ChatColor.GRAY.toString(), LocaleString.GROUP_DELETE_HELP.toString(), 30));

    public GUIGroup() {
        super(2, LocaleString.GROUPS.toString());
        this.refresh();
    }

    @Override
    void refresh() {
        GROUP_LIST_GUI = GUIAbstractList.createLists(GUIGroupList.class, S86Powers.getConfigManager().getGroups(), new Collection[0]);
        for (int i = 0; i < GROUP_LIST_GUI.size(); ++i) {
            GROUP_LIST_GUI.get(i).setSourceList(GROUP_LIST_GUI);
        }
    }

    @Override
    void setItems() {
        this.setItem(0, ADD_PLAYER, player -> {
            if (player.hasPermission(S86Permission.GROUP_ASSIGN)) {
                PowerGroup group = (PowerGroup)selectedGroup.get(player.getUniqueId());
                groupAddPlayerList.put(group, GUIAbstractList.createLists(GUIPlayerList.class, S86Powers.getConfigManager().getUserList(), group.getMembers()));
                for (int i = 0; i < groupAddPlayerList.get(group).size(); ++i) {
                    groupAddPlayerList.get(group).get(i).setSourceList(groupAddPlayerList.get(group));
                }
                this.openNext(player, groupAddPlayerList.get(group).get(0));
            } else {
                player.closeInventory();
                player.performCommand("powers group assign");
            }
        });
        this.setItem(1, REMOVE_PLAYER, player -> {
            if (player.hasPermission(S86Permission.GROUP_KICK)) {
                PowerGroup group = (PowerGroup)selectedGroup.get(player.getUniqueId());
                groupRemovePlayerList.put(group, GUIAbstractList.createLists(GUIPlayerList.class, group.getMembers(), new Collection[0]));
                for (int i = 0; i < groupRemovePlayerList.get(group).size(); ++i) {
                    groupRemovePlayerList.get(group).get(i).setSourceList(groupRemovePlayerList.get(group));
                }
                this.openNext(player, groupRemovePlayerList.get(group).get(0));
            } else {
                player.closeInventory();
                player.performCommand("powers group kick");
            }
        });
        this.setItem(3, ADD_POWER, player -> {
            if (player.hasPermission(S86Permission.GROUP_ADD)) {
                PowerGroup group = (PowerGroup)selectedGroup.get(player.getUniqueId());
                groupAddPowerList.put(group, GUIAbstractList.createLists(GUIPowerList.class, S86Powers.getConfigManager().getPowers(), S86Powers.getConfigManager().getPowersByType(PowerType.UTILITY), group.getPowers()));
                for (int i = 0; i < groupAddPowerList.get(group).size(); ++i) {
                    groupAddPowerList.get(group).get(i).setSourceList(groupAddPowerList.get(group));
                }
                this.openNext(player, groupAddPowerList.get(group).get(0));
            } else {
                player.closeInventory();
                player.performCommand("powers group add");
            }
        });
        this.setItem(4, REMOVE_POWER, player -> {
            if (player.hasPermission(S86Permission.GROUP_REMOVE)) {
                PowerGroup group = (PowerGroup)selectedGroup.get(player.getUniqueId());
                groupRemovePowerList.put(group, GUIAbstractList.createLists(GUIPowerList.class, group.getPowers(), new Collection[0]));
                for (int i = 0; i < groupRemovePowerList.get(group).size(); ++i) {
                    groupRemovePowerList.get(group).get(i).setSourceList(groupRemovePowerList.get(group));
                }
                this.openNext(player, groupRemovePowerList.get(group).get(0));
            } else {
                player.closeInventory();
                player.performCommand("powers group remove");
            }
        });
        this.setItem(6, INFO, player -> {
            PowerGroup group = (PowerGroup)selectedGroup.get(player.getUniqueId());
            player.closeInventory();
            player.performCommand("powers group " + group.getName() + " info");
        });
        this.setItem(8, DELETE, player -> {
            PowerGroup group = (PowerGroup)selectedGroup.get(player.getUniqueId());
            player.closeInventory();
            player.performCommand("powers group " + group.getName() + " delete");
        });
        this.setItem(12, BACK, player -> this.openLast(player));
    }
}

