/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.gui;

import java.util.Collection;
import java.util.List;
import me.sirrus86.s86powers.S86Powers;
import me.sirrus86.s86powers.gui.GUIAbstractList;
import me.sirrus86.s86powers.gui.GUIConfig;
import me.sirrus86.s86powers.localization.LocaleString;
import me.sirrus86.s86powers.tools.PowerTools;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class GUIConfigList
extends GUIAbstractList<String> {
    public GUIConfigList(int page, Collection<String> list) {
        super(page, list);
    }

    @Override
    protected void setItems() {
        if (this.page > 0) {
            int index;
            for (int i = index = this.page * 45 - 45; i < Math.min(this.list.size(), index + 45); ++i) {
                String configOption = (String)this.list.get(i);
                String configDesc = LocaleString.getString(configOption.substring(configOption.indexOf(".") + 1).toUpperCase().replaceAll("-", "_") + "_CONFIG");
                String configValue = S86Powers.getConfigManager().getConfigValue(configOption).toString();
                List<String> lore = PowerTools.wordSplit(ChatColor.RESET.toString() + ChatColor.GRAY.toString(), configDesc, 30);
                lore.add(ChatColor.RESET + LocaleString.VALUE.toString() + ": " + ChatColor.GRAY + configValue);
                this.setItem(i - index, new ItemStack(Material.PAPER), configOption, lore, null);
            }
            this.setItem(48, BACK, player -> this.openLast(player));
            if (this.page > 1) {
                this.setItem(49, PAGE1, player -> this.openGUI(player, GUIConfig.CONFIG_LIST_GUI.get(this.page - 2)));
            }
            if (this.page < GUIConfig.CONFIG_LIST_GUI.size()) {
                this.setItem(50, PAGE2, player -> this.openGUI(player, GUIConfig.CONFIG_LIST_GUI.get(this.page)));
            }
        }
    }
}

