/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.gui;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.sirrus86.s86powers.gui.GUIAbstract;
import me.sirrus86.s86powers.localization.LocaleString;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public abstract class GUIAbstractList<T extends Comparable<T>>
extends GUIAbstract {
    private final Collection<T> baseList;
    List<T> list = new ArrayList<T>();
    List<GUIAbstractList<T>> sourceList = new ArrayList<GUIAbstractList<T>>();
    static final ItemStack PAGE1 = new ItemStack(Material.PAPER);
    static final ItemStack PAGE2 = new ItemStack(Material.PAPER);
    int page = 1;

    public GUIAbstractList(int page, Collection<T> list) {
        super(6, LocaleString.LIST.toString());
        this.page = page;
        this.baseList = Collections.unmodifiableCollection(list);
        this.list = Lists.newArrayList(this.baseList);
        Collections.sort(this.list);
    }

    @SafeVarargs
    static <X extends GUIAbstractList<Y>, Y extends Comparable<Y>> List<X> createLists(Class<X> clazz, Collection<Y> list, Collection<Y> ... filters) {
        int size = list.size();
        if (filters != null) {
            for (int i = 0; i < filters.length; ++i) {
                size -= filters[i].size();
            }
        }
        ArrayList<GUIAbstractList> lists = new ArrayList<GUIAbstractList>();
        int j = 1;
        for (int i = size; i > 0; i -= 45) {
            try {
                GUIAbstractList newList = (GUIAbstractList)clazz.getConstructor(Integer.TYPE, Collection.class).newInstance(j, list);
                newList.filterList(filters);
                lists.add(newList);
                ++j;
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return lists;
    }

    @SafeVarargs
    final void filterList(Collection<T> ... filters) {
        this.list = Lists.newArrayList(this.baseList);
        for (int i = 0; i < filters.length; ++i) {
            this.list.removeAll(filters[i]);
        }
        Collections.sort(this.list);
    }

    <X extends GUIAbstractList<T>> void setSourceList(List<X> newSourceList) {
        this.sourceList = newSourceList;
    }
}

