/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.sirrus86.s86powers.S86Powers;
import me.sirrus86.s86powers.gui.GUIAction;
import me.sirrus86.s86powers.localization.LocaleString;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.users.PowerGroup;
import me.sirrus86.s86powers.users.PowerUser;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class GUIAbstract {
    static final S86Powers plugin = (S86Powers)JavaPlugin.getPlugin(S86Powers.class);
    private static final String GUIHEADER = ChatColor.BOLD.toString() + ChatColor.GOLD + "S86 Powers" + ChatColor.RESET + " v" + plugin.getDescription().getVersion() + " by sirrus86";
    static final ItemStack BACK = GUIAbstract.createItem(Material.ARROW, LocaleString.BACK.toString(), null);
    Map<Integer, GUIAction> actions = new HashMap<Integer, GUIAction>();
    private static Map<UUID, GUIAbstract> currentGUI = new HashMap<UUID, GUIAbstract>();
    private static Map<UUID, List<GUIAbstract>> previousGUI = new HashMap<UUID, List<GUIAbstract>>();
    static Map<UUID, PowerGroup> selectedGroup = new HashMap<UUID, PowerGroup>();
    static Map<UUID, Power> selectedPower = new HashMap<UUID, Power>();
    static Map<UUID, PowerUser> selectedUser = new HashMap<UUID, PowerUser>();
    static Map<Power, ItemStack> playerItems = new HashMap<Power, ItemStack>();
    Inventory guiInv;

    public GUIAbstract(int rows, String name) {
        this.guiInv = Bukkit.createInventory(null, (int)(rows * 9), (String)(GUIHEADER + " - " + name));
    }

    void clearHistory(Player player) {
        if (previousGUI.containsKey(player.getUniqueId())) {
            previousGUI.get(player.getUniqueId()).clear();
        }
        selectedGroup.remove(player.getUniqueId());
        selectedPower.remove(player.getUniqueId());
        selectedUser.remove(player.getUniqueId());
    }

    static ItemStack createItem(Material material, String name, List<String> text) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.hasItemMeta() ? item.getItemMeta() : Bukkit.getServer().getItemFactory().getItemMeta(item.getType());
        meta.setDisplayName(ChatColor.RESET + name);
        if (text != null && !text.isEmpty()) {
            meta.setLore(text);
        }
        meta.addItemFlags(ItemFlag.values());
        item.setItemMeta(meta);
        return item;
    }

    public GUIAction getAction(int slot) {
        return this.actions.get(slot);
    }

    public static GUIAbstract getGUI(UUID uuid) {
        return currentGUI.get(uuid);
    }

    public void open(Player player) {
        player.openInventory(this.guiInv);
        currentGUI.put(player.getUniqueId(), this);
    }

    void openGUI(final Player player, final GUIAbstract gui) {
        player.closeInventory();
        if (!currentGUI.containsValue(gui)) {
            gui.reloadGUI();
        }
        plugin.getServer().getScheduler().runTask((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                gui.open(player);
            }
        });
    }

    void openLast(Player player) {
        List<GUIAbstract> lastGUIs;
        if (previousGUI.containsKey(player.getUniqueId()) && !(lastGUIs = previousGUI.get(player.getUniqueId())).isEmpty()) {
            GUIAbstract lastGUI = lastGUIs.get(lastGUIs.size() - 1);
            lastGUIs.remove(lastGUIs.size() - 1);
            previousGUI.put(player.getUniqueId(), lastGUIs);
            this.openGUI(player, lastGUI);
        }
    }

    void openNext(Player player, GUIAbstract nextGUI) {
        if (!previousGUI.containsKey(player.getUniqueId())) {
            previousGUI.put(player.getUniqueId(), new ArrayList());
        }
        previousGUI.get(player.getUniqueId()).add(this);
        this.openGUI(player, nextGUI);
    }

    void refresh() {
    }

    void reloadGUI() {
        this.actions.clear();
        this.guiInv.clear();
        this.refresh();
        this.setItems();
    }

    public void removeViewer(UUID uuid) {
        currentGUI.remove(uuid);
    }

    void setItem(int slot, ItemStack item, GUIAction action) {
        this.guiInv.setItem(slot, item);
        if (action != null) {
            this.actions.put(slot, action);
        }
    }

    void setItem(int slot, ItemStack item, String name, List<String> text, GUIAction action) {
        ItemMeta meta = item.hasItemMeta() ? item.getItemMeta() : Bukkit.getServer().getItemFactory().getItemMeta(item.getType());
        meta.setDisplayName(ChatColor.RESET + name);
        if (text != null && !text.isEmpty()) {
            meta.setLore(text);
        }
        meta.addItemFlags(ItemFlag.values());
        item.setItemMeta(meta);
        this.guiInv.setItem(slot, item);
        if (action != null) {
            this.actions.put(slot, action);
        }
    }

    abstract void setItems();
}

