/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.config;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.sirrus86.s86powers.S86Powers;
import me.sirrus86.s86powers.config.ConfigOption;
import me.sirrus86.s86powers.localization.LocaleString;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.regions.NeutralRegion;
import me.sirrus86.s86powers.users.PowerGroup;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.UUIDFetcher;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerialization;

public class ConfigManager {
    private static final String BLOCKED_POWERS = "blocked-powers";
    private final Set<String> blocked = new HashSet<String>();
    private final Set<PowerGroup> groups = new HashSet<PowerGroup>();
    private final Map<String, NeutralRegion> regions = new HashMap<String, NeutralRegion>();
    private final Map<String, Object> options = new HashMap<String, Object>();
    private final Set<Power> powers = new HashSet<Power>();
    private final Map<UUID, PowerUser> users = new HashMap<UUID, PowerUser>();
    private final YamlConfiguration rgnConfig;
    private final YamlConfiguration plgConfig;
    private final YamlConfiguration pwrConfig;
    private final File rgnFile;
    private final File plgFile;
    private final File pwrFile;
    private final S86Powers plugin;

    public ConfigManager(S86Powers plugin) {
        this.plugin = plugin;
        this.rgnFile = new File(plugin.getDataFolder(), "regions.yml");
        this.plgFile = new File(plugin.getDataFolder(), "config.yml");
        this.pwrFile = new File(plugin.getDataFolder(), "powers.yml");
        this.createFiles(this.rgnFile, this.plgFile, this.pwrFile);
        this.rgnConfig = YamlConfiguration.loadConfiguration((File)this.rgnFile);
        this.plgConfig = YamlConfiguration.loadConfiguration((File)this.plgFile);
        this.pwrConfig = YamlConfiguration.loadConfiguration((File)this.pwrFile);
        ConfigurationSerialization.registerClass(NeutralRegion.class);
    }

    public boolean addGroup(PowerGroup group) {
        return this.groups.add(group);
    }

    public boolean addPower(Power power) {
        return this.powers.add(power);
    }

    public void addRegion(NeutralRegion region) {
        this.regions.put(region.getName(), region);
    }

    public boolean blockPower(Power power) {
        power.disable();
        return this.blocked.add(power.getClass().getSimpleName());
    }

    private void createFiles(File ... files) {
        for (File file : files) {
            if (file.exists()) continue;
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe(LocaleString.FILE_CREATE_FAIL.build(file));
                e.printStackTrace();
            }
        }
    }

    public void disablePowers() {
        for (Power power : this.powers) {
            power.disable();
        }
    }

    public YamlConfiguration getConfig() {
        return this.plgConfig;
    }

    public Map<String, Object> getConfigOptions() {
        return this.options;
    }

    public Object getConfigValue(String option) {
        return this.options.get(option);
    }

    public PowerGroup getGroup(String name) {
        for (PowerGroup group : this.groups) {
            if (!group.getName().equalsIgnoreCase(name)) continue;
            return group;
        }
        return null;
    }

    public Set<PowerGroup> getGroups() {
        return this.groups;
    }

    public Power getPower(String name) {
        for (Power power : this.powers) {
            if (!power.getTag().equalsIgnoreCase(name) && !power.getName().replace("_", " ").equalsIgnoreCase(name)) continue;
            return power;
        }
        return null;
    }

    public Set<Power> getPowers() {
        return this.powers;
    }

    public Set<Power> getPowersByType(PowerType type) {
        HashSet<Power> tmp = new HashSet<Power>();
        for (Power power : this.powers) {
            if (power.getType() != type) continue;
            tmp.add(power);
        }
        return tmp;
    }

    public NeutralRegion getRegion(String name) {
        return this.regions.get(name);
    }

    public Collection<NeutralRegion> getRegions() {
        return this.regions.values();
    }

    public PowerUser getUser(String name) {
        for (PowerUser user : this.users.values()) {
            if (user.getName() == null || !user.getName().equalsIgnoreCase(name)) continue;
            return user;
        }
        try {
            return this.getUser(this.getUUID(name));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public PowerUser getUser(UUID uuid) {
        if (this.users.containsKey(uuid)) {
            return this.users.get(uuid);
        }
        if (uuid != null) {
            PowerUser user = new PowerUser(uuid);
            this.users.put(uuid, user);
            user.load();
            return user;
        }
        return null;
    }

    public Collection<PowerUser> getUserList() {
        return this.users.values();
    }

    private UUID getUUID(String name) throws Exception {
        return (UUID)new UUIDFetcher(Arrays.asList(name)).call().get(name);
    }

    public boolean hasGroup(String name) {
        for (PowerGroup group : this.groups) {
            if (!group.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasUser(PowerUser user) {
        return this.users.containsValue(user);
    }

    public boolean hasUser(UUID uuid) {
        return this.users.containsKey(uuid);
    }

    public boolean isBlocked(String name) {
        return this.blocked.contains(name);
    }

    public void loadGroups() {
        for (String file : this.plugin.getGroupDirectory().list()) {
            if (!file.endsWith(".yml")) continue;
            String gName = file.substring(0, file.indexOf(".yml"));
            PowerGroup group = this.hasGroup(gName) ? this.getGroup(gName) : new PowerGroup(gName);
            group.load();
            this.groups.add(group);
        }
    }

    public void loadNeutralRegions() {
        for (String name : this.rgnConfig.getKeys(false)) {
            NeutralRegion region = (NeutralRegion)this.rgnConfig.getSerializable(name, NeutralRegion.class);
            this.regions.put(name, region);
        }
    }

    public void loadPluginConfig() {
        for (Class<?> clazz : ConfigOption.class.getClasses()) {
            for (Field field : clazz.getFields()) {
                String path = clazz.getSimpleName().toLowerCase() + "." + field.getName().replace("_", "-").toLowerCase();
                try {
                    if (!this.options.containsKey(path)) {
                        this.options.put(path, field.get(null));
                    }
                    if (this.plgConfig.contains(path)) continue;
                    this.plgConfig.set(path, field.get(null));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void loadPowerConfig() {
        if (!this.pwrConfig.contains(BLOCKED_POWERS)) {
            this.pwrConfig.createSection(BLOCKED_POWERS);
            this.pwrConfig.set(BLOCKED_POWERS, new ArrayList());
        }
        this.blocked.addAll(this.pwrConfig.getStringList(BLOCKED_POWERS));
    }

    public void loadUsers() {
        for (OfflinePlayer player : this.plugin.getServer().getOfflinePlayers()) {
            PowerUser user = null;
            if (!this.users.containsKey(player.getUniqueId())) {
                user = new PowerUser(player.getUniqueId());
                this.users.put(player.getUniqueId(), user);
            } else {
                user = this.users.get(player.getUniqueId());
            }
            user.load();
        }
    }

    public boolean removeGroup(PowerGroup group) {
        group.disband();
        return this.groups.remove(group);
    }

    public boolean removePower(Power power) {
        return this.powers.remove(power);
    }

    public void removeRegion(NeutralRegion region) {
        this.regions.remove(region.getName());
        region.deactivate();
    }

    private void save(YamlConfiguration config, File file) {
        if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
            this.plugin.getLogger().info(LocaleString.SAVE_ATTEMPT.build(file));
        }
        try {
            config.save(file);
            if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
                this.plugin.getLogger().info(LocaleString.SAVE_SUCCESS.build(file));
            }
        }
        catch (IOException e) {
            if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
                this.plugin.getLogger().severe(LocaleString.SAVE_SUCCESS.build(file));
            }
            e.printStackTrace();
        }
    }

    public void saveAll() {
        for (PowerGroup group : this.groups) {
            group.save();
        }
        for (PowerUser user : this.users.values()) {
            user.save();
        }
        this.savePluginConfig();
        this.savePowerConfig();
    }

    public void savePluginConfig() {
        for (String option : this.options.keySet()) {
            this.plgConfig.set(option, this.options.get(option));
        }
        this.save(this.plgConfig, this.plgFile);
    }

    public void savePowerConfig() {
        this.pwrConfig.set(BLOCKED_POWERS, (Object)Lists.newArrayList(this.blocked));
        this.save(this.pwrConfig, this.pwrFile);
    }

    public boolean setConfigValue(String option, Object value) {
        if (this.options.containsKey(option)) {
            Class<?> clazz = this.options.get(option).getClass();
            Object obj = this.validate(clazz, value);
            if (obj != null) {
                this.options.put(option, obj);
                if (ConfigOption.Plugin.AUTO_SAVE) {
                    this.savePluginConfig();
                }
                return true;
            }
            if (ConfigOption.Plugin.SHOW_INPUT_ERRORS) {
                this.plugin.getLogger().warning(LocaleString.SET_OPTION_FAIL.build(option, value, clazz));
            }
        }
        return false;
    }

    public boolean unblockPower(String name) {
        return this.blocked.remove(name);
    }

    private Object validate(Class<?> clazz, Object value) {
        String test = value.toString();
        if ((clazz == Boolean.TYPE || clazz == Boolean.class) && (test.equalsIgnoreCase("false") || test.equalsIgnoreCase("true"))) {
            return Boolean.parseBoolean(test);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            try {
                return Integer.parseInt(test);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (clazz == String.class) {
            return test;
        }
        return null;
    }
}

