/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import me.sirrus86.s86powers.command.ComAbstract;
import me.sirrus86.s86powers.command.PageMaker;
import me.sirrus86.s86powers.config.ConfigOption;
import me.sirrus86.s86powers.localization.LocaleString;
import me.sirrus86.s86powers.permissions.S86Permission;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerStat;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;

public class ComSelf
extends ComAbstract {
    public ComSelf(CommandSender sender, String ... args) {
        super(sender, args);
        if (this.sUser != null) {
            if (args.length > 0) {
                if (args[0].equalsIgnoreCase("add")) {
                    this.comSelfAdd(args.length > 1 ? (args[1].equalsIgnoreCase("random") ? this.getRandomPower(this.sUser) : config.getPower(args[1])) : null);
                } else if (args[0].equalsIgnoreCase("clear")) {
                    this.comSelfClear(args.length > 1 ? args[1].toUpperCase() : null);
                } else if (args[0].equalsIgnoreCase("give")) {
                    this.comSelfGive(args.length > 1 ? config.getPower(args[1]) : null);
                } else if (args[0].equalsIgnoreCase("info")) {
                    this.comSelfInfo();
                } else if (args[0].equalsIgnoreCase("option")) {
                    this.comSelfOption(args.length > 1 ? config.getPower(args[1]) : null, args.length > 2 ? args[2] : null, args.length > 2 ? config.getPower(args[1]).getOptionByName(args[2]) : null, args.length > 3 ? args[3] : null);
                } else if (args[0].equalsIgnoreCase("remove")) {
                    this.comSelfRemove(args.length > 1 ? config.getPower(args[1]) : null);
                } else if (args[0].equalsIgnoreCase("stats")) {
                    this.comSelfStats(args.length > 1 ? config.getPower(args[1]) : null, args.length > 2 ? config.getPower(args[1]).getStat(args[2]) : null, args.length > 3 && StringUtils.isNumeric((CharSequence)args[3]) ? Integer.parseInt(args[3]) : -1);
                } else if (args[0].equalsIgnoreCase("supply")) {
                    this.comSelfSupply(args.length > 1 ? config.getPower(args[1]) : null);
                } else if (args[0].equalsIgnoreCase("toggle")) {
                    this.comSelfToggle(args.length > 1 ? config.getPower(args[1]) : null);
                } else {
                    sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
                }
            }
        } else {
            sender.sendMessage(ERROR + (Object)((Object)LocaleString.SELF_FROM_CONSOLE));
        }
    }

    private void comSelfAdd(Power power) {
        if (this.sender.hasPermission(S86Permission.SELF_ADD)) {
            if (power != null) {
                if (this.sUser.getAssignedPowers().contains(power)) {
                    this.sender.sendMessage(ERROR + LocaleString.SELF_ALREADY_HAS_POWER.build(power));
                } else if (power.getType() == PowerType.UTILITY) {
                    this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.SELF_ASSIGN_UTILITY));
                } else if (!this.sender.hasPermission(power.getAssignPermission())) {
                    this.sender.sendMessage(ERROR + LocaleString.POWER_ASSIGN_NO_PERMISSION.build(power));
                } else if (!this.sUser.isAdmin() && ConfigOption.Users.ENFORCE_POWER_CAP && (this.sUser.getAssignedPowersByType(power.getType()).size() >= ConfigOption.Users.POWER_CAP_PER_TYPE || this.sUser.getAssignedPowers().size() >= ConfigOption.Users.POWER_CAP_TOTAL)) {
                    if (this.sUser.getAssignedPowersByType(power.getType()).size() >= ConfigOption.Users.POWER_CAP_PER_TYPE) {
                        if (ConfigOption.Users.REPLACE_POWERS_OF_SAME_TYPE) {
                            ArrayList powers = Lists.newArrayList(this.sUser.getAssignedPowersByType(power.getType()));
                            Collections.shuffle(powers);
                            Power removePower = (Power)powers.get(0);
                            this.sUser.removePower(removePower);
                            this.sender.sendMessage(SUCCESS + LocaleString.SELF_REMOVE_POWER_SUCCESS.build(removePower));
                            this.sUser.addPower(power);
                            this.sender.sendMessage(SUCCESS + LocaleString.SELF_ADD_POWER_SUCCESS.build(power));
                        } else {
                            this.sender.sendMessage(ERROR + LocaleString.SELF_TOO_MANY_POWERS_TYPE.build(new Object[]{power.getType()}));
                        }
                    } else if (this.sUser.getAssignedPowers().size() >= ConfigOption.Users.POWER_CAP_TOTAL) {
                        this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.SELF_TOO_MANY_POWERS));
                    }
                } else {
                    this.sUser.addPower(power);
                    this.sender.sendMessage(SUCCESS + LocaleString.SELF_ADD_POWER_SUCCESS.build(power));
                }
            } else {
                this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.UNKNOWN_POWER));
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private void comSelfClear(String type) {
        if (this.sender.hasPermission(S86Permission.SELF_CLEAR)) {
            HashSet powers;
            PowerType pType = null;
            if (type != null) {
                try {
                    pType = PowerType.valueOf(type);
                }
                catch (IllegalArgumentException e) {
                    this.sender.sendMessage(ERROR + LocaleString.UNKNOWN_TYPE.build(type));
                    return;
                }
            }
            HashSet hashSet = powers = pType != null ? Sets.newHashSet(this.sUser.getAssignedPowersByType(pType)) : Sets.newHashSet(this.sUser.getAssignedPowers());
            if (!powers.isEmpty()) {
                for (Power power : powers) {
                    this.sUser.removePower(power);
                    this.sender.sendMessage(SUCCESS + LocaleString.SELF_REMOVE_POWER_SUCCESS.build(power));
                }
            } else {
                this.sender.sendMessage(INFO + (Object)((Object)LocaleString.SELF_REMOVE_NO_POWERS));
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private void comSelfGive(Power power) {
        if (this.sender.hasPermission(S86Permission.SELF_GIVE)) {
            if (power != null) {
                ItemStack book = PowerTools.createPowerBook(power);
                Collection items = this.sUser.getPlayer().getInventory().addItem(new ItemStack[]{book}).values();
                for (ItemStack item : items) {
                    this.sUser.getPlayer().getWorld().dropItem(this.sUser.getPlayer().getLocation(), item);
                }
                this.sender.sendMessage(LocaleString.SELF_RECEIVED_POWER_BOOK.build(power));
            } else {
                this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.UNKNOWN_POWER));
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private void comSelfInfo() {
        if (this.sender.hasPermission(S86Permission.SELF_INFO)) {
            this.sender.sendMessage(INFO + this.getUserName(this.sUser));
            this.sender.sendMessage((Object)((Object)LocaleString.POWERS) + ": " + this.getPowers(this.sUser));
            this.sender.sendMessage((Object)((Object)LocaleString.GROUPS) + ": " + this.getGroups(this.sUser));
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private final void comSelfOption(Power power, String page, PowerOption<?> option, String valueStr) {
        if (this.sender.hasPermission(S86Permission.SELF_OPTION)) {
            if (power != null) {
                if (option != null) {
                    if (valueStr != null) {
                        String value;
                        String string = value = !valueStr.equalsIgnoreCase("null") ? this.validate(option, valueStr) : valueStr;
                        if (!option.isLocked()) {
                            if (value != null) {
                                if (value.toString().equalsIgnoreCase("null")) {
                                    this.sUser.removeOption(option);
                                    this.sender.sendMessage(SUCCESS + LocaleString.REMOVE_OPTION_SUCCESS.build(option.getPath()));
                                } else if (option.getDefaultValue() instanceof List) {
                                    ArrayList<String> optList = new ArrayList<String>((List)power.getOption(option));
                                    if (optList.contains(value)) {
                                        optList.remove(value);
                                        power.setOption(option, optList);
                                        this.sender.sendMessage(SUCCESS + LocaleString.SET_OPTION_REMOVE_SUCCESS.build(option.getPath(), value));
                                    } else {
                                        optList.add(value);
                                        power.setOption(option, optList);
                                        this.sender.sendMessage(SUCCESS + LocaleString.SET_OPTION_ADD_SUCCESS.build(option.getPath(), value));
                                    }
                                } else {
                                    this.sUser.setOption(option, option.getDefaultValue() instanceof Long ? (Long)((Object)value) : value);
                                    this.sender.sendMessage(SUCCESS + LocaleString.SET_OPTION_SUCCESS.build(option.getPath(), value));
                                }
                            } else if (option.getDefaultValue() instanceof List) {
                                this.sender.sendMessage(ERROR + LocaleString.SET_OPTION_FAIL.build(option.getPath(), ((List)option.getDefaultValue()).get(0).getClass(), valueStr));
                            } else {
                                this.sender.sendMessage(ERROR + LocaleString.SET_OPTION_FAIL.build(option.getPath(), option.getDefaultValue().getClass(), valueStr));
                            }
                        } else {
                            this.sender.sendMessage(ERROR + LocaleString.SET_OPTION_LOCKED.build(option.getPath(), valueStr));
                        }
                    } else {
                        this.sender.sendMessage(ChatColor.GREEN + option.getPath());
                        this.sender.sendMessage((Object)((Object)LocaleString.DESCRIPTION) + ": " + ChatColor.GRAY + option.getDescription());
                        this.sender.sendMessage((Object)((Object)LocaleString.TYPE) + ": " + ChatColor.GRAY + option.getDefaultValue().getClass().getSimpleName());
                        this.sender.sendMessage((Object)((Object)LocaleString.VALUE) + ": " + ChatColor.BLUE + (this.sUser.getOptionValue(option) instanceof ItemStack ? PowerTools.getItemName((ItemStack)this.sUser.getOptionValue(option)) : this.sUser.getOptionValue(option).toString()) + ChatColor.RESET + " " + (Object)((Object)LocaleString.DEFAULT) + ": " + ChatColor.GRAY + option.getDefaultValue());
                    }
                } else if (page != null) {
                    try {
                        int i = Integer.parseInt(page);
                        PageMaker pm = new PageMaker(INFO + ChatColor.GOLD + this.sUser.getName() + " " + ChatColor.GREEN + power.getName() + " " + (Object)((Object)LocaleString.OPTIONS), this.getOptions(power, this.sUser), i);
                        pm.send(this.sender);
                    }
                    catch (NumberFormatException e) {
                        this.sender.sendMessage(ERROR + LocaleString.POWER_MISSING_OPTION.build(power, page));
                    }
                } else {
                    PageMaker pm = new PageMaker(INFO + ChatColor.GOLD + this.sUser.getName() + " " + ChatColor.GREEN + power.getName() + " " + (Object)((Object)LocaleString.OPTIONS), this.getOptions(power, this.sUser), 1);
                    pm.send(this.sender);
                }
            } else {
                this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.UNKNOWN_POWER));
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private void comSelfRemove(Power power) {
        if (this.sender.hasPermission(S86Permission.SELF_REMOVE)) {
            if (power != null) {
                if (!this.sUser.getAssignedPowers().contains(power)) {
                    this.sender.sendMessage(ERROR + LocaleString.SELF_MISSING_POWER.build(power));
                } else {
                    this.sUser.removePower(power);
                    this.sender.sendMessage(SUCCESS + LocaleString.SELF_REMOVE_POWER_SUCCESS.build(power));
                }
            } else {
                this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.UNKNOWN_POWER));
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private void comSelfStats(Power power, PowerStat stat, int value) {
        if (this.sender.hasPermission(S86Permission.SELF_STATS)) {
            if (power == null || this.sUser.hasPower(power)) {
                if (power != null && stat != null) {
                    if (this.sender.hasPermission(S86Permission.SELF_STATS_SET)) {
                        if (value > -1) {
                            this.sUser.increaseStat(stat, value - this.sUser.getStatCount(stat));
                            this.sender.sendMessage(SUCCESS + LocaleString.SET_STAT_SUCCESS.build(stat.getPath(), this.sUser.getStatCount(stat)));
                        } else {
                            this.sender.sendMessage(INFO + this.getUserName(this.sUser) + " " + (Object)((Object)LocaleString.STATS));
                            this.sender.sendMessage(ChatColor.GREEN + stat.getPath() + ChatColor.RESET + ": " + this.sUser.getStatCount(stat));
                        }
                    } else {
                        this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
                    }
                } else {
                    this.sender.sendMessage(INFO + this.getUserName(this.sUser) + " " + (Object)((Object)LocaleString.STATS));
                    ArrayList powers = power != null ? Lists.newArrayList((Object[])new Power[]{power}) : new ArrayList(this.sUser.getPowers());
                    Collections.sort(powers);
                    String tmp = "";
                    for (int i = 0; i < powers.size(); ++i) {
                        Power nextPower = (Power)powers.get(i);
                        ArrayList<PowerStat> stats = new ArrayList<PowerStat>(power.getStats().keySet());
                        Collections.sort(stats);
                        if (stats.isEmpty()) continue;
                        tmp = tmp + nextPower.getType().getColor() + nextPower.getName() + "\n";
                        for (int j = 0; j < stats.size(); ++j) {
                            tmp = tmp + ChatColor.RESET + " " + ((PowerStat)stats.get(j)).getDescription() + ": " + this.sUser.getStatCount((PowerStat)stats.get(j)) + "/" + nextPower.getStatValue((PowerStat)stats.get(j)) + "\n";
                            tmp = ConfigOption.Users.VIEW_INCOMPLETE_STAT_REWARDS || this.sUser.hasStatMaxed((PowerStat)stats.get(j)) ? tmp + "  " + (Object)((Object)LocaleString.REWARD) + ": " + (!this.sUser.hasStatMaxed((PowerStat)stats.get(j)) ? ChatColor.GRAY : "") + PowerTools.getFilteredText(nextPower, ((PowerStat)stats.get(j)).getReward()) + "\n" : tmp + "  " + (Object)((Object)LocaleString.REWARD) + ": " + ChatColor.GRAY + "???\n";
                        }
                    }
                    if (tmp.equalsIgnoreCase("")) {
                        tmp = LocaleString.NO_STATS_RECORDED.toString();
                    }
                    if (tmp.endsWith("\n")) {
                        tmp = tmp.substring(0, tmp.lastIndexOf("\n"));
                    }
                    this.sender.sendMessage(tmp);
                }
            } else {
                this.sender.sendMessage(ERROR + LocaleString.SELF_MISSING_POWER.build(power));
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private void comSelfSupply(Power power) {
        if (this.sender.hasPermission(S86Permission.SELF_SUPPLY)) {
            if (power != null) {
                this.supply(this.sUser, power);
            } else {
                for (Power pwr : this.sUser.getPowers()) {
                    this.supply(this.sUser, pwr);
                }
            }
            this.sender.sendMessage(SUCCESS + (Object)((Object)LocaleString.SELF_SUPPLY_SUCCESS));
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private void comSelfToggle(Power power) {
        if (this.sender.hasPermission(S86Permission.SELF_TOGGLE)) {
            if (power != null) {
                if (this.sUser.hasPowerAssigned(power)) {
                    if (this.sUser.hasPowerEnabled(power)) {
                        this.sender.sendMessage(SUCCESS + LocaleString.SELF_POWER_DISABLED.build(power));
                    } else {
                        this.sender.sendMessage(SUCCESS + LocaleString.SELF_POWER_ENABLED.build(power));
                    }
                    this.sUser.setPowerEnabled(power, !this.sUser.hasPowerEnabled(power));
                } else {
                    this.sender.sendMessage(ERROR + LocaleString.SELF_MISSING_POWER.build(power));
                }
            } else {
                if (this.sUser.hasPowersEnabled()) {
                    this.sender.sendMessage(SUCCESS + (Object)((Object)LocaleString.SELF_POWERS_DISABLED));
                } else {
                    this.sender.sendMessage(SUCCESS + (Object)((Object)LocaleString.SELF_POWERS_ENABLED));
                }
                this.sUser.setPowersEnabled(!this.sUser.hasPowersEnabled());
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }
}

