/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.command;

import me.sirrus86.s86powers.command.ComAbstract;
import me.sirrus86.s86powers.command.HelpTopic;
import me.sirrus86.s86powers.command.PageMaker;
import me.sirrus86.s86powers.localization.LocaleString;
import me.sirrus86.s86powers.permissions.S86Permission;
import me.sirrus86.s86powers.regions.NeutralRegion;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ComRegion
extends ComAbstract {
    public ComRegion(CommandSender sender, String ... args) {
        super(sender, args);
        if (args.length > 1) {
            if (args[1].equalsIgnoreCase("help")) {
                this.comRegionHelp(args.length > 2 ? args[2] : null);
            } else if (args[1].equalsIgnoreCase("list")) {
                this.comRegionList(args.length > 2 ? args[2] : null);
            } else {
                NeutralRegion region = config.getRegion(args[1]);
                if (region != null || args.length > 2 && args[2].equalsIgnoreCase("create")) {
                    if (args.length == 2 || args[2].equalsIgnoreCase("info")) {
                        this.comRegionInfo(region);
                    } else if (args[2].equalsIgnoreCase("create")) {
                        this.comRegionCreate(args[1], args.length > 3 ? Bukkit.getServer().getWorld(args[3]) : null);
                    } else if (args[2].equalsIgnoreCase("delete")) {
                        this.comRegionDelete(region);
                    } else if (args[2].equalsIgnoreCase("resize")) {
                        String[] dimensions = new String[6];
                        for (int i = 0; i < 6; ++i) {
                            if (args.length <= i + 3) continue;
                            dimensions[i] = args[i + 3];
                        }
                        this.comRegionResize(region, dimensions);
                    } else if (args[2].equalsIgnoreCase("toggle")) {
                        this.comRegionToggle(region, args.length > 3 ? Boolean.parseBoolean(args[3]) : !region.isActive());
                    }
                } else {
                    sender.sendMessage(ERROR + LocaleString.UNKNOWN_REGION.build(args[1]));
                }
            }
        }
    }

    private void comRegionCreate(String name, World world) {
        if (this.sender.hasPermission(S86Permission.REGION_CREATE)) {
            if (world != null || this.sender instanceof Player) {
                if (world == null) {
                    world = ((Player)this.sender).getWorld();
                }
                if (name != null) {
                    if (config.getRegion(name) == null) {
                        NeutralRegion region = new NeutralRegion(name, world);
                        config.addRegion(region);
                        this.sender.sendMessage(SUCCESS + LocaleString.REGION_CREATE_SUCCESS.build(region));
                    } else {
                        this.sender.sendMessage(ERROR + LocaleString.REGION_ALREADY_EXISTS.build(name));
                    }
                } else {
                    this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.REGION_MISSING_NAME));
                    this.sender.sendMessage(LocaleString.EXPECTED_FORMAT.build(new Object[]{HelpTopic.REGION_CREATE}));
                }
            } else {
                this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.REGION_MISSING_WORLD));
                this.sender.sendMessage(LocaleString.EXPECTED_FORMAT.build(new Object[]{HelpTopic.REGION_CREATE}));
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private void comRegionDelete(NeutralRegion region) {
        if (this.sender.hasPermission(S86Permission.REGION_DELETE)) {
            config.removeRegion(region);
            this.sender.sendMessage(SUCCESS + LocaleString.REGION_DELETE_SUCCESS.build(region));
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private void comRegionHelp(String page) {
        if (this.sender.hasPermission(S86Permission.REGION_HELP)) {
            int i = 1;
            if (page != null) {
                try {
                    i = Integer.parseInt(page);
                }
                catch (NumberFormatException e) {
                    i = 1;
                }
            }
            PageMaker pm = new PageMaker(HELP + ChatColor.GREEN + (Object)((Object)LocaleString.REGION), HelpTopic.showHelp(this.sender, "REGION"), i);
            pm.send(this.sender);
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private void comRegionInfo(NeutralRegion region) {
        if (this.sender.hasPermission(S86Permission.REGION_INFO)) {
            this.sender.sendMessage(ChatColor.GREEN + region.getName() + ChatColor.RESET);
            this.sender.sendMessage((Object)((Object)LocaleString.WORLD) + ": " + region.getWorld().getName());
            this.sender.sendMessage((Object)((Object)LocaleString.DIMENSIONS) + ": " + region.getMinCoords().toString() + " x " + region.getMaxCoords().toString());
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private void comRegionList(String page) {
        if (this.sender.hasPermission(S86Permission.REGION_LIST)) {
            int i = 1;
            if (page != null) {
                try {
                    i = Integer.parseInt(page);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            PageMaker pm = new PageMaker(LIST + ChatColor.GREEN + (Object)((Object)LocaleString.REGIONS), this.getRegions() + ".", i);
            pm.send(this.sender);
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private void comRegionToggle(NeutralRegion region, boolean neutral) {
        if (this.sender.hasPermission(S86Permission.REGION_TOGGLE)) {
            region.setNeutral(neutral);
            if (region.isActive()) {
                this.sender.sendMessage(SUCCESS + LocaleString.REGION_TOGGLE_ENABLE.build(region));
            } else {
                this.sender.sendMessage(SUCCESS + LocaleString.REGION_TOGGLE_DISABLE.build(region));
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private void comRegionResize(NeutralRegion region, String[] dimensions) {
        if (this.sender.hasPermission(S86Permission.REGION_RESIZE)) {
            double[] coords = new double[6];
            for (int i = 0; i < dimensions.length; ++i) {
                try {
                    coords[i] = Double.parseDouble(dimensions[i]);
                    continue;
                }
                catch (NullPointerException e) {
                    this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.REGION_NOT_ENOUGH_COORDS));
                    this.sender.sendMessage(LocaleString.EXPECTED_FORMAT.build(new Object[]{HelpTopic.REGION_RESIZE}));
                    return;
                }
                catch (NumberFormatException e1) {
                    this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.REGION_COORD_NOT_NUMBER));
                    this.sender.sendMessage(LocaleString.EXPECTED_FORMAT.build(new Object[]{HelpTopic.REGION_RESIZE}));
                    return;
                }
            }
            region.resize(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
            this.sender.sendMessage(SUCCESS + LocaleString.REGION_RESIZE_SUCCESS.build(region));
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }
}

