/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import me.sirrus86.s86powers.command.ComAbstract;
import me.sirrus86.s86powers.command.HelpTopic;
import me.sirrus86.s86powers.command.PageMaker;
import me.sirrus86.s86powers.localization.LocaleString;
import me.sirrus86.s86powers.permissions.S86Permission;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerStat;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;

public final class ComPower
extends ComAbstract {
    public ComPower(CommandSender sender, String ... args) {
        super(sender, args);
        if (args.length == 1 || args[1].equalsIgnoreCase("help")) {
            this.comPowerHelp(args.length > 2 ? args[2] : null);
        } else if (args[1].equalsIgnoreCase("list")) {
            this.comPowerList(args.length > 2 ? PowerType.valueOf(args[2].toUpperCase()) : null, args.length > 3 ? args[3] : (args.length > 2 ? args[2] : null));
        } else {
            Power power = config.getPower(args[1]);
            if (power != null) {
                if (args.length <= 2 || args[2].equalsIgnoreCase("info")) {
                    this.comPowerInfo(power);
                } else if (args[2].equalsIgnoreCase("block") || args[2].equalsIgnoreCase("unblock")) {
                    this.comPowerBlock(power, args[2].equalsIgnoreCase("block"));
                } else if (args[2].equalsIgnoreCase("disable") || args[2].equalsIgnoreCase("enable")) {
                    this.comPowerEnable(power, args[2].equalsIgnoreCase("enable"));
                } else if (args[2].equalsIgnoreCase("kill")) {
                    this.comPowerKill(power);
                } else if (args[2].equalsIgnoreCase("lock") || args[2].equalsIgnoreCase("unlock")) {
                    this.comPowerLock(power, args[2].equalsIgnoreCase("lock"));
                } else if (args[2].equalsIgnoreCase("option")) {
                    this.comPowerOption(power, args.length > 3 ? args[3] : null, args.length > 3 ? power.getOptionByName(args[3]) : null, args.length > 4 ? args[4] : null);
                } else if (args[2].equalsIgnoreCase("reload")) {
                    this.comPowerReload(power);
                } else if (args[2].equalsIgnoreCase("save")) {
                    this.comPowerSave(power);
                } else if (args[2].equalsIgnoreCase("stats")) {
                    this.comPowerStats(power, args.length > 3 ? args[3] : null, args.length > 3 ? power.getStat(args[3]) : null, args.length > 4 ? args[4] : null);
                } else if (args[2].equalsIgnoreCase("supply")) {
                    this.comPowerSupply(power, args.length > 3 ? args[3] : null, args.length > 4 ? args[4] : null, args.length > 5 ? args[5] : null);
                } else {
                    sender.sendMessage(ERROR + LocaleString.UNKNOWN_POWER.build(args[2]));
                }
            } else {
                sender.sendMessage(ERROR + LocaleString.UNKNOWN_COMMAND.build(args[1]));
            }
        }
    }

    private final void comPowerBlock(Power power, boolean isBlock) {
        if (isBlock) {
            if (this.sender.hasPermission(S86Permission.POWER_BLOCK)) {
                if (config.blockPower(power)) {
                    this.sender.sendMessage(SUCCESS + LocaleString.POWER_BLOCK_SUCCESS.build(power));
                } else {
                    this.sender.sendMessage(ERROR + LocaleString.POWER_BLOCK_FAIL.build(power));
                }
            } else {
                this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
            }
        } else if (this.sender.hasPermission(S86Permission.POWER_UNBLOCK)) {
            if (config.unblockPower(power.getTag())) {
                this.sender.sendMessage(SUCCESS + LocaleString.POWER_UNBLOCK_SUCCESS.build(power));
            } else {
                this.sender.sendMessage(ERROR + LocaleString.POWER_UNBLOCK_FAIL.build(power));
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private final void comPowerEnable(Power power, boolean isEnable) {
        if (isEnable) {
            if (this.sender.hasPermission(S86Permission.POWER_ENABLE)) {
                if (!power.isEnabled()) {
                    if (power.setEnabled(true)) {
                        this.sender.sendMessage(SUCCESS + LocaleString.POWER_ENABLE_SUCCESS.build(power));
                    } else {
                        this.sender.sendMessage(ERROR + LocaleString.POWER_ENABLE_FAIL.build(power));
                    }
                } else {
                    this.sender.sendMessage(ERROR + LocaleString.POWER_ALREADY_ENABLED.build(power));
                }
            } else {
                this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
            }
        } else if (this.sender.hasPermission(S86Permission.POWER_DISABLE)) {
            if (power.isEnabled()) {
                if (power.setEnabled(false)) {
                    this.sender.sendMessage(SUCCESS + LocaleString.POWER_DISABLE_SUCCESS.build(power));
                } else {
                    this.sender.sendMessage(ERROR + LocaleString.POWER_DISABLE_FAIL.build(power));
                }
            } else {
                this.sender.sendMessage(ERROR + LocaleString.POWER_ALREADY_DISABLED.build(power));
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private final void comPowerHelp(String page) {
        if (this.sender.hasPermission(S86Permission.POWER_HELP)) {
            PageMaker pm = null;
            int i = 1;
            if (page != null) {
                try {
                    i = Integer.parseInt(page);
                }
                catch (NumberFormatException e) {
                    i = 1;
                }
            }
            pm = new PageMaker(HELP + ChatColor.GREEN + (Object)((Object)LocaleString.POWER), HelpTopic.showHelp(this.sender, "POWER"), i);
            pm.send(this.sender);
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private final void comPowerInfo(Power power) {
        if (this.sender.hasPermission(S86Permission.POWER_INFO)) {
            this.sender.sendMessage(ChatColor.GREEN + power.getName() + ChatColor.RESET + " (" + ChatColor.GRAY + power.getTag() + ChatColor.RESET + ")");
            this.sender.sendMessage((Object)((Object)LocaleString.TYPE) + ": " + power.getType().getColor() + power.getType().getName() + ChatColor.RESET + ".");
            this.sender.sendMessage((Object)((Object)LocaleString.AUTHOR) + ": " + ChatColor.GRAY + power.getAuthor() + ChatColor.RESET + " " + (Object)((Object)LocaleString.CONCEPT) + ": " + ChatColor.GRAY + power.getConcept());
            this.sender.sendMessage((Object)((Object)LocaleString.DESCRIPTION) + ": " + ChatColor.GRAY + this.getPowerDesc(power));
            this.sender.sendMessage((Object)((Object)LocaleString.PLAYERS) + ": " + ChatColor.GRAY + this.getUsers(power) + ".");
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private final void comPowerKill(Power power) {
        if (this.sender.hasPermission(S86Permission.POWER_KILL)) {
            String pName = power.getName();
            config.removePower(power);
            power.setEnabled(false);
            this.killPower(power);
            this.sender.sendMessage(SUCCESS + LocaleString.POWER_KILL_SUCCESS.build(pName));
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private final void comPowerList(PowerType type, String page) {
        if (this.sender.hasPermission(S86Permission.POWER_LIST)) {
            String title = LocaleString.POWERS.toString();
            int i = 1;
            Set<Power> powers = null;
            if (type != null) {
                title = title + " " + LocaleString.POWERS_BY_TYPE.build(new Object[]{type});
                powers = config.getPowersByType(type);
            } else {
                powers = config.getPowers();
            }
            if (page != null) {
                try {
                    i = Integer.parseInt(page);
                }
                catch (NumberFormatException e) {
                    i = 1;
                }
            }
            if (powers != null) {
                PageMaker pm = new PageMaker(LIST + ChatColor.GREEN + title, this.getPowerList(powers) + ".", i);
                pm.send(this.sender);
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private final void comPowerLock(Power power, boolean isLock) {
        if (isLock) {
            if (this.sender.hasPermission(S86Permission.POWER_LOCK)) {
                if (!power.isLocked()) {
                    power.setLocked(true);
                    this.sender.sendMessage(SUCCESS + LocaleString.POWER_LOCK_SUCCESS.build(power));
                } else {
                    this.sender.sendMessage(ERROR + LocaleString.POWER_LOCK_FAIL.build(power));
                }
            } else {
                this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
            }
        } else if (this.sender.hasPermission(S86Permission.POWER_UNLOCK)) {
            if (power.isLocked()) {
                power.setLocked(false);
                this.sender.sendMessage(SUCCESS + LocaleString.POWER_UNLOCK_SUCCESS.build(power));
            } else {
                this.sender.sendMessage(ERROR + LocaleString.POWER_UNLOCK_FAIL.build(power));
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private final void comPowerOption(Power power, String page, PowerOption<?> option, String valueStr) {
        if (this.sender.hasPermission(S86Permission.POWER_OPTION)) {
            if (option != null) {
                if (valueStr != null) {
                    Object value = this.validate(option, valueStr);
                    if (!option.isLocked()) {
                        if (value != null) {
                            if (option.getDefaultValue() instanceof List) {
                                ArrayList<Object> optList = new ArrayList<Object>((List)power.getOption(option));
                                if (optList.contains(value)) {
                                    optList.remove(value);
                                    power.setOption(option, optList);
                                    this.sender.sendMessage(SUCCESS + LocaleString.SET_OPTION_REMOVE_SUCCESS.build(option.getPath(), value));
                                } else {
                                    optList.add(value);
                                    power.setOption(option, optList);
                                    this.sender.sendMessage(SUCCESS + LocaleString.SET_OPTION_ADD_SUCCESS.build(option.getPath(), value));
                                }
                            } else {
                                power.setOption(option, option.getDefaultValue() instanceof Long ? (Long)value : (option.getDefaultValue() instanceof Float ? (Float)value : value));
                                this.sender.sendMessage(SUCCESS + LocaleString.SET_OPTION_SUCCESS.build(option.getPath(), value));
                            }
                        } else if (option.getDefaultValue() instanceof List) {
                            this.sender.sendMessage(ERROR + LocaleString.SET_OPTION_FAIL.build(option.getPath(), ((List)option.getDefaultValue()).get(0).getClass(), valueStr));
                        } else {
                            this.sender.sendMessage(ERROR + LocaleString.SET_OPTION_FAIL.build(option.getPath(), option.getDefaultValue().getClass(), valueStr));
                        }
                    } else {
                        this.sender.sendMessage(ERROR + LocaleString.SET_OPTION_LOCKED.build(option.getPath(), valueStr));
                    }
                } else {
                    this.sender.sendMessage(ChatColor.GREEN + option.getPath());
                    this.sender.sendMessage((Object)((Object)LocaleString.DESCRIPTION) + ": " + ChatColor.GRAY + option.getDescription());
                    this.sender.sendMessage((Object)((Object)LocaleString.TYPE) + ": " + ChatColor.GRAY + option.getDefaultValue().getClass().getSimpleName());
                    this.sender.sendMessage((Object)((Object)LocaleString.VALUE) + ": " + ChatColor.BLUE + (power.getOption(option) instanceof ItemStack ? PowerTools.getItemName((ItemStack)power.getOption(option)) : power.getOption(option).toString()) + ChatColor.RESET + " " + (Object)((Object)LocaleString.DEFAULT) + ": " + ChatColor.GRAY + option.getDefaultValue());
                }
            } else if (page != null) {
                try {
                    int i = Integer.parseInt(page);
                    PageMaker pm = new PageMaker(HELP + ChatColor.GREEN + power.getName() + " " + (Object)((Object)LocaleString.OPTIONS), this.getOptions(power), i);
                    pm.send(this.sender);
                }
                catch (NumberFormatException e) {
                    this.sender.sendMessage(ERROR + LocaleString.POWER_MISSING_OPTION.build(power, page));
                }
            } else {
                PageMaker pm = new PageMaker(INFO + ChatColor.GREEN + power.getName() + " " + (Object)((Object)LocaleString.OPTIONS), this.getOptions(power), 1);
                pm.send(this.sender);
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private final void comPowerReload(Power power) {
        if (this.sender.hasPermission(S86Permission.POWER_RELOAD)) {
            power.reload();
            this.sender.sendMessage(SUCCESS + LocaleString.POWER_RELOAD_SUCCESS.build(power));
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private final void comPowerSave(Power power) {
        if (this.sender.hasPermission(S86Permission.POWER_SAVE)) {
            power.saveConfig();
            this.sender.sendMessage(SUCCESS + LocaleString.POWER_SAVE_SUCCESS.build(power));
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private final void comPowerStats(Power power, String page, PowerStat stat, String valueStr) {
        if (this.sender.hasPermission(S86Permission.POWER_STATS)) {
            if (stat != null) {
                if (valueStr != null) {
                    int value = this.validate(stat, valueStr);
                    power.setStatValue(stat, value);
                    this.sender.sendMessage(SUCCESS + LocaleString.SET_STAT_SUCCESS.build(stat.getPath(), value));
                } else {
                    this.sender.sendMessage(ChatColor.GREEN + stat.getPath());
                    this.sender.sendMessage((Object)((Object)LocaleString.DESCRIPTION) + ": " + ChatColor.GRAY + stat.getDescription());
                    this.sender.sendMessage((Object)((Object)LocaleString.VALUE) + ": " + ChatColor.BLUE + power.getStatValue(stat) + ChatColor.RESET + " " + (Object)((Object)LocaleString.DEFAULT) + ": " + ChatColor.GRAY + stat.getDefaultValue());
                }
            } else if (page != null) {
                try {
                    int i = Integer.parseInt(page);
                    PageMaker pm = new PageMaker(HELP + ChatColor.GREEN + power.getName() + " " + (Object)((Object)LocaleString.STATS), this.getStats(power), i);
                    pm.send(this.sender);
                }
                catch (NumberFormatException e) {
                    this.sender.sendMessage(ERROR + LocaleString.POWER_MISSING_STAT.build(power, page));
                }
            } else {
                PageMaker pm = new PageMaker(INFO + ChatColor.GREEN + power.getName() + " " + (Object)((Object)LocaleString.STATS), this.getStats(power), 1);
                pm.send(this.sender);
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private final void comPowerSupply(Power power, String index, String value, String quantity) {
        if (this.sender.hasPermission(S86Permission.POWER_SUPPLY)) {
            if (index != null) {
                int i = -1;
                try {
                    i = Integer.parseInt(index);
                }
                catch (Exception e) {
                    this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.INDEX_MUST_BE_NUMBER));
                    this.sender.sendMessage(LocaleString.EXPECTED_FORMAT.build(new Object[]{HelpTopic.POWER_SUPPLY}));
                }
                if (i >= 0) {
                    if (value != null) {
                        if (value.equalsIgnoreCase("null")) {
                            power.removeSupply(i);
                            this.sender.sendMessage(SUCCESS + LocaleString.POWER_SUPPLY_REMOVE.build(i));
                        } else {
                            ItemStack item;
                            int qty = 1;
                            if (quantity != null) {
                                try {
                                    qty = Integer.parseInt(quantity);
                                }
                                catch (Exception e) {
                                    this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.QUANTITY_NOT_NUMBER));
                                    this.sender.sendMessage(LocaleString.EXPECTED_FORMAT.build(new Object[]{HelpTopic.POWER_SUPPLY}));
                                }
                            }
                            if ((item = this.createItemStack(value, qty)) != null) {
                                power.setSupply(i, item);
                                this.sender.sendMessage(SUCCESS + LocaleString.POWER_SUPPLY_ADD.build(i, PowerTools.getItemName(item)));
                            } else {
                                this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.ITEM_CREATED_INVALID));
                            }
                        }
                    } else {
                        this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.SPECIFY_ITEM_OR_NULL));
                        this.sender.sendMessage(LocaleString.EXPECTED_FORMAT.build(new Object[]{HelpTopic.POWER_SUPPLY}));
                    }
                } else {
                    this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.POWER_SUPPLY_NEGATIVE));
                }
            } else {
                PageMaker pm = new PageMaker(INFO + ChatColor.GREEN + power.getName() + " " + (Object)((Object)LocaleString.SUPPLIES), this.getSupplies(power), 1);
                pm.send(this.sender);
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }
}

