/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import me.sirrus86.s86powers.command.ComAbstract;
import me.sirrus86.s86powers.command.HelpTopic;
import me.sirrus86.s86powers.command.PageMaker;
import me.sirrus86.s86powers.config.ConfigOption;
import me.sirrus86.s86powers.localization.LocaleString;
import me.sirrus86.s86powers.permissions.S86Permission;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerStat;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;

public class ComPlayer
extends ComAbstract {
    public ComPlayer(CommandSender sender, String ... args) {
        super(sender, args);
        if (args.length > 1) {
            if (args[1].equalsIgnoreCase("help")) {
                this.comUserHelp(args.length > 2 ? args[2] : null);
            } else if (args[1].equalsIgnoreCase("list")) {
                this.comUserList(args.length > 2 ? args[2] : null);
            } else {
                PowerUser user = config.getUser(args[1]);
                if (user != null) {
                    if (args.length == 2 || args[2].equalsIgnoreCase("info")) {
                        this.comUserInfo(user);
                    } else if (args[2].equalsIgnoreCase("add")) {
                        this.comUserAdd(user, args.length > 3 ? (args[3].equalsIgnoreCase("random") ? this.getRandomPower(user) : config.getPower(args[3])) : null);
                    } else if (args[2].equalsIgnoreCase("clear")) {
                        this.comUserClear(user, args.length > 3 ? args[3].toUpperCase() : null);
                    } else if (args[2].equalsIgnoreCase("give")) {
                        this.comUserGive(user, args.length > 3 ? config.getPower(args[3]) : null);
                    } else if (args[2].equalsIgnoreCase("option")) {
                        this.comUserOption(user, args.length > 3 ? config.getPower(args[3]) : null, args.length > 4 ? args[4] : null, args.length > 4 ? config.getPower(args[3]).getOptionByName(args[4]) : null, args.length > 5 ? args[5] : null);
                    } else if (args[2].equalsIgnoreCase("remove")) {
                        this.comUserRemove(user, args.length > 3 ? config.getPower(args[3]) : null);
                    } else if (args[2].equalsIgnoreCase("stat") || args[2].equalsIgnoreCase("stats")) {
                        this.comUserStats(user, args.length > 3 ? config.getPower(args[3]) : null, args.length > 4 ? config.getPower(args[3]).getStat(args[4]) : null, args.length > 3 && StringUtils.isNumeric((CharSequence)args[3]) ? Integer.parseInt(args[3]) : -1);
                    } else if (args[2].equalsIgnoreCase("supply")) {
                        this.comUserSupply(user, args.length > 3 ? config.getPower(args[3]) : null);
                    } else if (args[2].equalsIgnoreCase("toggle")) {
                        this.comUserToggle(user, args.length > 3 ? config.getPower(args[3]) : null);
                    } else {
                        sender.sendMessage(ERROR + LocaleString.UNKNOWN_COMMAND.build(args[2]));
                    }
                } else {
                    sender.sendMessage(ERROR + (Object)((Object)LocaleString.UNKNOWN_PLAYER));
                }
            }
        } else {
            this.comUserHelp(null);
        }
    }

    private void comUserAdd(PowerUser user, Power power) {
        if (this.sender.hasPermission(S86Permission.PLAYER_ADD)) {
            if (power != null) {
                if (user.getAssignedPowers().contains(power)) {
                    this.sender.sendMessage(ERROR + LocaleString.PLAYER_ALREADY_HAS_POWER.build(power, user));
                } else if (power.getType() == PowerType.UTILITY) {
                    this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.PLAYER_ASSIGN_UTILITY));
                } else if (!this.sender.hasPermission(power.getAssignPermission())) {
                    this.sender.sendMessage(ERROR + LocaleString.POWER_ASSIGN_NO_PERMISSION.build(power));
                } else if (!this.sender.hasPermission("s86powers.admin") && ConfigOption.Users.ENFORCE_POWER_CAP && (user.getAssignedPowersByType(power.getType()).size() >= ConfigOption.Users.POWER_CAP_PER_TYPE || user.getAssignedPowers().size() >= ConfigOption.Users.POWER_CAP_TOTAL)) {
                    if (user.getAssignedPowersByType(power.getType()).size() >= ConfigOption.Users.POWER_CAP_PER_TYPE) {
                        if (ConfigOption.Users.REPLACE_POWERS_OF_SAME_TYPE) {
                            ArrayList powers = Lists.newArrayList(user.getAssignedPowersByType(power.getType()));
                            Collections.shuffle(powers);
                            Power removePower = (Power)powers.get(0);
                            user.removePower(removePower);
                            this.sender.sendMessage(SUCCESS + LocaleString.PLAYER_REMOVE_POWER_SUCCESS.build(user, removePower));
                            user.addPower(power);
                            this.sender.sendMessage(SUCCESS + LocaleString.PLAYER_ADD_POWER_SUCCESS.build(user, power));
                        } else {
                            this.sender.sendMessage(ERROR + LocaleString.PLAYER_TOO_MANY_POWERS_TYPE.build(new Object[]{user, power.getType()}));
                        }
                    } else if (user.getAssignedPowers().size() >= ConfigOption.Users.POWER_CAP_TOTAL) {
                        this.sender.sendMessage(ERROR + LocaleString.PLAYER_TOO_MANY_POWERS.build(user));
                    }
                } else {
                    user.addPower(power);
                    this.sender.sendMessage(SUCCESS + LocaleString.PLAYER_ADD_POWER_SUCCESS.build(user, power));
                }
            } else {
                this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.UNKNOWN_POWER));
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private void comUserClear(PowerUser user, String type) {
        if (this.sender.hasPermission(S86Permission.PLAYER_CLEAR)) {
            PowerType pType = null;
            if (type != null) {
                try {
                    pType = PowerType.valueOf(type);
                }
                catch (IllegalArgumentException e) {
                    this.sender.sendMessage(ERROR + LocaleString.UNKNOWN_TYPE.build(type));
                    return;
                }
            }
            HashSet powers = pType != null ? Sets.newHashSet(user.getAssignedPowersByType(pType)) : Sets.newHashSet(user.getAssignedPowers());
            for (Power power : powers) {
                user.removePower(power);
                this.sender.sendMessage(SUCCESS + LocaleString.PLAYER_REMOVE_POWER_SUCCESS.build(user, power));
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private void comUserGive(PowerUser user, Power power) {
        if (this.sender.hasPermission(S86Permission.PLAYER_CLEAR)) {
            if (user.isOnline()) {
                if (power != null) {
                    ItemStack book = PowerTools.createPowerBook(power);
                    Collection items = user.getPlayer().getInventory().addItem(new ItemStack[]{book}).values();
                    for (ItemStack item : items) {
                        user.getPlayer().getWorld().dropItem(user.getPlayer().getLocation(), item);
                    }
                    this.sender.sendMessage(SUCCESS + LocaleString.PLAYER_GAVE_POWER_BOOK.build(user, power));
                    user.getPlayer().sendMessage(LocaleString.SELF_RECEIVED_POWER_BOOK.build(power));
                } else {
                    this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.UNKNOWN_POWER));
                }
            } else {
                this.sender.sendMessage(ERROR + LocaleString.PLAYER_NOT_ONLINE.build(user));
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private void comUserHelp(String page) {
        if (this.sender.hasPermission(S86Permission.PLAYER_HELP)) {
            int i = 1;
            if (page != null) {
                try {
                    i = Integer.parseInt(page);
                }
                catch (NumberFormatException e) {
                    i = 1;
                }
            }
            PageMaker pm = new PageMaker(HELP + ChatColor.GREEN + (Object)((Object)LocaleString.PLAYER), HelpTopic.showHelp(this.sender, "PLAYER"), i);
            pm.send(this.sender);
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private void comUserInfo(PowerUser user) {
        if (this.sender.hasPermission(S86Permission.PLAYER_INFO)) {
            this.sender.sendMessage(INFO + this.getUserName(user));
            this.sender.sendMessage((Object)((Object)LocaleString.POWERS) + ": " + this.getPowers(user));
            this.sender.sendMessage((Object)((Object)LocaleString.GROUPS) + ": " + this.getGroups(user));
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private void comUserList(String page) {
        if (this.sender.hasPermission(S86Permission.PLAYER_LIST)) {
            int i = 1;
            if (page != null) {
                try {
                    i = Integer.parseInt(page);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            PageMaker pm = new PageMaker(LIST + ChatColor.GREEN + (Object)((Object)LocaleString.PLAYERS), this.getUsers() + ".", i);
            pm.send(this.sender);
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private final void comUserOption(PowerUser user, Power power, String page, PowerOption<?> option, String valueStr) {
        if (this.sender.hasPermission(S86Permission.PLAYER_OPTION)) {
            if (power != null) {
                if (option != null) {
                    if (valueStr != null) {
                        String value;
                        String string = value = !valueStr.equalsIgnoreCase("null") ? this.validate(option, valueStr) : valueStr;
                        if (!option.isLocked()) {
                            if (value != null) {
                                if (value.toString().equalsIgnoreCase("null")) {
                                    this.sUser.removeOption(option);
                                    this.sender.sendMessage(SUCCESS + LocaleString.REMOVE_OPTION_SUCCESS.build(option.getPath()));
                                } else if (option.getDefaultValue() instanceof List) {
                                    ArrayList<String> optList = new ArrayList<String>((List)power.getOption(option));
                                    if (optList.contains(value)) {
                                        optList.remove(value);
                                        power.setOption(option, optList);
                                        this.sender.sendMessage(SUCCESS + LocaleString.SET_OPTION_REMOVE_SUCCESS.build(option.getPath(), value));
                                    } else {
                                        optList.add(value);
                                        power.setOption(option, optList);
                                        this.sender.sendMessage(SUCCESS + LocaleString.SET_OPTION_ADD_SUCCESS.build(option.getPath(), value));
                                    }
                                } else {
                                    this.sUser.setOption(option, option.getDefaultValue() instanceof Long ? (Long)((Object)value) : value);
                                    this.sender.sendMessage(SUCCESS + LocaleString.SET_OPTION_SUCCESS.build(option.getPath(), value));
                                }
                            } else if (option.getDefaultValue() instanceof List) {
                                this.sender.sendMessage(ERROR + LocaleString.SET_OPTION_FAIL.build(option.getPath(), ((List)option.getDefaultValue()).get(0).getClass(), valueStr));
                            } else {
                                this.sender.sendMessage(ERROR + LocaleString.SET_OPTION_FAIL.build(option.getPath(), option.getDefaultValue().getClass(), valueStr));
                            }
                        } else {
                            this.sender.sendMessage(ERROR + LocaleString.SET_OPTION_LOCKED.build(option.getPath(), valueStr));
                        }
                    } else {
                        this.sender.sendMessage(ChatColor.GREEN + option.getPath());
                        this.sender.sendMessage((Object)((Object)LocaleString.DESCRIPTION) + ": " + ChatColor.GRAY + option.getDescription());
                        this.sender.sendMessage((Object)((Object)LocaleString.TYPE) + ": " + ChatColor.GRAY + option.getDefaultValue().getClass().getSimpleName());
                        this.sender.sendMessage((Object)((Object)LocaleString.VALUE) + ": " + ChatColor.BLUE + (user.getOptionValue(option) instanceof ItemStack ? PowerTools.getItemName((ItemStack)user.getOptionValue(option)) : user.getOptionValue(option).toString()) + ChatColor.RESET + " " + (Object)((Object)LocaleString.DEFAULT) + ": " + ChatColor.GRAY + option.getDefaultValue());
                    }
                } else if (page != null) {
                    try {
                        int i = Integer.parseInt(page);
                        PageMaker pm = new PageMaker(INFO + ChatColor.GOLD + user.getName() + " " + ChatColor.GREEN + power.getName() + " " + (Object)((Object)LocaleString.OPTIONS), this.getOptions(power, user), i);
                        pm.send(this.sender);
                    }
                    catch (NumberFormatException e) {
                        this.sender.sendMessage(ERROR + LocaleString.POWER_MISSING_OPTION.build(power, page));
                    }
                } else {
                    PageMaker pm = new PageMaker(INFO + ChatColor.GOLD + user.getName() + " " + ChatColor.GREEN + power.getName() + " " + (Object)((Object)LocaleString.OPTIONS), this.getOptions(power, user), 1);
                    pm.send(this.sender);
                }
            } else {
                this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.UNKNOWN_POWER));
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private void comUserRemove(PowerUser user, Power power) {
        if (this.sender.hasPermission(S86Permission.PLAYER_REMOVE)) {
            if (power != null) {
                if (!user.getAssignedPowers().contains(power)) {
                    this.sender.sendMessage(ERROR + LocaleString.PLAYER_MISSING_POWER.build(user, power));
                } else {
                    user.removePower(power);
                    this.sender.sendMessage(SUCCESS + LocaleString.PLAYER_REMOVE_POWER_SUCCESS.build(user, power));
                }
            } else {
                this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.UNKNOWN_POWER));
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private void comUserStats(PowerUser user, Power power, PowerStat stat, int value) {
        if (this.sender.hasPermission(S86Permission.PLAYER_STATS)) {
            if (power == null || user.hasPower(power)) {
                if (power != null && stat != null) {
                    if (this.sender.hasPermission(S86Permission.SELF_STATS_SET)) {
                        if (value > -1) {
                            user.increaseStat(stat, value - user.getStatCount(stat));
                            this.sender.sendMessage(SUCCESS + LocaleString.SET_STAT_SUCCESS.build(stat.getPath(), user.getStatCount(stat)));
                        } else {
                            this.sender.sendMessage(INFO + this.getUserName(user) + " " + (Object)((Object)LocaleString.STATS));
                            this.sender.sendMessage(ChatColor.GREEN + stat.getPath() + ChatColor.RESET + ": " + user.getStatCount(stat));
                        }
                    } else {
                        this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
                    }
                } else {
                    this.sender.sendMessage(INFO + this.getUserName(user) + " " + (Object)((Object)LocaleString.STATS));
                    ArrayList powers = power != null ? Lists.newArrayList((Object[])new Power[]{power}) : new ArrayList(user.getPowers());
                    Collections.sort(powers);
                    String tmp = "";
                    for (int i = 0; i < powers.size(); ++i) {
                        Power nextPower = (Power)powers.get(i);
                        ArrayList<PowerStat> stats = new ArrayList<PowerStat>(nextPower.getStats().keySet());
                        Collections.sort(stats);
                        if (stats.isEmpty()) continue;
                        tmp = tmp + nextPower.getType().getColor() + nextPower.getName() + "\n";
                        for (int j = 0; j < stats.size(); ++j) {
                            tmp = tmp + ChatColor.RESET + " " + ((PowerStat)stats.get(j)).getDescription() + ": " + user.getStatCount((PowerStat)stats.get(j)) + "/" + nextPower.getStatValue((PowerStat)stats.get(j)) + "\n";
                            tmp = tmp + "  " + (Object)((Object)LocaleString.REWARD) + ": " + (!user.hasStatMaxed((PowerStat)stats.get(j)) ? ChatColor.GRAY : "") + PowerTools.getFilteredText(nextPower, ((PowerStat)stats.get(j)).getReward()) + "\n";
                        }
                    }
                    if (tmp.equalsIgnoreCase("")) {
                        tmp = LocaleString.NO_STATS_RECORDED.toString();
                    }
                    if (tmp.endsWith("\n")) {
                        tmp = tmp.substring(0, tmp.lastIndexOf("\n"));
                    }
                    this.sender.sendMessage(tmp);
                }
            } else {
                this.sender.sendMessage(ERROR + LocaleString.PLAYER_MISSING_POWER.build(user, power));
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private void comUserSupply(PowerUser user, Power power) {
        if (this.sender.hasPermission(S86Permission.PLAYER_SUPPLY)) {
            if (user.isOnline()) {
                if (power != null) {
                    this.supply(user, power);
                } else {
                    for (Power pwr : user.getPowers()) {
                        this.supply(user, pwr);
                    }
                }
                this.sender.sendMessage(SUCCESS + LocaleString.PLAYER_SUPPLY_SUCCESS.build(user));
            } else {
                this.sender.sendMessage(ERROR + LocaleString.PLAYER_NOT_ONLINE.build(user));
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private void comUserToggle(PowerUser user, Power power) {
        if (this.sender.hasPermission(S86Permission.PLAYER_TOGGLE)) {
            if (power != null) {
                if (user.hasPowerAssigned(power)) {
                    if (user.hasPowerEnabled(power)) {
                        this.sender.sendMessage(SUCCESS + LocaleString.PLAYER_POWER_DISABLED.build(user, power));
                    } else {
                        this.sender.sendMessage(SUCCESS + LocaleString.PLAYER_POWER_ENABLED.build(user, power));
                    }
                    user.setPowerEnabled(power, !user.hasPowerEnabled(power));
                } else {
                    this.sender.sendMessage(ERROR + LocaleString.PLAYER_MISSING_POWER.build(user, power));
                }
            } else {
                if (user.hasPowersEnabled()) {
                    this.sender.sendMessage(SUCCESS + LocaleString.PLAYER_POWERS_DISABLED.build(user));
                } else {
                    this.sender.sendMessage(SUCCESS + LocaleString.PLAYER_POWERS_ENABLED.build(user));
                }
                user.setPowersEnabled(!user.hasPowersEnabled());
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }
}

