/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.command;

import me.sirrus86.s86powers.command.ComAbstract;
import me.sirrus86.s86powers.command.HelpTopic;
import me.sirrus86.s86powers.command.PageMaker;
import me.sirrus86.s86powers.localization.LocaleString;
import me.sirrus86.s86powers.permissions.S86Permission;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public final class ComConfig
extends ComAbstract {
    private boolean save = false;

    public ComConfig(CommandSender sender, String ... args) {
        super(sender, args);
        if (args.length == 1 || args[1].equalsIgnoreCase("help")) {
            this.comConfigHelp(args.length > 2 ? args[2] : null);
        } else if (args[1].equalsIgnoreCase("info")) {
            this.comConfigInfo(args.length > 2 ? args[2] : null);
        } else if (args[1].equalsIgnoreCase("list")) {
            this.comConfigList(args.length > 2 ? args[2] : null);
        } else if (args[1].equalsIgnoreCase("reload")) {
            this.comConfigReload();
        } else if (args[1].equalsIgnoreCase("save")) {
            this.comConfigSave();
        } else if (args[1].equalsIgnoreCase("set")) {
            this.comConfigSet(args.length > 2 ? args[2] : null, args.length > 3 ? args[3] : null);
        } else {
            sender.sendMessage(ERROR + LocaleString.UNKNOWN_COMMAND.build(args[1]));
        }
        if (this.save) {
            config.savePluginConfig();
        }
    }

    private final void comConfigHelp(String page) {
        if (this.sender.hasPermission(S86Permission.CONFIG_HELP)) {
            int i = 1;
            if (page != null) {
                try {
                    i = Integer.parseInt(page);
                }
                catch (NumberFormatException e) {
                    i = 1;
                }
            }
            PageMaker pm = new PageMaker(HELP + ChatColor.GREEN + (Object)((Object)LocaleString.CONFIG), HelpTopic.showHelp(this.sender, "CONFIG"), i);
            pm.send(this.sender);
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private final void comConfigInfo(String option) {
        if (this.sender.hasPermission(S86Permission.CONFIG_INFO)) {
            if (option != null && config.getConfigOptions().containsKey(option)) {
                Object value = config.getConfigValue(option);
                this.sender.sendMessage(INFO + ChatColor.GREEN + option);
                this.sender.sendMessage((Object)((Object)LocaleString.DESCRIPTION) + ": " + ChatColor.GRAY + LocaleString.getString(option.substring(option.indexOf(".") + 1).toUpperCase().replaceAll("-", "_") + "_CONFIG"));
                try {
                    this.sender.sendMessage((Object)((Object)LocaleString.VALUE) + ": " + ChatColor.BLUE + value.toString());
                }
                catch (Exception e) {
                    this.sender.sendMessage((Object)((Object)LocaleString.VALUE) + ": " + ChatColor.GRAY + (Object)((Object)LocaleString.VIEW_VALUE_FAIL));
                    e.printStackTrace();
                }
            } else {
                this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.MUST_SPECIFY_OPTION));
                this.sender.sendMessage(LocaleString.EXPECTED_FORMAT.build(new Object[]{HelpTopic.CONFIG_INFO}));
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private final void comConfigList(String page) {
        if (this.sender.hasPermission(S86Permission.CONFIG_LIST)) {
            int i = 1;
            if (page != null) {
                try {
                    i = Integer.parseInt(page);
                }
                catch (NumberFormatException e) {
                    i = 1;
                }
            }
            PageMaker pm = new PageMaker(LIST + ChatColor.GREEN + "Config", this.optList(), i);
            pm.send(this.sender);
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private final void comConfigReload() {
        if (this.sender.hasPermission(S86Permission.CONFIG_RELOAD)) {
            config.loadPluginConfig();
            this.sender.sendMessage(SUCCESS + (Object)((Object)LocaleString.CONFIG_RELOADED));
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private final void comConfigSave() {
        if (this.sender.hasPermission(S86Permission.CONFIG_SAVE)) {
            config.savePluginConfig();
            this.sender.sendMessage(SUCCESS + (Object)((Object)LocaleString.CONFIG_SAVED));
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }

    private final void comConfigSet(String option, Object value) {
        if (this.sender.hasPermission(S86Permission.CONFIG_SET)) {
            if (option != null && config.getConfigOptions().containsKey(option)) {
                if (value != null) {
                    if (config.setConfigValue(option, value)) {
                        this.sender.sendMessage(SUCCESS + LocaleString.SET_OPTION_SUCCESS.build(option, value));
                    } else {
                        Object oldValue = config.getConfigValue(option);
                        this.sender.sendMessage(ERROR + LocaleString.VALUE_WRONG_TYPE.build(oldValue.getClass().getSimpleName()));
                    }
                } else {
                    this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.MUST_SPECIFY_VALUE));
                    this.sender.sendMessage(LocaleString.EXPECTED_FORMAT.build(new Object[]{HelpTopic.CONFIG_SET}));
                }
            } else {
                this.sender.sendMessage(ERROR + LocaleString.UNKNOWN_OPTION.build(option));
            }
        } else {
            this.sender.sendMessage(ERROR + (Object)((Object)LocaleString.NO_PERMISSION));
        }
    }
}

