/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.sirrus86.s86powers.S86Powers;
import me.sirrus86.s86powers.config.ConfigManager;
import me.sirrus86.s86powers.localization.LocaleString;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerStat;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.regions.NeutralRegion;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerGroup;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public abstract class ComAbstract {
    protected static final String ERROR = ChatColor.WHITE + "[" + ChatColor.RED + (Object)((Object)LocaleString.ERROR_CAPS) + ChatColor.WHITE + "] " + ChatColor.RESET;
    protected static final String HELP = ChatColor.WHITE + "[" + ChatColor.YELLOW + (Object)((Object)LocaleString.HELP_CAPS) + ChatColor.WHITE + "] " + ChatColor.RESET;
    protected static final String INFO = ChatColor.WHITE + "[" + ChatColor.YELLOW + (Object)((Object)LocaleString.INFO_CAPS) + ChatColor.WHITE + "] " + ChatColor.RESET;
    protected static final String LIST = ChatColor.WHITE + "[" + ChatColor.YELLOW + (Object)((Object)LocaleString.LIST_CAPS) + ChatColor.WHITE + "] " + ChatColor.RESET;
    protected static final String SUCCESS = ChatColor.WHITE + "[" + ChatColor.GREEN + (Object)((Object)LocaleString.SUCCESS_CAPS) + ChatColor.WHITE + "] " + ChatColor.RESET;
    protected static final ConfigManager config = S86Powers.getConfigManager();
    protected final CommandSender sender;
    protected final PowerUser sUser;

    protected ComAbstract(CommandSender sender, String ... args) {
        this.sender = sender;
        this.sUser = sender instanceof Player ? S86Powers.getConfigManager().getUser(((Player)sender).getUniqueId()) : null;
    }

    protected final ItemStack createItemStack(String value) {
        return this.createItemStack(value, 1);
    }

    protected final ItemStack createItemStack(String value, int qty) {
        ItemStack item = null;
        String type = "";
        Material mat = Material.getMaterial((String)type);
        if (mat == null) {
            mat = Material.matchMaterial((String)value);
        }
        if (mat != null) {
            item = new ItemStack(mat, qty);
        }
        if (item != null) {
            if (item.getType() == Material.AIR) {
                return new ItemStack(Material.AIR, 0);
            }
            return item;
        }
        return null;
    }

    private final PotionEffect createPotionEffect(String value) {
        String[] values;
        PotionEffect effect = null;
        if (value != null && (values = value.split(",")).length > 2) {
            PotionEffectType eType = PotionEffectType.getByName((String)values[0]);
            int eDur = Integer.parseInt(values[1]);
            int eAmp = Integer.parseInt(values[2]);
            boolean eAmbient = true;
            boolean eParticles = true;
            boolean eIcon = true;
            if (values.length > 3) {
                eAmbient = Boolean.parseBoolean(values[3]);
                if (values.length > 4) {
                    eParticles = Boolean.parseBoolean(values[4]);
                    if (values.length > 5) {
                        eIcon = Boolean.parseBoolean(values[5]);
                    }
                }
            }
            try {
                effect = new PotionEffect(eType, eDur, eAmp, eAmbient, eParticles, eIcon);
            }
            catch (Exception e) {
                effect = null;
            }
        }
        return effect;
    }

    protected final String getGroups() {
        ArrayList groups = Lists.newArrayList(S86Powers.getConfigManager().getGroups());
        Collections.sort(groups);
        String tmp = "";
        for (int i = 0; i < groups.size(); ++i) {
            PowerGroup group = (PowerGroup)groups.get(i);
            tmp = tmp + ChatColor.GREEN + group.getName() + ChatColor.GRAY;
            if (i >= groups.size() - 1) continue;
            tmp = tmp + ", ";
        }
        return tmp == "" ? LocaleString.NONE.toString() : tmp;
    }

    protected final String getGroups(PowerUser user) {
        String tmp = "";
        ArrayList pList = Lists.newArrayList(user.getGroups());
        Collections.sort(pList);
        for (int i = 0; i < pList.size(); ++i) {
            PowerGroup group = (PowerGroup)pList.get(i);
            tmp = tmp + ChatColor.RESET + group.getName() + ChatColor.RESET;
            if (!user.getAssignedGroups().contains(group)) {
                tmp = tmp + "(" + ChatColor.GRAY + "P" + ChatColor.RESET + ")";
            }
            if (i >= pList.size() - 1) continue;
            tmp = tmp + ChatColor.GRAY + ", ";
        }
        return tmp.equalsIgnoreCase("") ? LocaleString.NONE.toString() : tmp;
    }

    protected final String getOptions(Power power) {
        ArrayList options = Lists.newArrayList(power.getOptions().keySet());
        Collections.sort(options);
        String tmp = "";
        for (int i = 0; i < options.size(); ++i) {
            PowerOption option = (PowerOption)options.get(i);
            String valueStr = power.getOption(option).toString();
            if (power.getOption(option) instanceof ItemStack) {
                valueStr = PowerTools.getItemName((ItemStack)power.getOption(option));
            } else if (power.getOption(option) instanceof List) {
                valueStr = LocaleString.LIST.toString() + " {";
                List optList = (List)power.getOption(option);
                for (int j = 0; j < optList.size(); ++j) {
                    valueStr = valueStr + optList.get(j).toString() + (j < optList.size() ? ", " : "");
                }
                valueStr = valueStr + "}";
            }
            tmp = tmp + ChatColor.GREEN + option.getPath() + ChatColor.GRAY + ": " + ChatColor.WHITE + valueStr + "\n";
        }
        if (tmp.endsWith("\n")) {
            tmp = tmp.substring(0, tmp.lastIndexOf("\n"));
        }
        tmp.split("\n");
        return tmp == "" ? LocaleString.NONE.toString() : tmp;
    }

    protected final String getOptions(Power power, PowerUser user) {
        ArrayList options = new ArrayList();
        for (PowerOption<?> option : user.getOptions().keySet()) {
            if (option.getPower() != power) continue;
            options.add(option);
        }
        Collections.sort(options);
        String tmp = "";
        for (int i = 0; i < options.size(); ++i) {
            PowerOption option = (PowerOption)options.get(i);
            String valueStr = user.getOption(option).toString();
            if (user.getOption(option) instanceof ItemStack) {
                valueStr = PowerTools.getItemName((ItemStack)user.getOption(option));
            } else if (user.getOption(option) instanceof List) {
                valueStr = LocaleString.LIST.toString() + " {";
                List optList = (List)user.getOption(option);
                for (int j = 0; j < optList.size(); ++j) {
                    valueStr = valueStr + optList.get(j).toString() + (j < optList.size() ? ", " : "");
                }
                valueStr = valueStr + "}";
            }
            tmp = tmp + ChatColor.GREEN + option.getPath() + ChatColor.GRAY + ": " + ChatColor.WHITE + valueStr + "\n";
        }
        if (tmp.endsWith("\n")) {
            tmp = tmp.substring(0, tmp.lastIndexOf("\n"));
        }
        tmp.split("\n");
        return tmp == "" ? LocaleString.NONE.toString() : tmp;
    }

    protected final String getPowerDesc(Power power) {
        power.refreshOptions();
        return PowerTools.getFilteredText(power, power.getDescription());
    }

    protected final String getPowerList(Set<Power> list) {
        String tmp = "(" + ChatColor.GRAY + list.size() + ChatColor.RESET + ") ";
        ArrayList powers = Lists.newArrayList(list);
        Collections.sort(powers);
        for (int i = 0; i < powers.size(); ++i) {
            Power power = (Power)powers.get(i);
            tmp = tmp + power.getType().getColor() + power.getTag() + ChatColor.GRAY;
            if (i >= powers.size() - 1) continue;
            tmp = tmp + ", ";
        }
        return list.isEmpty() ? LocaleString.NONE.toString() : tmp;
    }

    protected final String getPowers(PowerGroup group) {
        String tmp = "";
        ArrayList pList = Lists.newArrayList(group.getPowers());
        Collections.sort(pList);
        for (int i = 0; i < pList.size(); ++i) {
            Power power = (Power)pList.get(i);
            tmp = tmp + power.getType().getColor() + power.getTag() + ChatColor.RESET;
            if (i >= pList.size() - 1) continue;
            tmp = tmp + ChatColor.GRAY + ", ";
        }
        return tmp.equalsIgnoreCase("") ? LocaleString.NONE.toString() : tmp;
    }

    protected final String getPowers(PowerUser user) {
        String tmp = "";
        ArrayList pList = Lists.newArrayList(user.getPowers());
        Collections.sort(pList);
        for (int i = 0; i < pList.size(); ++i) {
            Power power = (Power)pList.get(i);
            tmp = tmp + power.getType().getColor() + power.getTag() + ChatColor.RESET;
            if (!user.getAssignedPowers().contains(pList.get(i))) {
                if (user.getGroupPowers().contains(pList.get(i))) {
                    tmp = tmp + "(" + ChatColor.GRAY + "G" + ChatColor.RESET + ")";
                } else if (user.getPermissiblePowers().contains(pList.get(i))) {
                    tmp = tmp + "(" + ChatColor.GRAY + "P" + ChatColor.RESET + ")";
                }
            }
            if (i >= pList.size() - 1) continue;
            tmp = tmp + ChatColor.GRAY + ", ";
        }
        return tmp.equalsIgnoreCase("") ? LocaleString.NONE.toString() : tmp;
    }

    protected final Power getRandomPower(PowerGroup group) {
        ArrayList powers = Lists.newArrayList(config.getPowers());
        powers.removeAll(config.getPowersByType(PowerType.UTILITY));
        powers.removeAll(group.getPowers());
        Collections.shuffle(powers);
        return !powers.isEmpty() ? (Power)powers.get(0) : null;
    }

    protected final Power getRandomPower(PowerUser user) {
        ArrayList powers = Lists.newArrayList(config.getPowers());
        powers.removeAll(config.getPowersByType(PowerType.UTILITY));
        powers.removeAll(user.getAssignedPowers());
        Collections.shuffle(powers);
        return !powers.isEmpty() ? (Power)powers.get(0) : null;
    }

    protected final String getRegions() {
        ArrayList regions = Lists.newArrayList(S86Powers.getConfigManager().getRegions());
        Collections.sort(regions);
        String tmp = "";
        for (int i = 0; i < regions.size(); ++i) {
            NeutralRegion region = (NeutralRegion)regions.get(i);
            tmp = tmp + ChatColor.GREEN + region.getName() + ChatColor.GRAY;
            if (i >= regions.size() - 1) continue;
            tmp = tmp + ", ";
        }
        return tmp == "" ? LocaleString.NONE.toString() : tmp;
    }

    protected final String getStats(Power power) {
        ArrayList stats = Lists.newArrayList(power.getStats().keySet());
        Collections.sort(stats);
        String tmp = "";
        for (int i = 0; i < stats.size(); ++i) {
            PowerStat stat = (PowerStat)stats.get(i);
            tmp = tmp + ChatColor.GREEN + stat.getPath() + ChatColor.GRAY + ": " + ChatColor.WHITE + power.getStatValue(stat) + "\n";
        }
        if (tmp.endsWith("\n")) {
            tmp = tmp.substring(0, tmp.lastIndexOf("\n"));
        }
        tmp.split("\n");
        return tmp == "" ? LocaleString.NONE.toString() : tmp;
    }

    protected final String getSupplies(Power power) {
        String tmp = "";
        for (int i = 0; i < power.getSupplies().size(); ++i) {
            tmp = tmp + ChatColor.GREEN + i + ChatColor.RESET + ": " + ChatColor.GRAY + PowerTools.getItemName(power.getSupplies().get(i)) + " x" + power.getSupplies().get(i).getAmount() + "\n";
        }
        if (tmp.equalsIgnoreCase("")) {
            return LocaleString.NONE.toString();
        }
        tmp.split("\n");
        return tmp;
    }

    protected final String getUserName(PowerUser user) {
        ChatColor color = ChatColor.GREEN;
        if (user.isAdmin()) {
            color = ChatColor.GOLD;
        } else if (user.getPowers().isEmpty()) {
            color = ChatColor.GRAY;
        }
        return color + (user.getName() != null ? user.getName() : "NULL") + ChatColor.RESET;
    }

    protected final String getUsers() {
        ArrayList users = Lists.newArrayList(S86Powers.getConfigManager().getUserList());
        Collections.sort(users);
        String tmp = "";
        for (int i = 0; i < users.size(); ++i) {
            PowerUser user = (PowerUser)users.get(i);
            tmp = tmp + this.getUserName(user) + ChatColor.GRAY;
            if (i >= users.size() - 1) continue;
            tmp = tmp + ", ";
        }
        return tmp == "" ? LocaleString.NONE.toString() : tmp;
    }

    protected final String getUsers(Power power) {
        ArrayList users = Lists.newArrayList(power.getUsers());
        Collections.sort(users);
        String tmp = "";
        for (int i = 0; i < users.size(); ++i) {
            PowerUser user = (PowerUser)users.get(i);
            tmp = tmp + this.getUserName(user) + ChatColor.GRAY;
            if (i >= users.size() - 1) continue;
            tmp = tmp + ", ";
        }
        return tmp == "" ? LocaleString.NONE.toString() : tmp;
    }

    protected final String getUsers(PowerGroup group) {
        ArrayList users = Lists.newArrayList(group.getMembers());
        Collections.sort(users);
        String tmp = "";
        for (int i = 0; i < users.size(); ++i) {
            PowerUser user = (PowerUser)users.get(i);
            tmp = tmp + this.getUserName(user) + ChatColor.GRAY;
            if (i >= users.size() - 1) continue;
            tmp = tmp + ", ";
        }
        return tmp == "" ? LocaleString.NONE.toString() : tmp;
    }

    protected final void killPower(Power power) {
        HashSet fields = Sets.newHashSet((Object[])Power.class.getDeclaredFields());
        fields.addAll(Sets.newHashSet((Object[])power.getClass().getDeclaredFields()));
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                field.set(this, null);
            }
            catch (Exception exception) {}
        }
        System.gc();
    }

    protected final String optList() {
        String tmp = "";
        ArrayList options = Lists.newArrayList(S86Powers.getConfigManager().getConfigOptions().keySet());
        Collections.sort(options);
        for (int i = 0; i < options.size(); ++i) {
            String option = (String)options.get(i);
            Object value = S86Powers.getConfigManager().getConfigValue(option);
            tmp = tmp + ChatColor.GREEN + option + ChatColor.RESET + ": " + value.toString() + "\n";
        }
        if (tmp.endsWith("\n")) {
            tmp = tmp.substring(0, tmp.lastIndexOf("\n"));
        }
        return tmp;
    }

    protected final void supply(PowerUser user, Power power) {
        user.supply(power);
    }

    protected final Object validate(PowerOption<?> option, String value) {
        Object defValue;
        Object object = defValue = option.getDefaultValue() instanceof List ? ((List)option.getDefaultValue()).get(0) : option.getDefaultValue();
        if (defValue instanceof Boolean && (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("true"))) {
            return Boolean.parseBoolean(value);
        }
        if (defValue instanceof Double) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (defValue instanceof Float) {
            try {
                return Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (defValue instanceof Long) {
            try {
                return PowerTime.toMillis(value);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (defValue instanceof Integer) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (defValue instanceof ItemStack) {
            return this.createItemStack(value);
        }
        if (defValue instanceof PotionEffect) {
            return this.createPotionEffect(value);
        }
        if (defValue instanceof String) {
            return value;
        }
        return null;
    }

    protected final int validate(PowerStat stat, String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

