/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import me.sirrus86.s86powers.command.PowerComExecutor;
import me.sirrus86.s86powers.command.PowerTabCompleter;
import me.sirrus86.s86powers.config.ConfigManager;
import me.sirrus86.s86powers.config.ConfigOption;
import me.sirrus86.s86powers.listeners.BlockListener;
import me.sirrus86.s86powers.listeners.GUIListener;
import me.sirrus86.s86powers.listeners.PlayerListener;
import me.sirrus86.s86powers.listeners.PowerListener;
import me.sirrus86.s86powers.localization.LocaleLoader;
import me.sirrus86.s86powers.localization.LocaleString;
import me.sirrus86.s86powers.permissions.PermissionHandler;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.version.MCVersion;
import me.sirrus86.s86powers.utils.Metrics;
import me.sirrus86.s86powers.utils.PowerExporter;
import me.sirrus86.s86powers.utils.PowerLoader;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class S86Powers
extends JavaPlugin {
    private static BlockListener bList;
    private static PowerComExecutor comExec;
    private static ConfigManager configManager;
    private static File groupDir;
    private static File powerDir;
    private static File userDir;
    private static PowerTabCompleter pTC;
    private static final Plugin protocolLib;
    private static double pLibVer;

    public void onEnable() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        configManager = new ConfigManager(this);
        configManager.loadPluginConfig();
        configManager.loadPowerConfig();
        configManager.loadNeutralRegions();
        try {
            new LocaleLoader();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (protocolLib == null) {
            S86Powers.log(Level.WARNING, ChatColor.YELLOW + LocaleString.PROTOCOLLIB_NOT_DETECTED.toString());
        } else if (MCVersion.CURRENT_VERSION.getRequiredProtocolLib() > S86Powers.getProtocolLibVersion()) {
            S86Powers.log(Level.WARNING, ChatColor.YELLOW + LocaleString.BAD_PROTOCOLLIB_VERSION.build(MCVersion.CURRENT_VERSION.getRequiredProtocolLib(), protocolLib != null ? protocolLib.getDescription().getVersion() : "N/A"));
        }
        new PermissionHandler(this);
        new PowerExporter(this, this.getFile());
        new PowerLoader(this.getPowerDirectory());
        S86Powers.log(Level.INFO, LocaleString.POWERS_LOAD_SUCCESS.build(configManager.getPowers().size()));
        configManager.loadUsers();
        configManager.loadGroups();
        bList = new BlockListener(this);
        new PowerListener(this);
        new PlayerListener(this);
        new GUIListener(this);
        this.initCommands();
        if (ConfigOption.Plugin.USE_METRICS) {
            this.doMetrics();
        }
    }

    public void onDisable() {
        configManager.disablePowers();
        if (ConfigOption.Plugin.SAVE_ON_DISABLE) {
            configManager.saveAll();
        }
    }

    private void doMetrics() {
        Metrics metrics = new Metrics((Plugin)this);
        metrics.addCustomChart(new Metrics.AdvancedPie("used_powers", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                for (Power power : configManager.getPowers()) {
                    if (power.getType() == PowerType.UTILITY) continue;
                    valueMap.put(power.getName(), power.getUsers().size());
                }
                return valueMap;
            }
        }));
    }

    public final BlockListener getBlockListener() {
        return bList;
    }

    public static final ConfigManager getConfigManager() {
        return configManager;
    }

    public final File getGroupDirectory() {
        if (groupDir == null) {
            groupDir = new File(this.getDataFolder(), "groups");
        }
        if (!groupDir.exists()) {
            groupDir.mkdirs();
        }
        return groupDir;
    }

    private static final double getProtocolLibVersion() {
        if (pLibVer < 0.0) {
            try {
                if (protocolLib != null) {
                    pLibVer = Double.parseDouble(protocolLib.getDescription().getVersion().substring(0, 3));
                }
            }
            catch (Exception e) {
                pLibVer = 0.0;
            }
        }
        return pLibVer;
    }

    public final File getPowerDirectory() {
        if (powerDir == null) {
            powerDir = new File(this.getDataFolder(), "powers");
        }
        if (!powerDir.exists()) {
            powerDir.mkdirs();
        }
        return powerDir;
    }

    public static final Plugin getProtocolLib() {
        return protocolLib;
    }

    public final File getUserDirectory() {
        if (userDir == null) {
            userDir = new File(this.getDataFolder(), "users");
        }
        if (!userDir.exists()) {
            userDir.mkdirs();
        }
        return userDir;
    }

    private final void initCommands() {
        comExec = new PowerComExecutor();
        pTC = new PowerTabCompleter();
        PluginCommand cmd = this.getCommand("powers");
        cmd.setTabCompleter((TabCompleter)pTC);
        cmd.setExecutor((CommandExecutor)comExec);
    }

    public static final void log(Level level, String string) {
        if (ConfigOption.Plugin.SHOW_COLORS_IN_CONSOLE) {
            Bukkit.getServer().getConsoleSender().sendMessage("[S86Powers] " + string);
        } else {
            Bukkit.getLogger().log(level, ChatColor.stripColor((String)string));
        }
    }

    @Deprecated
    public static final void showDebug(String message) {
        if (ConfigOption.Plugin.SHOW_DEBUG_MESSAGES) {
            S86Powers.log(Level.WARNING, message);
        }
    }

    static {
        protocolLib = Bukkit.getServer().getPluginManager().getPlugin("ProtocolLib");
        pLibVer = -1.0;
    }
}

