/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.tehkode.permissions.PermissionEntity;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.PermissionsGroupData;
import ru.tehkode.permissions.events.PermissionEntityEvent;

public class PermissionGroup
extends PermissionEntity
implements Comparable<PermissionGroup> {
    protected int weight = 0;
    protected boolean dirtyWeight = true;
    private final PermissionsGroupData data;

    public PermissionGroup(String groupName, PermissionsGroupData data, PermissionManager manager) {
        super(groupName, manager);
        this.data = data;
    }

    @Override
    protected PermissionsGroupData getData() {
        return this.data;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.isDebug()) {
            this.manager.getLogger().info("Group " + this.getIdentifier() + " initialized");
        }
    }

    @Override
    public PermissionEntity.Type getType() {
        return PermissionEntity.Type.GROUP;
    }

    public int getWeight() {
        if (this.dirtyWeight) {
            this.weight = this.getOwnOptionInteger("weight", null, 0);
            this.dirtyWeight = false;
        }
        return this.weight;
    }

    public void setWeight(int weight) {
        this.setOption("weight", Integer.toString(weight));
        this.dirtyWeight = true;
        this.callEvent(PermissionEntityEvent.Action.WEIGHT_CHANGED);
    }

    public boolean isRanked() {
        return this.getRank() > 0;
    }

    public int getRank() {
        return this.getOwnOptionInteger("rank", null, 0);
    }

    public void setRank(int rank) {
        if (rank > 0) {
            this.setOption("rank", Integer.toString(rank));
        } else {
            this.setOption("rank", null);
        }
        this.callEvent(PermissionEntityEvent.Action.RANK_CHANGED);
    }

    public String getRankLadder() {
        return this.getOwnOption("rank-ladder", null, "default");
    }

    public void setRankLadder(String rankLadder) {
        if (rankLadder.isEmpty() || rankLadder.equals("default")) {
            rankLadder = null;
        }
        this.setOption("rank-ladder", rankLadder);
        this.callEvent(PermissionEntityEvent.Action.RANK_CHANGED);
    }

    public boolean isChildOf(PermissionGroup group, String worldName, boolean checkInheritance) {
        return this.isChildOf(group, worldName, checkInheritance ? new HashSet() : null);
    }

    private boolean isChildOf(PermissionGroup group, String worldName, Set<String> visitedParents) {
        if (group == null) {
            return false;
        }
        if (visitedParents != null) {
            visitedParents.add(this.getIdentifier());
        }
        for (String parentGroup : this.getData().getParents(worldName)) {
            if (visitedParents != null && visitedParents.contains(parentGroup)) continue;
            if (group.getIdentifier().equals(parentGroup)) {
                return true;
            }
            if (visitedParents == null || !this.manager.getGroup(parentGroup).isChildOf(group, worldName, visitedParents)) continue;
            return true;
        }
        return false;
    }

    public boolean isChildOf(PermissionGroup group, boolean checkInheritance) {
        for (String worldName : this.getWorlds()) {
            if (!this.isChildOf(group, worldName, checkInheritance)) continue;
            return true;
        }
        return this.isChildOf(group, null, checkInheritance);
    }

    public boolean isChildOf(PermissionGroup group, String worldName) {
        return this.isChildOf(group, worldName, false);
    }

    public boolean isChildOf(PermissionGroup group) {
        return this.isChildOf(group, false);
    }

    public boolean isChildOf(String groupName, String worldName, boolean checkInheritance) {
        return this.isChildOf(this.manager.getGroup(groupName), worldName, checkInheritance);
    }

    public boolean isChildOf(String groupName, boolean checkInheritance) {
        return this.isChildOf(this.manager.getGroup(groupName), checkInheritance);
    }

    public boolean isChildOf(String groupName, String worldName) {
        return this.isChildOf(groupName, worldName, false);
    }

    public boolean isChildOf(String groupName) {
        return this.isChildOf(groupName, false);
    }

    public List<PermissionGroup> getChildGroups(String worldName) {
        return this.manager.getGroups(this.getIdentifier(), worldName, false);
    }

    public List<PermissionGroup> getChildGroups() {
        return this.manager.getGroups(this.getIdentifier(), false);
    }

    public List<PermissionGroup> getDescendantGroups(String worldName) {
        return this.manager.getGroups(this.getIdentifier(), worldName, true);
    }

    public List<PermissionGroup> getDescendantGroups() {
        return this.manager.getGroups(this.getIdentifier(), true);
    }

    public Set<PermissionUser> getUsers(String worldName) {
        return this.manager.getUsers(this.getIdentifier(), worldName, false);
    }

    public Set<PermissionUser> getUsers() {
        return this.manager.getUsers(this.getIdentifier());
    }

    public Set<PermissionUser> getActiveUsers() {
        return this.manager.getActiveUsers(this.getIdentifier());
    }

    public Set<PermissionUser> getActiveUsers(boolean inheritance) {
        return this.manager.getActiveUsers(this.getIdentifier(), inheritance);
    }

    public boolean isDefault(String worldName) {
        return this.getOwnOptionBoolean("default", worldName, false);
    }

    public void setDefault(boolean def, String worldName) {
        this.setOption("default", String.valueOf(def), worldName);
        this.callEvent(PermissionEntityEvent.Action.DEFAULTGROUP_CHANGED);
    }

    @Override
    protected void clearCache() {
        this.dirtyWeight = true;
        for (PermissionUser user : this.getActiveUsers()) {
            user.clearCache();
        }
    }

    @Override
    public final void remove() {
        for (String world : this.getWorlds()) {
            this.clearChildren(world);
        }
        this.clearChildren(null);
        super.remove();
    }

    private void clearChildren(String worldName) {
        for (PermissionGroup group : this.getChildGroups(worldName)) {
            LinkedList<PermissionGroup> parentGroups = new LinkedList<PermissionGroup>(group.getOwnParents(worldName));
            parentGroups.remove(this);
            group.setParents(parentGroups, worldName);
        }
        for (PermissionUser user : this.getUsers(worldName)) {
            user.removeGroup(this, worldName);
        }
    }

    @Override
    public int compareTo(PermissionGroup o) {
        return this.getWeight() - o.getWeight();
    }

    @Deprecated
    public String[] getParentGroupsNames(String worldName) {
        return this.getParentIdentifiers(worldName).toArray(new String[0]);
    }

    @Deprecated
    public String[] getParentGroupsNames() {
        return this.getParentIdentifiers().toArray(new String[0]);
    }

    @Deprecated
    public void setParentGroups(List<String> parentGroups, String worldName) {
        this.setParentsIdentifier(parentGroups, worldName);
    }

    @Deprecated
    public void setParentGroups(List<String> parentGroups) {
        this.setParentsIdentifier(parentGroups);
    }

    @Deprecated
    public void setParentGroupObjects(List<PermissionGroup> parentGroups, String worldName) {
        this.setParents(parentGroups, worldName);
    }

    @Deprecated
    public void setParentGroupObjects(List<PermissionGroup> parentGroups) {
        this.setParents(parentGroups);
    }

    @Deprecated
    public List<PermissionGroup> getParentGroups(String worldName) {
        return this.getParents(worldName);
    }

    @Deprecated
    public List<PermissionGroup> getParentGroups() {
        return this.getParentGroups(null);
    }

    @Deprecated
    public Map<String, List<PermissionGroup>> getAllParentGroups() {
        return this.getAllParents();
    }
}

