/*
 * Decompiled with CFR 0.152.
 */
package me.telesphoreo.commandspy;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitTask;

public class PlayerData {
    public static final Map<String, PlayerData> PLAYER_DATA = new HashMap<String, PlayerData>();
    public static final long AUTO_PURGE = 6000L;
    final Player player;
    final String ip;
    final UUID uuid;
    private boolean cmdspyEnabled = false;
    private BukkitTask lockupScheduleTask = null;

    public static boolean hasPlayerData(Player player) {
        return PLAYER_DATA.containsKey(player.getPlayer().getAddress().getAddress().getHostAddress().trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlayerData getPlayerDataSync(Player player) {
        Map<String, PlayerData> map = PLAYER_DATA;
        synchronized (map) {
            return PlayerData.getPlayerData(player);
        }
    }

    public static PlayerData getPlayerData(Player player) {
        String ip = player.getPlayer().getAddress().getAddress().getHostAddress().trim();
        PlayerData data = PLAYER_DATA.get(ip);
        if (data != null) {
            return data;
        }
        if (Bukkit.getOnlineMode()) {
            for (PlayerData dataTest : PLAYER_DATA.values()) {
                if (!dataTest.player.getName().equalsIgnoreCase(player.getName())) continue;
                data = dataTest;
                break;
            }
        }
        if (data != null) {
            return data;
        }
        data = new PlayerData(player, player.getUniqueId(), ip);
        PLAYER_DATA.put(ip, data);
        return data;
    }

    public PlayerData(Player player, UUID uuid, String ip) {
        this.player = player;
        this.uuid = uuid;
        this.ip = ip;
    }

    public void setCommandSpy(boolean enabled) {
        this.cmdspyEnabled = enabled;
    }

    public boolean cmdspyEnabled() {
        return this.cmdspyEnabled;
    }

    public BukkitTask getLockupScheduleID() {
        return this.lockupScheduleTask;
    }

    public void setLockupScheduleId(BukkitTask id) {
        this.lockupScheduleTask = id;
    }

    public PlayerData getPlayer(Player player) {
        PlayerData tPlayer = PLAYER_DATA.get(player.getAddress().getHostName());
        if (tPlayer != null) {
            return tPlayer;
        }
        PLAYER_DATA.put(player.getAddress().getHostName(), tPlayer);
        return tPlayer;
    }
}

