/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.cookme;

import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.UUID;
import org.bukkit.entity.Player;

public class CooldownManager {
    private int cooldown;
    private LinkedHashMap<UUID, Timestamp> cooldownList = new LinkedHashMap();

    public CooldownManager(int cooldownValue) {
        this.cooldown = cooldownValue;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldownValue) {
        this.cooldown = cooldownValue;
    }

    public boolean addPlayer(Player player) {
        Timestamp time = new Timestamp(System.currentTimeMillis());
        if (!this.cooldownList.containsKey(player.getUniqueId())) {
            this.cooldownList.put(player.getUniqueId(), time);
            return true;
        }
        return false;
    }

    public boolean removePlayer(Player player) {
        if (this.cooldownList.containsKey(player.getUniqueId())) {
            this.cooldownList.remove(player.getUniqueId());
            return true;
        }
        return false;
    }

    public boolean hasCooldown(Player player, Timestamp now) {
        if (this.cooldownList.containsKey(player.getUniqueId())) {
            Timestamp time = this.cooldownList.get(player.getUniqueId());
            long difference = (now.getTime() - time.getTime()) / 1000L;
            if (difference > (long)this.cooldown) {
                this.removePlayer(player);
            } else {
                return true;
            }
        }
        return false;
    }

    public void clearCooldownList() {
        this.cooldownList.clear();
    }

    public long getRemainingCooldownTime(Player player, Timestamp now) {
        if (this.cooldownList.containsKey(player.getUniqueId())) {
            Timestamp time = this.cooldownList.get(player.getUniqueId());
            long difference = (now.getTime() - time.getTime()) / 1000L;
            if (difference > (long)this.cooldown) {
                return 0L;
            }
            return difference;
        }
        return 0L;
    }
}

