/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.cookme;

import de.dustplanet.cookme.CookMe;
import java.sql.Timestamp;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CookMePlayerListener
implements Listener {
    private CookMe plugin;
    private boolean message = true;
    private Random random = new Random();

    public CookMePlayerListener(CookMe instance) {
        this.plugin = instance;
    }

    @EventHandler
    public void onPlayerConsumeItem(PlayerItemConsumeEvent event) {
        ItemStack item;
        boolean mainHand;
        String effect = "damage";
        Player player = event.getPlayer();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        boolean bl = mainHand = event.getItem().getType() == player.getInventory().getItemInMainHand().getType();
        if (!player.hasPermission("cookme.safe")) {
            if (this.sameItem(event.getItem().getType()) && !this.plugin.getCooldownManager().hasCooldown(player, now)) {
                double temp = 0.0;
                int effectNumber = -1;
                for (int i = 0; i < this.plugin.getPercentages().length; ++i) {
                    temp += this.plugin.getPercentages()[i];
                    if (!((double)this.random.nextInt(100) < temp)) continue;
                    effectNumber = i;
                    break;
                }
                int effectStrength = 0;
                effectStrength = this.plugin.isRandomEffectStrength() ? this.random.nextInt(16) : this.plugin.getEffectStrengths()[effectNumber];
                int randomEffectTime = this.random.nextInt(this.plugin.getMaxDuration() - this.plugin.getMinDuration() + 1) + this.plugin.getMinDuration();
                switch (effectNumber) {
                    default: {
                        return;
                    }
                    case 0: {
                        int randomDamage = this.random.nextInt(9) + 1;
                        effect = this.plugin.getLocalization().getString("damage");
                        player.damage((double)randomDamage);
                        break;
                    }
                    case 1: {
                        effect = this.plugin.getLocalization().getString("death");
                        this.decreaseItem(player, mainHand);
                        player.setHealth(0.0);
                        break;
                    }
                    case 2: {
                        effect = this.plugin.getLocalization().getString("venom");
                        player.addPotionEffect(new PotionEffect(PotionEffectType.POISON, randomEffectTime, effectStrength));
                        break;
                    }
                    case 3: {
                        effect = this.plugin.getLocalization().getString("hungervenom");
                        player.addPotionEffect(new PotionEffect(PotionEffectType.HUNGER, randomEffectTime, effectStrength));
                        break;
                    }
                    case 4: {
                        int currentFoodLevel = player.getFoodLevel();
                        int randomFoodLevel = 0;
                        if (currentFoodLevel != 0) {
                            randomFoodLevel = this.random.nextInt(currentFoodLevel);
                        }
                        effect = this.plugin.getLocalization().getString("hungerdecrease");
                        player.setFoodLevel(randomFoodLevel);
                        break;
                    }
                    case 5: {
                        effect = this.plugin.getLocalization().getString("confusion");
                        player.addPotionEffect(new PotionEffect(PotionEffectType.CONFUSION, randomEffectTime, effectStrength));
                        break;
                    }
                    case 6: {
                        effect = this.plugin.getLocalization().getString("blindness");
                        player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, randomEffectTime, effectStrength));
                        break;
                    }
                    case 7: {
                        effect = this.plugin.getLocalization().getString("weakness");
                        player.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, randomEffectTime, effectStrength));
                        break;
                    }
                    case 8: {
                        effect = this.plugin.getLocalization().getString("slowness");
                        player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, randomEffectTime, effectStrength));
                        break;
                    }
                    case 9: {
                        effect = this.plugin.getLocalization().getString("slowness_blocks");
                        player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_DIGGING, randomEffectTime, effectStrength));
                        break;
                    }
                    case 10: {
                        effect = this.plugin.getLocalization().getString("instant_damage");
                        player.addPotionEffect(new PotionEffect(PotionEffectType.HARM, randomEffectTime, effectStrength));
                        break;
                    }
                    case 11: {
                        effect = this.plugin.getLocalization().getString("refusing");
                        event.setCancelled(true);
                        break;
                    }
                    case 12: {
                        effect = this.plugin.getLocalization().getString("wither");
                        player.addPotionEffect(new PotionEffect(PotionEffectType.WITHER, randomEffectTime, effectStrength));
                        break;
                    }
                    case 13: {
                        effect = this.plugin.getLocalization().getString("levitation");
                        player.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, randomEffectTime, effectStrength));
                        break;
                    }
                    case 14: {
                        effect = this.plugin.getLocalization().getString("unluck");
                        player.addPotionEffect(new PotionEffect(PotionEffectType.UNLUCK, randomEffectTime, effectStrength));
                        break;
                    }
                    case 15: {
                        effect = this.plugin.getLocalization().getString("bad_omen");
                        player.addPotionEffect(new PotionEffect(PotionEffectType.BAD_OMEN, randomEffectTime, effectStrength));
                    }
                }
                this.message(player, effect);
                if (this.plugin.getCooldown() != 0) {
                    this.plugin.getCooldownManager().addPlayer(player);
                }
                event.setCancelled(true);
                if (effectNumber != 11 && effectNumber != 1) {
                    this.decreaseItem(player, mainHand);
                }
            }
        } else if (this.plugin.isPreventVanillaPoison() && ((item = event.getItem()).getType() == Material.CHICKEN || item.getType() == Material.ROTTEN_FLESH)) {
            int foodLevel = player.getFoodLevel();
            if (item.getType() == Material.CHICKEN) {
                foodLevel += 2;
            } else if (item.getType() == Material.ROTTEN_FLESH) {
                foodLevel += 4;
            }
            if (foodLevel > 20) {
                foodLevel = 20;
            }
            player.setFoodLevel(foodLevel);
            this.decreaseItem(player, mainHand);
            event.setCancelled(true);
        }
    }

    private void message(Player player, String messageToSend) {
        if (this.plugin.isMessages()) {
            this.plugin.message(null, player, messageToSend, null, null);
        }
    }

    private boolean sameItem(Material item) {
        for (String itemName : this.plugin.getItemList()) {
            Material mat = Material.matchMaterial((String)itemName);
            if (mat == null) {
                if (!this.message) continue;
                this.plugin.getLogger().warning("Couldn't load the foods! Please check your config!");
                this.plugin.getLogger().warning("The following item ID/name is invalid: " + itemName);
                this.message = false;
                continue;
            }
            if (mat != item) continue;
            return true;
        }
        return false;
    }

    private void decreaseItem(Player player, boolean mainHand) {
        ItemStack afterEating = null;
        afterEating = mainHand ? player.getInventory().getItemInMainHand() : player.getInventory().getItemInOffHand();
        if (afterEating.getAmount() == 1) {
            if (mainHand) {
                player.getInventory().setItemInMainHand(null);
            } else {
                player.getInventory().setItemInOffHand(null);
            }
        } else {
            afterEating.setAmount(afterEating.getAmount() - 1);
            if (mainHand) {
                player.getInventory().setItemInMainHand(afterEating);
            } else {
                player.getInventory().setItemInOffHand(afterEating);
            }
        }
    }
}

