/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.cookme;

import de.dustplanet.cookme.CookMe;
import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;

public class CookMeCommands
implements CommandExecutor {
    private CookMe plugin;

    public CookMeCommands(CookMe instance) {
        this.plugin = instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            if (sender.hasPermission("cookme.reload") || !this.plugin.isPermissions()) {
                this.cookMeReload(sender);
                return true;
            } else {
                String message = this.plugin.getLocalization().getString("permission_denied");
                this.plugin.message(sender, null, message, null, null);
            }
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("help")) {
            if (sender.hasPermission("cookme.help") || !this.plugin.isPermissions()) {
                this.cookMeHelp(sender);
                return true;
            } else {
                String message = this.plugin.getLocalization().getString("permission_denied");
                this.plugin.message(sender, null, message, null, null);
            }
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("debug") && this.plugin.isDebug()) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                player.setFoodLevel(10);
                player.setHealth(player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
                for (PotionEffect effect : player.getActivePotionEffects()) {
                    player.removePotionEffect(effect.getType());
                }
                player.sendMessage(ChatColor.GREEN + "Food level reduced!");
                return true;
            } else {
                sender.sendMessage(ChatColor.RED + "Please use debug mode ingame!");
            }
            return true;
        }
        if (args.length > 1 && args[0].equalsIgnoreCase("set")) {
            if (args[1].equalsIgnoreCase("cooldown")) {
                if (sender.hasPermission("cookme.cooldown") || !this.plugin.isPermissions()) {
                    if (args.length <= 2) return true;
                    int cooldown = 0;
                    try {
                        cooldown = Integer.parseInt(args[2]);
                    }
                    catch (NumberFormatException e) {
                        String message = this.plugin.getLocalization().getString("no_number");
                        this.plugin.message(sender, null, message, null, null);
                        return true;
                    }
                    this.plugin.getConfig().set("configuration.cooldown", (Object)cooldown);
                    this.plugin.saveConfig();
                    String message = this.plugin.getLocalization().getString("changed_cooldown");
                    this.plugin.message(sender, null, message, Integer.toString(cooldown), null);
                    this.plugin.getCooldownManager().setCooldown(cooldown);
                    this.plugin.setCooldown(cooldown);
                    return true;
                }
                String message = this.plugin.getLocalization().getString("permission_denied");
                this.plugin.message(sender, null, message, null, null);
                return true;
            }
            if (args[1].equalsIgnoreCase("duration") && args.length > 2) {
                if (sender.hasPermission("cookme.duration") || !this.plugin.isPermissions()) {
                    if (!args[2].equalsIgnoreCase("max") && !args[2].equalsIgnoreCase("min")) return false;
                    if (args.length <= 3) return true;
                    int duration = 0;
                    try {
                        duration = Integer.parseInt(args[3]);
                    }
                    catch (NumberFormatException e) {
                        String message = this.plugin.getLocalization().getString("no_number");
                        this.plugin.message(sender, null, message, null, null);
                        return true;
                    }
                    this.plugin.getConfig().set("configuration.duration." + args[2].toLowerCase(), (Object)duration);
                    this.plugin.saveConfig();
                    String message = this.plugin.getLocalization().getString("changed_duration_" + args[2].toLowerCase());
                    this.plugin.message(sender, null, message, Integer.toString(duration), null);
                    if (args[2].equalsIgnoreCase("max")) {
                        this.plugin.setMaxDuration(duration);
                        return true;
                    } else {
                        this.plugin.setMinDuration(duration);
                    }
                    return true;
                }
                String message = this.plugin.getLocalization().getString("permission_denied");
                this.plugin.message(sender, null, message, null, null);
                return true;
            }
            if (!Arrays.asList(this.plugin.getEffects()).contains(args[1].toLowerCase())) return false;
            String effect = args[1].toLowerCase();
            if (args.length <= 2) return false;
            if (sender.hasPermission("cookme.set." + effect) || !this.plugin.isPermissions()) {
                double percentage = 0.0;
                try {
                    percentage = Double.valueOf(args[2]);
                }
                catch (NumberFormatException e) {
                    String message = this.plugin.getLocalization().getString("no_number");
                    this.plugin.message(sender, null, message, null, null);
                    return true;
                }
                this.plugin.getConfig().set("effects." + effect, (Object)percentage);
                this.plugin.saveConfig();
                String message = this.plugin.getLocalization().getString("changed_effect");
                this.plugin.message(sender, null, message, effect, Double.toString(percentage));
                this.plugin.getPercentages()[Arrays.asList(this.plugin.getEffects()).indexOf((Object)effect)] = percentage;
                return true;
            }
            String message = this.plugin.getLocalization().getString("permission_denied");
            this.plugin.message(sender, null, message, null, null);
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("enable")) {
            if (args.length > 1 && args[1].equalsIgnoreCase("permissions")) {
                if (sender.hasPermission("cookme.enable.permissions") || !this.plugin.isPermissions()) {
                    this.cookMeEnablePermissions(sender);
                    return true;
                } else {
                    String message = this.plugin.getLocalization().getString("permission_denied");
                    this.plugin.message(sender, null, message, null, null);
                }
                return true;
            }
            if (args.length <= 1 || !args[1].equalsIgnoreCase("messages")) return false;
            if (sender.hasPermission("cookme.enable.messages") || !this.plugin.isPermissions()) {
                this.cookMeEnableMessages(sender);
                return true;
            } else {
                String message = this.plugin.getLocalization().getString("permission_denied");
                this.plugin.message(sender, null, message, null, null);
            }
            return true;
        }
        if (args.length <= 0 || !args[0].equalsIgnoreCase("disable")) return false;
        if (args.length > 1 && args[1].equalsIgnoreCase("permissions")) {
            if (sender.hasPermission("cookme.disable.permissions") || !this.plugin.isPermissions()) {
                this.cookMeDisablePermissions(sender);
                return true;
            } else {
                String message = this.plugin.getLocalization().getString("permission_denied");
                this.plugin.message(sender, null, message, null, null);
            }
            return true;
        }
        if (args.length <= 1 || !args[1].equalsIgnoreCase("messages")) return false;
        if (sender.hasPermission("cookme.disable.messages") || !this.plugin.isPermissions()) {
            this.cookMeDisableMessages(sender);
            return true;
        } else {
            String message = this.plugin.getLocalization().getString("permission_denied");
            this.plugin.message(sender, null, message, null, null);
        }
        return true;
    }

    private void cookMeHelp(CommandSender sender) {
        String message = this.plugin.getLocalization().getString("help");
        this.plugin.message(sender, null, message, null, null);
    }

    private void cookMeReload(CommandSender sender) {
        this.plugin.loadConfigsAgain();
        String message = this.plugin.getLocalization().getString("reload");
        this.plugin.message(sender, null, message, null, null);
    }

    private void cookMeEnablePermissions(CommandSender sender) {
        this.plugin.getConfig().set("configuration.permissions", (Object)true);
        this.plugin.saveConfig();
        String message = this.plugin.getLocalization().getString("enable_permissions");
        this.plugin.message(sender, null, message, null, null);
        this.plugin.setPermissions(true);
    }

    private void cookMeDisablePermissions(CommandSender sender) {
        this.plugin.getConfig().set("configuration.permissions", (Object)false);
        this.plugin.saveConfig();
        String message = this.plugin.getLocalization().getString("disable_permissions");
        this.plugin.message(sender, null, message, null, null);
        this.plugin.setPermissions(false);
    }

    private void cookMeEnableMessages(CommandSender sender) {
        this.plugin.getConfig().set("configuration.messages", (Object)true);
        this.plugin.saveConfig();
        String message = this.plugin.getLocalization().getString("enable_messages");
        this.plugin.message(sender, null, message, null, null);
        this.plugin.setMessages(true);
    }

    private void cookMeDisableMessages(CommandSender sender) {
        this.plugin.getConfig().set("configuration.messages", (Object)false);
        this.plugin.saveConfig();
        String message = this.plugin.getLocalization().getString("disable_messages");
        this.plugin.message(sender, null, message, null, null);
        this.plugin.setMessages(false);
    }
}

