/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.cookme;

import de.dustplanet.cookme.CookMeCommands;
import de.dustplanet.cookme.CookMePlayerListener;
import de.dustplanet.cookme.CooldownManager;
import de.dustplanet.cookme.Metrics;
import de.dustplanet.cookme.ScalarYamlConfiguration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class CookMe
extends JavaPlugin {
    private CooldownManager cooldownManager;
    private FileConfiguration config;
    private FileConfiguration localization;
    private File configFile;
    private File localizationFile;
    private List<String> itemList = new ArrayList<String>();
    private int cooldown;
    private int minDuration;
    private int maxDuration;
    private boolean debug;
    private boolean messages;
    private boolean permissions;
    private boolean preventVanillaPoison;
    private boolean randomEffectStrength;
    private String[] rawFood = new String[]{"BEEF", "CHICKEN", "PORKCHOP", "ROTTEN_FLESH", "MUTTON", "RABBIT", "COD", "SALMON", "PUFFERFISH"};
    private String[] effects = new String[]{"damage", "death", "venom", "hungervenom", "hungerdecrease", "confusion", "blindness", "weakness", "slowness", "slowness_blocks", "instant_damage", "refusing", "wither", "levitation", "unluck", "bad_omen"};
    private double[] percentages = new double[this.effects.length];
    private int[] effectStrengths = new int[this.effects.length];
    private static final int BSTATS_PLUGIN_ID = 279;
    private static final double EFFECT_PERCENTAGE = 6.25;
    private static final int SECOND_IN_MILLIS = 20;

    public void onDisable() {
        this.getItemList().clear();
        this.getCooldownManager().clearCooldownList();
    }

    public void onEnable() {
        CookMePlayerListener playerListener = new CookMePlayerListener(this);
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)playerListener, (Plugin)this);
        this.configFile = new File(this.getDataFolder(), "config.yml");
        if (!this.configFile.exists()) {
            if (this.getDataFolder().mkdirs()) {
                this.copy("config.yml", this.configFile);
            } else {
                this.getLogger().severe("The config folder could NOT be created, make sure it's writable!");
                this.getLogger().severe("Disabling now!");
                this.setEnabled(false);
                return;
            }
        }
        this.config = this.getConfig();
        this.loadConfig();
        this.checkStuff();
        this.setCooldownManager(new CooldownManager(this.getCooldown()));
        this.localizationFile = new File(this.getDataFolder(), "localization.yml");
        if (!this.localizationFile.exists()) {
            this.copy("localization.yml", this.localizationFile);
        }
        this.localization = ScalarYamlConfiguration.loadConfiguration(this.localizationFile);
        this.loadLocalization();
        this.getCommand("cookme").setExecutor((CommandExecutor)new CookMeCommands(this));
        Metrics metrics = new Metrics((Plugin)this, 279);
        metrics.addCustomChart(new Metrics.AdvancedPie("percentage_of_affected_items", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                for (String itemName : CookMe.this.getItemList()) {
                    valueMap.put(itemName, 1);
                }
                return valueMap;
            }
        }));
    }

    private void checkStuff() {
        this.setPermissions(this.config.getBoolean("configuration.permissions", true));
        this.setMessages(this.config.getBoolean("configuration.messages", true));
        this.setCooldown(this.config.getInt("configuration.cooldown", 30));
        this.setMinDuration(20 * this.config.getInt("configuration.duration.min", 15));
        this.setMaxDuration(20 * this.config.getInt("configuration.duration.max", 30));
        this.setItemList(this.config.getStringList("food"));
        this.setDebug(this.config.getBoolean("configuration.debug", false));
        this.setPreventVanillaPoison(this.config.getBoolean("configuration.preventVanillaPoison", false));
        this.setRandomEffectStrength(this.config.getBoolean("configuration.randomEffectStrength", true));
        int i = 0;
        double temp = 0.0;
        for (i = 0; i < this.getEffects().length; ++i) {
            this.percentages[i] = this.config.getDouble("effects." + this.getEffects()[i]);
            temp += this.percentages[i];
        }
        if ((double)Math.round(temp) * 100.0 / 100.0 > 100.0) {
            for (i = 0; i < this.getPercentages().length; ++i) {
                this.percentages[i] = 6.25;
                this.config.set("effects." + this.getEffects()[i], (Object)6.25);
            }
            this.getLogger().warning("Detected that the entire procentage is higer than 100. Resetting to default...");
            this.saveConfig();
        }
        if (!this.isRandomEffectStrength()) {
            for (i = 0; i < this.getEffects().length; ++i) {
                this.getEffectStrengths()[i] = this.config.getInt("effectStrength." + this.getEffects()[i], 0);
            }
        }
    }

    private void loadConfig() {
        this.config.options().header("For help please refer to https://dev.bukkit.org/projects/cookme/");
        this.config.addDefault("configuration.permissions", (Object)true);
        this.config.addDefault("configuration.messages", (Object)true);
        this.config.addDefault("configuration.duration.min", (Object)15);
        this.config.addDefault("configuration.duration.max", (Object)30);
        this.config.addDefault("configuration.cooldown", (Object)30);
        this.config.addDefault("configuration.debug", (Object)false);
        this.config.addDefault("configuration.preventVanillaPoison", (Object)false);
        this.config.addDefault("configuration.randomEffectStrength", (Object)true);
        this.config.addDefault("effects.damage", (Object)6.25);
        this.config.addDefault("effects.death", (Object)6.25);
        this.config.addDefault("effects.venom", (Object)6.25);
        this.config.addDefault("effects.hungervenom", (Object)6.25);
        this.config.addDefault("effects.hungerdecrease", (Object)6.25);
        this.config.addDefault("effects.confusion", (Object)6.25);
        this.config.addDefault("effects.blindness", (Object)6.25);
        this.config.addDefault("effects.weakness", (Object)6.25);
        this.config.addDefault("effects.slowness", (Object)6.25);
        this.config.addDefault("effects.slowness_blocks", (Object)6.25);
        this.config.addDefault("effects.instant_damage", (Object)6.25);
        this.config.addDefault("effects.refusing", (Object)6.25);
        this.config.addDefault("effects.wither", (Object)6.25);
        this.config.addDefault("effects.levitation", (Object)6.25);
        this.config.addDefault("effects.unluck", (Object)6.25);
        this.config.addDefault("effects.bad_omen", (Object)6.25);
        this.config.addDefault("effectStrength.venom", (Object)8);
        this.config.addDefault("effectStrength.hungervenom", (Object)8);
        this.config.addDefault("effectStrength.confusion", (Object)8);
        this.config.addDefault("effectStrength.blindness", (Object)8);
        this.config.addDefault("effectStrength.weakness", (Object)8);
        this.config.addDefault("effectStrength.slowness", (Object)8);
        this.config.addDefault("effectStrength.slowness_blocks", (Object)8);
        this.config.addDefault("effectStrength.instant_damage", (Object)8);
        this.config.addDefault("effectStrength.wither", (Object)8);
        this.config.addDefault("effectStrength.levitation", (Object)8);
        this.config.addDefault("effectStrength.unluck", (Object)8);
        this.config.addDefault("food", Arrays.asList(this.rawFood));
        this.config.options().copyDefaults(true);
        this.saveConfig();
    }

    private void loadLocalization() {
        this.getLocalization().addDefault("damage", (Object)"&4You got some random damage! Eat some cooked food!");
        this.getLocalization().addDefault("hungervenom", (Object)"&4Your foodbar is a random time venomed! Eat some cooked food!");
        this.getLocalization().addDefault("death", (Object)"&4The raw food killed you! :(");
        this.getLocalization().addDefault("venom", (Object)"&4You are for a random time venomed! Eat some cooked food!");
        this.getLocalization().addDefault("hungerdecrease", (Object)"&4Your food level went down! Eat some cooked food!");
        this.getLocalization().addDefault("confusion", (Object)"&4You are for a random time confused! Eat some cooked food!");
        this.getLocalization().addDefault("blindness", (Object)"&4You are for a random time blind! Eat some cooked food!");
        this.getLocalization().addDefault("weakness", (Object)"&4You are for a random time weak! Eat some cooked food!");
        this.getLocalization().addDefault("slowness", (Object)"&4You are for a random time slower! Eat some cooked food!");
        this.getLocalization().addDefault("slowness_blocks", (Object)"&4You mine for a random time slower! Eat some cooked food!");
        this.getLocalization().addDefault("instant_damage", (Object)"&4You got some magic damage! Eat some cooked food!");
        this.getLocalization().addDefault("refusing", (Object)"&4You decided to save your life and did not eat this food!");
        this.getLocalization().addDefault("wither", (Object)"&4The poison of the wither weakens you! Eat some cooked food!");
        this.getLocalization().addDefault("levitation", (Object)"&4You fly up high in the air! Eat some cooked food!");
        this.getLocalization().addDefault("unluck", (Object)"&4You are for a random time unlucky! Eat some cooked food!");
        this.getLocalization().addDefault("bad_omen", (Object)"'&4You feel a bad omen! Eat some cooked food!");
        this.getLocalization().addDefault("permission_denied", (Object)"&4You do not have the permission to do this!");
        this.getLocalization().addDefault("enable_messages", (Object)"&2CookMe &4messages &2enabled!");
        this.getLocalization().addDefault("enable_permissions", (Object)"&2CookMe &4permissions &2enabled!\n&2Only OPs and players with the permission can use the plugin!");
        this.getLocalization().addDefault("disable_messages", (Object)"&2CookMe &4messages &2disabled!");
        this.getLocalization().addDefault("disable_permissions", (Object)"&2CookMe &4permissions &4disabled!\n&4All players can use the plugin!");
        this.getLocalization().addDefault("reload", (Object)"&2CookMe &4%version &2reloaded!");
        this.getLocalization().addDefault("changed_effect", (Object)"&2The percentage of the effect &e%effect &4has been changed to &e%percentage%");
        this.getLocalization().addDefault("changed_cooldown", (Object)"&2The cooldown time has been changed to &e%value!");
        this.getLocalization().addDefault("changed_duration_max", (Object)"&2The maximum duration time has been changed to &e%value!");
        this.getLocalization().addDefault("changed_duration_min", (Object)"&2The minimum duration time has been changed to &e%value!");
        this.getLocalization().addDefault("help", (Object)"&2Welcome to the CookMe version &4%version &2help\nTo see the help type &4/cookme help\nYou can enable permissions and messages with &4/cookme enable &e<value> &fand &4/cookme disable &e<value>\nTo reload use &4/cookme reload\nTo change the cooldown or duration values, type\n&4/cookme set cooldown <value>&f, &4/cookme set duration min <value> &for\n&4/cookme set duration max <value>\nSet the percentages with &4/cookme set &e<value> <percentage>\n&eValues: &fpermissions, messages, damage, death, venom,\nhungervenom, hungerdecrease, confusion, blindness, weakness\nslowness, slowness_blocks, instant_damage, refusing, wither, levitation, unluck");
        this.getLocalization().addDefault("no_number", (Object)"&4The given argument was not a number!");
        this.getLocalization().options().copyDefaults(true);
        this.saveLocalization();
    }

    private void saveLocalization() {
        try {
            this.getLocalization().save(this.localizationFile);
        }
        catch (IOException e) {
            this.getLogger().warning("Failed to save the localization! Please report this! IOException");
            e.printStackTrace();
        }
    }

    public void loadConfigsAgain() {
        try {
            this.config.load(this.configFile);
            this.saveConfig();
            this.checkStuff();
            this.getCooldownManager().setCooldown(this.getCooldown());
            this.getLocalization().load(this.localizationFile);
            this.saveLocalization();
        }
        catch (IOException | InvalidConfigurationException e) {
            this.getLogger().warning("Failed to save the localization! Please report this!");
            e.printStackTrace();
        }
    }

    private void copy(String yml, File file) {
        try (FileOutputStream out = new FileOutputStream(file);
             InputStream in = this.getResource(yml);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        catch (IOException e) {
            this.getLogger().warning("Failed to copy the default config! (I/O)");
            e.printStackTrace();
        }
    }

    public void message(CommandSender sender, Player player, String message, String value, String percentage) {
        String tempValue = value == null ? "" : value;
        String tempPercentage = percentage == null ? "" : percentage;
        PluginDescriptionFile pdfFile = this.getDescription();
        String tempMessage = message.replace("%version", pdfFile.getVersion()).replace("%effect", tempValue).replace("%value", tempValue).replace("%percentage", tempPercentage);
        String[] newMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)tempMessage).split("\n");
        if (player != null) {
            player.sendMessage(newMessage);
        } else if (sender != null) {
            sender.sendMessage(newMessage);
        }
    }

    public double[] getPercentages() {
        return (double[])this.percentages.clone();
    }

    public void setPercentages(double[] percentages) {
        this.percentages = (double[])percentages.clone();
    }

    public int[] getEffectStrengths() {
        return (int[])this.effectStrengths.clone();
    }

    public void setEffectStrengths(int[] effectStrengths) {
        this.effectStrengths = (int[])effectStrengths.clone();
    }

    public String[] getEffects() {
        return (String[])this.effects.clone();
    }

    public void setEffects(String[] effects) {
        this.effects = (String[])effects.clone();
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    public void setCooldownManager(CooldownManager cooldownManager) {
        this.cooldownManager = cooldownManager;
    }

    public FileConfiguration getLocalization() {
        return this.localization;
    }

    public List<String> getItemList() {
        return this.itemList;
    }

    public void setItemList(List<String> itemList) {
        this.itemList = itemList;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getMinDuration() {
        return this.minDuration;
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public void setMinDuration(int minDuration) {
        this.minDuration = minDuration;
    }

    public void setMaxDuration(int maxDuration) {
        this.maxDuration = maxDuration;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isMessages() {
        return this.messages;
    }

    public boolean isPermissions() {
        return this.permissions;
    }

    public boolean isPreventVanillaPoison() {
        return this.preventVanillaPoison;
    }

    public boolean isRandomEffectStrength() {
        return this.randomEffectStrength;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setMessages(boolean messages) {
        this.messages = messages;
    }

    public void setPermissions(boolean permissions) {
        this.permissions = permissions;
    }

    public void setPreventVanillaPoison(boolean preventVanillaPoison) {
        this.preventVanillaPoison = preventVanillaPoison;
    }

    public void setRandomEffectStrength(boolean randomEffectStrength) {
        this.randomEffectStrength = randomEffectStrength;
    }
}

