/*
 * Decompiled with CFR 0.152.
 */
package net.frostgames.worldguardevents;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.World;

final class WorldGuardUtils {
    private WorldGuardUtils() {
    }

    @Nullable
    static ProtectedRegion getProtectedRegion(@Nonnull Location location) {
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager manager = container.get(BukkitAdapter.adapt((World)location.getWorld()));
        ProtectedRegion region = null;
        if (manager != null) {
            ApplicableRegionSet fromRegions = manager.getApplicableRegions(BukkitAdapter.asBlockVector((Location)location));
            region = fromRegions.getRegions().stream().max(Comparator.comparing(ProtectedRegion::getPriority)).orElse(null);
        }
        return region;
    }
}

