/*
 * Decompiled with CFR 0.152.
 */
package net.frostgames.worldguardevents;

import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import net.frostgames.worldguardevents.WorldGuardUtils;
import net.frostgames.worldguardevents.events.Reason;
import net.frostgames.worldguardevents.events.RegionEnterEvent;
import net.frostgames.worldguardevents.events.RegionLeaveEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public final class EventFactory
implements Listener {
    private static void move(PlayerMoveEvent e, Reason reason) {
        Player player = e.getPlayer();
        Location from = e.getFrom();
        Location to = e.getTo();
        if (from.getBlockX() != to.getBlockX() || from.getBlockY() != to.getBlockY() || from.getBlockZ() != to.getBlockZ()) {
            ProtectedRegion fromRegion = WorldGuardUtils.getProtectedRegion(from);
            ProtectedRegion toRegion = WorldGuardUtils.getProtectedRegion(to);
            if (fromRegion != null && fromRegion != toRegion) {
                RegionLeaveEvent leaveEvent = new RegionLeaveEvent(player, fromRegion, reason);
                Bukkit.getPluginManager().callEvent((Event)leaveEvent);
                e.setCancelled(leaveEvent.isCancelled());
            }
            if (toRegion != null && toRegion != fromRegion) {
                RegionEnterEvent enterEvent = new RegionEnterEvent(player, toRegion, reason);
                Bukkit.getPluginManager().callEvent((Event)enterEvent);
                e.setCancelled(enterEvent.isCancelled());
            }
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        Player player = e.getPlayer();
        ProtectedRegion region = WorldGuardUtils.getProtectedRegion(player.getLocation());
        if (region != null) {
            RegionLeaveEvent event = new RegionLeaveEvent(player, region, Reason.QUIT);
            Bukkit.getPluginManager().callEvent((Event)event);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        ProtectedRegion region = WorldGuardUtils.getProtectedRegion(player.getLocation());
        if (region != null) {
            RegionEnterEvent event = new RegionEnterEvent(player, region, Reason.JOIN);
            Bukkit.getPluginManager().callEvent((Event)event);
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent e) {
        Player player = e.getEntity();
        ProtectedRegion region = WorldGuardUtils.getProtectedRegion(player.getLocation());
        if (region != null) {
            RegionLeaveEvent event = new RegionLeaveEvent(player, region, Reason.DEATH);
            Bukkit.getPluginManager().callEvent((Event)event);
        }
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent e) {
        Player player = e.getPlayer();
        ProtectedRegion region = WorldGuardUtils.getProtectedRegion(e.getRespawnLocation());
        if (region != null) {
            RegionEnterEvent event = new RegionEnterEvent(player, region, Reason.RESPAWN);
            Bukkit.getPluginManager().callEvent((Event)event);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        EventFactory.move(e, Reason.MOVE);
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent e) {
        EventFactory.move((PlayerMoveEvent)e, Reason.TELEPORT);
    }
}

