/*
 * Decompiled with CFR 0.152.
 */
package me.markiscool.timber;

import java.util.HashSet;
import java.util.Set;
import me.markiscool.timber.XMaterial;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;

public class TreeChecker {
    private Set<Vector> offsets = new HashSet<Vector>();
    private Set<XMaterial> validLogs;
    private Set<Block> treeBlocks;

    public TreeChecker() {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    this.offsets.add(new Vector(x, y, z));
                }
            }
        }
        this.validLogs = new HashSet<XMaterial>(){
            {
                this.add(XMaterial.OAK_LOG);
                this.add(XMaterial.ACACIA_LOG);
                this.add(XMaterial.BIRCH_LOG);
                this.add(XMaterial.DARK_OAK_LOG);
                this.add(XMaterial.JUNGLE_LOG);
                this.add(XMaterial.SPRUCE_LOG);
                this.add(XMaterial.STRIPPED_ACACIA_LOG);
                this.add(XMaterial.STRIPPED_BIRCH_LOG);
                this.add(XMaterial.STRIPPED_JUNGLE_LOG);
                this.add(XMaterial.STRIPPED_OAK_LOG);
            }
        };
        this.treeBlocks = new HashSet<Block>();
    }

    public Set<Block> parseTree(Block startBlock) {
        this.treeBlocks.add(startBlock);
        this.searchTrunk(startBlock);
        if (this.treeBlocks.size() < 3) {
            return null;
        }
        HashSet<Block> trunk = new HashSet<Block>(this.treeBlocks);
        for (Block b : trunk) {
            this.recursiveBranchSearch(b);
        }
        return this.treeBlocks;
    }

    private void searchTrunk(Block block) {
        Block targetBlock = block;
        while (this.isValidType((targetBlock = targetBlock.getRelative(BlockFace.UP)).getType())) {
            this.treeBlocks.add(targetBlock);
        }
    }

    private void recursiveBranchSearch(Block block) {
        for (Vector v : this.offsets) {
            Block targetBlock = block.getRelative(v.getBlockX(), v.getBlockY(), v.getBlockZ());
            if (!this.isValidType(targetBlock.getType()) || this.treeBlocks.contains(targetBlock)) continue;
            this.treeBlocks.add(targetBlock);
            this.recursiveBranchSearch(targetBlock);
        }
    }

    public boolean isValidType(Material material) {
        return this.validLogs.contains((Object)XMaterial.fromString(material.name()));
    }
}

