/*
 * Decompiled with CFR 0.152.
 */
package me.rellynn.plugins.bedrockminer.listeners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.EnumWrappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import me.rellynn.plugins.bedrockminer.BedrockMiner;
import me.rellynn.plugins.bedrockminer.PacketUtils;
import me.rellynn.plugins.bedrockminer.WorldSetting;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public final class PacketListener
extends PacketAdapter {
    private final BedrockMiner plugin;
    private final Map<Player, Integer> players = new HashMap<Player, Integer>();
    Random r = new Random();

    public PacketListener(BedrockMiner plugin) {
        super((Plugin)plugin, new PacketType[]{PacketType.Play.Client.BLOCK_DIG});
        this.plugin = plugin;
    }

    private void stopDigging(BlockPosition position, Player player) {
        if (!this.players.containsKey(player)) {
            return;
        }
        Bukkit.getScheduler().cancelTask(this.players.remove(player).intValue());
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> PacketUtils.broadcastBlockBreakAnimationPacket(position, -1), 1L);
    }

    private void breakBlock(Block block, BlockPosition position, Player player) {
        BlockBreakEvent breakEvt = new BlockBreakEvent(block, player);
        breakEvt.setDropItems(true);
        Bukkit.getPluginManager().callEvent((Event)breakEvt);
        if (breakEvt.isCancelled()) {
            return;
        }
        Material blockType = block.getType();
        FileConfiguration config = this.plugin.getConfig();
        if (breakEvt.isDropItems() && config.getBoolean("break-blocks." + blockType.toString() + ".drop", false)) {
            if (!block.getDrops().isEmpty()) {
                block.breakNaturally(player.getInventory().getItemInMainHand());
            } else {
                block.setType(Material.AIR);
                block.getWorld().dropItemNaturally(block.getLocation(), new ItemStack(blockType, 1));
            }
        }
        int damage = config.getInt("break-blocks." + blockType.toString() + ".durability", 1);
        Map enchants = player.getItemInHand().getEnchantments();
        if (enchants.containsKey(Enchantment.DURABILITY)) {
            int level = (Integer)enchants.get(Enchantment.DURABILITY);
            int unbreaking_reduction = 100 / (level + 1);
            int chance = this.r.nextInt(101);
            if (chance > unbreaking_reduction) {
                damage = 0;
            }
        }
        player.getItemInHand().setDurability((short)(player.getItemInHand().getDurability() + damage));
        if (player.getItemInHand().getDurability() >= player.getItemInHand().getType().getMaxDurability()) {
            player.setItemInHand(null);
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, SoundCategory.PLAYERS, 1.0f, 0.9f);
        }
        player.updateInventory();
        player.playSound(block.getLocation(), Sound.BLOCK_STONE_BREAK, SoundCategory.BLOCKS, 1.0f, 0.8f);
        player.playEffect(block.getLocation(), Effect.STEP_SOUND, (Object)blockType);
        block.setType(Material.AIR);
    }

    public void onPacketReceiving(PacketEvent evt) {
        final Player player = evt.getPlayer();
        if (player == null || !player.isOnline()) {
            return;
        }
        if (player.getGameMode().equals((Object)GameMode.CREATIVE)) {
            return;
        }
        final BlockPosition position = (BlockPosition)evt.getPacket().getBlockPositionModifier().read(0);
        EnumWrappers.PlayerDigType type = (EnumWrappers.PlayerDigType)evt.getPacket().getPlayerDigTypes().read(0);
        switch (type) {
            case ABORT_DESTROY_BLOCK: 
            case STOP_DESTROY_BLOCK: {
                this.stopDigging(position, player);
                break;
            }
            case START_DESTROY_BLOCK: {
                final Location location = position.toLocation(player.getWorld());
                if (!this.isValidWorld(location)) {
                    return;
                }
                if (!location.getWorld().isChunkLoaded(location.getBlockX() >> 4, location.getBlockZ() >> 4)) {
                    return;
                }
                final Material blockType = location.getBlock().getType();
                if (!this.plugin.getConfig().isInt("break-blocks." + blockType.toString() + ".duration")) {
                    return;
                }
                if (!player.hasPermission("bedrockminer.break." + blockType.toString().toLowerCase())) {
                    return;
                }
                this.players.put(player, Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){
                    int ticks = 0;

                    @Override
                    public void run() {
                        int stage;
                        ItemStack inHand = player.getItemInHand();
                        if (!player.isOnline() || !PacketListener.this.plugin.isTool(inHand)) {
                            PacketListener.this.stopDigging(position, player);
                            return;
                        }
                        this.ticks += 5;
                        Block block = location.getBlock();
                        long ticksPerStage = Math.round((double)PacketListener.this.plugin.getConfig().getInt("break-blocks." + block.getType().toString() + ".duration", 300) / Math.pow(1.3, inHand.getEnchantmentLevel(Enchantment.DIG_SPEED)) / 9.0);
                        if (player.hasPotionEffect(PotionEffectType.FAST_DIGGING)) {
                            PotionEffect haste = player.getPotionEffect(PotionEffectType.FAST_DIGGING);
                            assert (haste != null);
                            this.ticks += haste.getAmplifier() + 1;
                        }
                        if (PacketListener.this.plugin.getConfig().isInt("break-blocks." + blockType.toString() + ".duration") && ticksPerStage != 0L && (stage = (int)((long)this.ticks / ticksPerStage)) <= 9) {
                            PacketUtils.broadcastBlockBreakAnimationPacket(position, stage);
                        } else {
                            PacketListener.this.stopDigging(position, player);
                            if (PacketListener.this.plugin.getConfig().isInt("break-blocks." + blockType.toString() + ".duration")) {
                                PacketListener.this.breakBlock(block, position, player);
                            }
                        }
                    }
                }, 0L, 5L));
            }
        }
    }

    private boolean isValidWorld(Location location) {
        boolean isValid = new WorldSetting(location.getWorld().getName(), this.plugin.getConfig().getInt("default-world-settings.min-height", 5), this.plugin.getConfig().getInt("default-world-settings.max-height", 256), this.plugin.getConfig().getBoolean("default-world-settings.enabled", true)).isValidLocation(location).equals((Object)WorldSetting.LocationStatus.ALLOW);
        for (WorldSetting worldSetting : this.plugin.getWorldSettings()) {
            if (worldSetting.isValidLocation(location).equals((Object)WorldSetting.LocationStatus.ALLOW)) {
                return true;
            }
            if (!worldSetting.isValidLocation(location).equals((Object)WorldSetting.LocationStatus.DENY)) continue;
            return false;
        }
        return isValid;
    }
}

