/*
 * Decompiled with CFR 0.152.
 */
package me.rellynn.plugins.bedrockminer.commands;

import me.rellynn.plugins.bedrockminer.BedrockMiner;
import me.rellynn.plugins.bedrockminer.BedrockTool;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BedrockCommand
implements CommandExecutor {
    private final BedrockMiner plugin;

    public BedrockCommand(BedrockMiner plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender commandSender, Command command, String s, String[] args) {
        block11: {
            if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
                this.plugin.reloadPluginConfig();
                commandSender.sendMessage("\u00a7aPlugin reloaded.");
            } else if (args.length == 3) {
                if (args[0].equals("give")) {
                    Player player = Bukkit.getPlayer((String)args[1]);
                    if (player == null || !player.isOnline()) {
                        commandSender.sendMessage("\u00a7cThis player is not online.");
                    } else {
                        try {
                            int tool = Integer.valueOf(args[2]);
                            if (tool >= this.plugin.getTools().size() || tool < 0) {
                                commandSender.sendMessage("\u00a7cInvalid tool id");
                                break block11;
                            }
                            player.getInventory().addItem(new ItemStack[]{this.plugin.getTools().get(tool).getItem()});
                        }
                        catch (NumberFormatException expected) {
                            commandSender.sendMessage("\u00a7cTool id must be a number");
                        }
                    }
                } else {
                    this.sendHelp(commandSender);
                }
            } else {
                this.sendHelp(commandSender);
            }
        }
        return true;
    }

    private void sendHelp(CommandSender commandSender) {
        commandSender.sendMessage("\u00a78[\u00a7cBedrockMiner\u00a78] \u00a7eUse \u00a7c/bedrockminer give <player> <tool-id> \u00a7eto give a bedrock tool.");
        commandSender.sendMessage("\u00a7e");
        commandSender.sendMessage("\u00a7eList of tools:");
        int index = 0;
        for (BedrockTool tool : this.plugin.getTools()) {
            String helpText = "\u00a78[\u00a7c" + index++ + "\u00a78] \u00a7e" + (tool.getName().equals("") ? tool.getMaterial().toString() : tool.getName());
            if (!(commandSender instanceof Player) || !this.plugin.isSpigot()) {
                commandSender.sendMessage(helpText);
                return;
            }
            TextComponent text = new TextComponent(helpText);
            BaseComponent[] hoverText = new BaseComponent[4 + tool.getLore().size() + tool.getEnchants().size()];
            hoverText[0] = new TextComponent("\u00a7cName: \u00a7e" + (tool.getName().equals("") ? "none" : tool.getName()) + "\n");
            hoverText[1] = new TextComponent("\u00a7cMaterial: \u00a7e" + tool.getMaterial().toString() + "\n");
            hoverText[2] = new TextComponent("\u00a7cLore:\n");
            int iLore = 3;
            for (String line : tool.getLore()) {
                hoverText[iLore++] = new TextComponent("\u00a77- \u00a7e" + line + "\n");
            }
            hoverText[iLore++] = new TextComponent("\u00a7cEnchantments:\n");
            for (Enchantment enchantment : tool.getEnchants().keySet()) {
                hoverText[iLore++] = new TextComponent(" \u00a7e" + enchantment.getName() + " " + tool.getEnchants().get(enchantment) + "\n");
            }
            text.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, hoverText));
            ((Player)commandSender).spigot().sendMessage((BaseComponent)text);
        }
    }
}

