/*
 * Decompiled with CFR 0.152.
 */
package me.rellynn.plugins.bedrockminer;

import org.bukkit.Location;

public class WorldSetting {
    private final String worldName;
    private boolean enabled;
    private final int min;
    private final int max;

    public WorldSetting(String worldName, int min, int max, boolean enabled) {
        this.worldName = worldName;
        this.min = min;
        this.max = max;
        this.enabled = enabled;
    }

    public LocationStatus isValidLocation(Location location) {
        if (!location.getWorld().getName().equals(this.worldName)) {
            return LocationStatus.DEFAULT;
        }
        if (!this.enabled) {
            return LocationStatus.DENY;
        }
        if (location.getY() < (double)this.min) {
            return LocationStatus.DENY;
        }
        if (location.getY() > (double)this.max) {
            return LocationStatus.DENY;
        }
        return LocationStatus.ALLOW;
    }

    public static enum LocationStatus {
        ALLOW,
        DENY,
        DEFAULT;

    }
}

