/*
 * Decompiled with CFR 0.152.
 */
package me.rellynn.plugins.bedrockminer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;

public class BedrockTool {
    private final Material material;
    private final String name;
    private final boolean repairable;
    private final List<String> lore;
    private short durability;
    private final Map<Enchantment, Integer> enchants;
    private final int modelData;
    private final List<ItemFlag> flags;

    public BedrockTool(Material material, String name, List<String> lore, Map<Enchantment, Integer> enchants, short durability, boolean repairable, int modelData, List<ItemFlag> flags) {
        if (lore == null) {
            lore = Collections.emptyList();
        }
        if (durability <= 0) {
            durability = material.getMaxDurability();
        }
        name = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
        ArrayList<String> newLore = new ArrayList<String>();
        for (String line : lore) {
            newLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
        }
        this.material = material;
        this.name = name;
        this.lore = newLore;
        this.repairable = repairable;
        this.durability = durability;
        this.enchants = enchants;
        this.modelData = modelData;
        this.flags = flags;
    }

    public boolean matchItem(ItemStack item) {
        if (item.getItemMeta() == null) {
            return false;
        }
        if (!item.getItemMeta().hasCustomModelData()) {
            return false;
        }
        return item.getItemMeta().getCustomModelData() == this.modelData;
    }

    public Material getMaterial() {
        return this.material;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public Map<Enchantment, Integer> getEnchants() {
        return this.enchants;
    }

    public int getModelData() {
        return this.modelData;
    }

    public ItemStack getItem() {
        ItemStack item = new ItemStack(this.material, 1);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(this.name);
        meta.setLore(this.lore);
        this.flags.forEach(xva$0 -> meta.addItemFlags(new ItemFlag[]{xva$0}));
        meta.setCustomModelData(Integer.valueOf(this.modelData));
        this.enchants.forEach((enchant, level) -> meta.addEnchant(enchant, level.intValue(), true));
        if (meta instanceof Repairable && !this.repairable) {
            ((Repairable)meta).setRepairCost(50);
        }
        item.setItemMeta(meta);
        item.setDurability((short)(item.getType().getMaxDurability() - this.durability));
        return item;
    }
}

