/*
 * Decompiled with CFR 0.152.
 */
package me.rellynn.plugins.bedrockminer;

import com.comphenix.protocol.ProtocolLibrary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import me.rellynn.plugins.bedrockminer.BedrockTool;
import me.rellynn.plugins.bedrockminer.WorldSetting;
import me.rellynn.plugins.bedrockminer.commands.BedrockCommand;
import me.rellynn.plugins.bedrockminer.listeners.PacketListener;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class BedrockMiner
extends JavaPlugin {
    private final List<BedrockTool> tools = new ArrayList<BedrockTool>();
    private final List<Material> globalTools = new ArrayList<Material>();
    private final List<WorldSetting> worldSettings = new ArrayList<WorldSetting>();
    private boolean spigot = false;

    public void onEnable() {
        this.saveDefaultConfig();
        this.upgradeConfig();
        this.loadTools();
        this.loadWorldSettings();
        ProtocolLibrary.getProtocolManager().addPacketListener((com.comphenix.protocol.events.PacketListener)new PacketListener(this));
        this.getCommand("bedrockminer").setExecutor((CommandExecutor)new BedrockCommand(this));
        this.spigot = this.getServer().getVersion().contains("Spigot");
    }

    private void loadWorldSettings() {
        ConfigurationSection section = this.getConfig().getConfigurationSection("worlds-settings");
        section.getKeys(false).forEach(world -> {
            String name = world;
            boolean enabled = section.getBoolean(world + ".enabled", true);
            int min = section.getInt(world + ".min-height", 5);
            int max = section.getInt(world + ".max-height", 256);
            this.worldSettings.add(new WorldSetting(name, min, max, enabled));
        });
    }

    public void reloadPluginConfig() {
        this.reloadConfig();
        this.tools.clear();
        this.globalTools.clear();
        this.loadTools();
        this.worldSettings.clear();
        this.loadWorldSettings();
    }

    public void onDisable() {
        ProtocolLibrary.getProtocolManager().removePacketListeners((Plugin)this);
    }

    private void upgradeConfig() {
        if (this.getConfig().getDouble("config") == 1.8) {
            this.getConfig().set("config", (Object)1.9);
            this.getConfig().getConfigurationSection("tool").getKeys(false).forEach(key -> {
                if (this.getConfig().isSet("tool." + key + ".flags")) {
                    return;
                }
                this.getConfig().set("tool." + key + ".flags", Collections.emptyList());
            });
            this.getConfig().set("global-tools", Collections.emptyList());
            this.saveConfig();
        }
    }

    public void loadTools() {
        ConfigurationSection section = this.getConfig().getConfigurationSection("tool");
        section.getKeys(false).forEach(key -> {
            Material material = Material.valueOf((String)section.getString(key + ".tool"));
            String name = section.getString(key + ".name", "");
            List lore = section.getStringList(key + ".lore");
            int durability = section.getInt(key + ".durability", -1);
            boolean repairable = section.getBoolean(key + ".repairable", true);
            HashMap<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
            ArrayList<ItemFlag> flags = new ArrayList<ItemFlag>();
            ConfigurationSection enchantSection = section.getConfigurationSection(key + ".enchantments");
            if (enchantSection != null) {
                enchantSection.getKeys(false).forEach(enchant -> enchants.put(Enchantment.getByName((String)enchant.toUpperCase()), section.getInt(key + ".enchantments." + enchant)));
            }
            section.getStringList(key + ".flags").forEach(flagName -> flags.add(ItemFlag.valueOf((String)flagName.toUpperCase())));
            int modelData = section.getInt(key + ".modelData", 15912153);
            this.tools.add(new BedrockTool(material, name, lore, enchants, (short)durability, repairable, modelData, flags));
        });
        this.getConfig().getStringList("global-tools").forEach(materialName -> this.globalTools.add(Material.valueOf((String)materialName.toUpperCase())));
    }

    public boolean isTool(ItemStack item) {
        if (item == null && this.globalTools.contains(Material.AIR)) {
            return true;
        }
        if (item == null) {
            return false;
        }
        if (this.globalTools.contains(item.getType())) {
            return true;
        }
        for (BedrockTool tool : this.tools) {
            if (!tool.matchItem(item)) continue;
            return true;
        }
        return false;
    }

    public List<BedrockTool> getTools() {
        return new ArrayList<BedrockTool>(this.tools);
    }

    public boolean isSpigot() {
        return this.spigot;
    }

    public List<WorldSetting> getWorldSettings() {
        return this.worldSettings;
    }
}

