/*
 * Decompiled with CFR 0.152.
 */
package ro.deiutzblaxo.Purgatory.Spigot.Events;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.server.TabCompleteEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import ro.deiutzblaxo.Purgatory.Spigot.MainSpigot;

public class JustSpigotEvents
implements Listener {
    private MainSpigot plugin;
    private ArrayList<Player> RespawnArrayList;

    public JustSpigotEvents(MainSpigot main) {
        this.plugin = main;
        this.RespawnArrayList = new ArrayList();
        new BukkitRunnable(){

            public void run() {
                if (JustSpigotEvents.this.RespawnArrayList.isEmpty()) {
                    return;
                }
                try {
                    for (Player player : JustSpigotEvents.this.RespawnArrayList) {
                        player.teleport(JustSpigotEvents.this.plugin.getWorldManager().getPurgatory().getSpawnLocation());
                        JustSpigotEvents.this.RespawnArrayList.remove(player);
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
            }
        }.runTaskTimer((Plugin)main, 0L, 0L);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        if (this.plugin.getBanFactory().isBan(player.getUniqueId())) {
            if (!player.getLocation().getWorld().getName().equalsIgnoreCase(this.plugin.getWorldManager().getPurgatory().getName())) {
                player.teleport(this.plugin.getWorldManager().getPurgatory().getSpawnLocation());
            } else if (this.plugin.getConfig().getBoolean("Force-Spawn-Purgatory-World")) {
                player.teleport(this.plugin.getWorldManager().getPurgatory().getSpawnLocation());
            }
            this.plugin.getScoreBoardAPI().createScoreboard(player, this.plugin.getTaskFactory().getTasks());
            for (PotionEffect p : player.getActivePotionEffects()) {
                if (!p.getType().equals((Object)PotionEffectType.INVISIBILITY)) continue;
                player.removePotionEffect(p.getType());
                player.setAllowFlight(false);
                player.setCanPickupItems(true);
            }
        } else if (this.plugin.getConfig().getBoolean("Force-Spawn-Default-World")) {
            player.teleport(this.plugin.getWorldManager().getPurgatory().getSpawnLocation());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onTeleport(PlayerTeleportEvent e) {
        Player player = e.getPlayer();
        if (this.plugin.getBanFactory().isBan(player.getUniqueId())) {
            if (!e.getTo().getWorld().getName().equals(this.plugin.getWorldManager().getPurgatory().getName())) {
                e.setCancelled(true);
            }
        } else if (e.getTo().getWorld().getName().equals(this.plugin.getWorldManager().getPurgatory().getName())) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1));
            player.setAllowFlight(true);
            player.setCanPickupItems(false);
        } else if (e.getFrom().getWorld().getName().equals(this.plugin.getWorldManager().getPurgatory().getName())) {
            for (PotionEffect effect : player.getActivePotionEffects()) {
                if (!effect.getType().equals((Object)PotionEffectType.INVISIBILITY)) continue;
                player.removePotionEffect(effect.getType());
            }
            player.setAllowFlight(false);
            player.setCanPickupItems(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onDamage(EntityDamageByEntityEvent e) {
        Entity Damager = e.getDamager();
        Entity Damaged = e.getEntity();
        if (this.plugin.getBanFactory().isBan(Damaged.getUniqueId()) && Damager.getType().equals((Object)EntityType.PLAYER)) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onDrop(PlayerDropItemEvent e) {
        if (e.getPlayer().getWorld().getName().equalsIgnoreCase(this.plugin.getWorldManager().getPurgatory().getName()) && !this.plugin.getBanFactory().isBan(e.getPlayer().getUniqueId())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPickUp(PlayerPickupItemEvent e) {
        if (e.getPlayer().getWorld().getName().equalsIgnoreCase(this.plugin.getWorldManager().getPurgatory().getName()) && !this.plugin.getBanFactory().isBan(e.getPlayer().getUniqueId())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onRespawn(PlayerRespawnEvent e) {
        if (this.plugin.getBanFactory().isBan(e.getPlayer().getUniqueId())) {
            this.RespawnArrayList.add(e.getPlayer());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPlace(BlockPlaceEvent e) {
        Player player = e.getPlayer();
        if (player.getLocation().getWorld().getName().equals(this.plugin.getWorldManager().getPurgatory().getName()) && !this.plugin.getBanFactory().isBan(player.getUniqueId())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onBreak(BlockBreakEvent e) {
        Player player = e.getPlayer();
        if (player.getLocation().getWorld().getName().equals(this.plugin.getWorldManager().getPurgatory().getName()) && !this.plugin.getBanFactory().isBan(player.getUniqueId())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onTabCompleter(TabCompleteEvent e) {
        block20: {
            block25: {
                String[] args;
                block24: {
                    block23: {
                        block22: {
                            block21: {
                                args = e.getBuffer().toLowerCase().split(" ");
                                if (args.length < 1 || !args[0].startsWith("/")) break block20;
                                if (!args[0].equalsIgnoreCase("/" + this.plugin.getConfig().getString("Command.Ban").toLowerCase())) break block21;
                                switch (args.length) {
                                    case 1: {
                                        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                                            e.getCompletions().add(player.getName());
                                        }
                                        break block20;
                                    }
                                    default: {
                                        e.getCompletions().clear();
                                        break;
                                    }
                                }
                                break block20;
                            }
                            if (!args[0].equalsIgnoreCase("/" + this.plugin.getConfig().getString("Command.Purge"))) break block22;
                            switch (args.length) {
                                case 1: {
                                    for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                                        e.getCompletions().add(player.getName());
                                    }
                                    break block20;
                                }
                                default: {
                                    e.getCompletions().clear();
                                    break;
                                }
                            }
                            break block20;
                        }
                        if (!args[0].equalsIgnoreCase("/" + this.plugin.getConfig().getString("Command.Info"))) break block23;
                        switch (args.length) {
                            case 1: {
                                for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                                    e.getCompletions().add(player.getName());
                                }
                                break block20;
                            }
                            default: {
                                e.getCompletions().clear();
                                break;
                            }
                        }
                        break block20;
                    }
                    if (!args[0].equalsIgnoreCase("/" + this.plugin.getConfig().getString("Command.TempBan"))) break block24;
                    switch (args.length) {
                        case 1: {
                            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                                e.getCompletions().add(player.getName());
                            }
                            break block20;
                        }
                        default: {
                            e.getCompletions().clear();
                            break;
                        }
                    }
                    break block20;
                }
                if (!args[0].equalsIgnoreCase("/" + this.plugin.getConfig().getString("Command.Warning"))) break block25;
                switch (args.length) {
                    case 1: {
                        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                            e.getCompletions().add(player.getName());
                        }
                        break block20;
                    }
                    default: {
                        e.getCompletions().clear();
                        break;
                    }
                }
                break block20;
            }
            e.getCompletions().clear();
        }
    }
}

