/*
 * Decompiled with CFR 0.152.
 */
package ro.deiutzblaxo.Purgatory.Spigot.Events;

import org.bukkit.GameMode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import ro.deiutzblaxo.Purgatory.Spigot.MainSpigot;

public class JustBungeeEvents
implements Listener {
    private MainSpigot plugin;

    public JustBungeeEvents(MainSpigot main) {
        this.plugin = main;
    }

    @EventHandler(ignoreCancelled=true)
    public void onJoin(PlayerJoinEvent e) {
        final Player player = e.getPlayer();
        new BukkitRunnable(){

            public void run() {
                if (JustBungeeEvents.this.plugin.getBanFactory().isBan(player.getUniqueId())) {
                    JustBungeeEvents.this.plugin.getScoreBoardAPI().createScoreboard(player, JustBungeeEvents.this.plugin.getTaskFactory().getTasks());
                    for (PotionEffect p : player.getActivePotionEffects()) {
                        if (!p.getType().equals((Object)PotionEffectType.INVISIBILITY)) continue;
                        player.removePotionEffect(p.getType());
                    }
                    player.setAllowFlight(false);
                    player.setCanPickupItems(true);
                    player.setGameMode(GameMode.SURVIVAL);
                } else {
                    player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1));
                    player.setAllowFlight(true);
                    player.setCanPickupItems(false);
                    player.setGameMode(GameMode.CREATIVE);
                }
            }
        }.runTaskLater((Plugin)this.plugin, 10L);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onDamage(EntityDamageByEntityEvent e) {
        Entity Damager = e.getDamager();
        Entity Damaged = e.getEntity();
        if (this.plugin.getBanFactory().isBan(Damaged.getUniqueId()) && Damager.getType().equals((Object)EntityType.PLAYER)) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onDrop(PlayerDropItemEvent e) {
        if (!this.plugin.getBanFactory().isBan(e.getPlayer().getUniqueId())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPickUp(EntityPickupItemEvent e) {
        if (e.getEntity() instanceof Player && this.plugin.getBanFactory().isBan(e.getEntity().getUniqueId())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPlace(BlockPlaceEvent e) {
        Player player = e.getPlayer();
        if (!this.plugin.getBanFactory().isBan(player.getUniqueId())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onBreak(BlockBreakEvent e) {
        Player player = e.getPlayer();
        if (!this.plugin.getBanFactory().isBan(player.getUniqueId())) {
            e.setCancelled(true);
        }
    }
}

