/*
 * Decompiled with CFR 0.152.
 */
package ro.deiutzblaxo.Purgatory.Bungee;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import ro.deiutzblaxo.Purgatory.Bungee.MainBungee;

public class ServerManager {
    protected MainBungee plugin;

    protected ServerManager(MainBungee main) {
        this.plugin = main;
        if (this.getPurgatoryServer() == null) {
            this.plugin.getProxy().getConsole().sendMessage((BaseComponent)new TextComponent(ChatColor.GRAY + "[" + ChatColor.GREEN + this.plugin.getDescription().getName() + ChatColor.GRAY + "]" + ChatColor.DARK_RED + "ATTENTION !! Purgatory Server don`t exist , please check your config."));
        }
        if (this.getHubServer() == null) {
            this.plugin.getProxy().getConsole().sendMessage((BaseComponent)new TextComponent(ChatColor.GRAY + "[" + ChatColor.GREEN + this.plugin.getDescription().getName() + ChatColor.GRAY + "]" + ChatColor.DARK_RED + "ATTENTION !! Hub Server don`t exist , please check your config."));
        }
        if (!this.ServerOnline(this.getPurgatoryServer())) {
            this.plugin.getProxy().getConsole().sendMessage((BaseComponent)new TextComponent(ChatColor.GRAY + "[" + ChatColor.GREEN + this.plugin.getDescription().getName() + ChatColor.GRAY + "]" + ChatColor.DARK_RED + "ATTENTION !! Purgatory Server is offline , please open the server!"));
        }
        if (!this.ServerOnline(this.getHubServer())) {
            this.plugin.getProxy().getConsole().sendMessage((BaseComponent)new TextComponent(ChatColor.GRAY + "[" + ChatColor.GREEN + this.plugin.getDescription().getName() + ChatColor.GRAY + "]" + ChatColor.DARK_RED + "ATTENTION !! Hub Server is offline , please open the server!"));
        }
    }

    public boolean CheckServer(String server) {
        return this.plugin.getProxy().getServerInfo(server) != null;
    }

    public ServerInfo getPurgatoryServer() {
        if (this.CheckServer(this.plugin.getConfigManager().getConfig().getString("Purgatory-Server"))) {
            return this.plugin.getProxy().getServerInfo(this.plugin.getConfigManager().getConfig().getString("Purgatory-Server"));
        }
        return null;
    }

    public ServerInfo getHubServer() {
        if (this.CheckServer(this.plugin.getConfigManager().getConfig().getString("Hub-Server"))) {
            return this.plugin.getProxy().getServerInfo(this.plugin.getConfigManager().getConfig().getString("Hub-Server"));
        }
        return null;
    }

    public boolean ServerOnline(ServerInfo server) {
        if (server == this.getPurgatoryServer()) {
            try {
                Socket s = new Socket(server.getAddress().getHostString(), server.getAddress().getPort());
                s.close();
                return true;
            }
            catch (UnknownHostException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        if (server == this.getHubServer()) {
            try {
                Socket s = new Socket(server.getAddress().getHostString(), server.getAddress().getPort());
                s.close();
                return true;
            }
            catch (UnknownHostException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return false;
    }
}

