/*
 * Decompiled with CFR 0.152.
 */
package ro.deiutzblaxo.Purgatory.Bungee;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;
import ro.deiutzblaxo.Purgatory.Bungee.MainBungee;

public class ConfigManager {
    private MainBungee plugin;
    private File configfile;
    private File messagesfile;
    private File BanDataBasefile;
    private File WarningDataBasefile;
    private File PluginFolder;
    private File DatabaseFolder;
    private Configuration messages;
    private Configuration config;
    private Configuration ban;
    private Configuration warning;

    public ConfigManager(MainBungee main) {
        this.plugin = main;
        this.createConfigs();
    }

    public void createConfigs() {
        this.plugin.getProxy().getConsole().sendMessage((BaseComponent)new TextComponent("[" + this.plugin.getDescription().getName() + "] " + "Working at configs"));
        this.PluginFolder = this.plugin.getDataFolder();
        if (!this.PluginFolder.exists()) {
            this.PluginFolder.mkdirs();
        }
        this.configfile = new File(this.PluginFolder, "config.yml");
        if (!this.configfile.exists()) {
            try {
                this.plugin.getProxy().getConsole().sendMessage((BaseComponent)new TextComponent("[" + this.plugin.getDescription().getName() + "] " + "config.yml created."));
                this.configfile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getProxy().getConsole().sendMessage((BaseComponent)new TextComponent("[" + this.plugin.getDescription().getName() + "] " + "config.yml can`t be created , please contact the developer!"));
                e.printStackTrace();
            }
        }
        this.messagesfile = new File(this.PluginFolder, "messages.yml");
        if (!this.messagesfile.exists()) {
            try {
                this.messagesfile.createNewFile();
                this.plugin.getProxy().getConsole().sendMessage((BaseComponent)new TextComponent("[" + this.plugin.getDescription().getName() + "] " + "messages.yml created."));
            }
            catch (IOException e) {
                this.plugin.getProxy().getConsole().sendMessage((BaseComponent)new TextComponent("[" + this.plugin.getDescription().getName() + "] " + "messages.yml can`t be created , please contact the developer!"));
                e.printStackTrace();
            }
        }
        this.DatabaseFolder = new File(this.PluginFolder, "/BaseDataYML/");
        if (!this.DatabaseFolder.exists()) {
            this.DatabaseFolder.mkdir();
        }
        this.BanDataBasefile = new File(this.DatabaseFolder, "BanDataBase.yml");
        if (!this.BanDataBasefile.exists()) {
            try {
                this.BanDataBasefile.createNewFile();
                this.plugin.getProxy().getConsole().sendMessage((BaseComponent)new TextComponent("[" + this.plugin.getDescription().getName() + "] " + "BanDataBase.yml created."));
            }
            catch (IOException e) {
                this.plugin.getProxy().getConsole().sendMessage((BaseComponent)new TextComponent("[" + this.plugin.getDescription().getName() + "] " + "BanDataBase.yml can`t be created , please contact the developer!"));
                e.printStackTrace();
            }
        }
        this.WarningDataBasefile = new File(this.DatabaseFolder, "WarningDataBase.yml");
        if (!this.WarningDataBasefile.exists()) {
            try {
                this.WarningDataBasefile.createNewFile();
                this.plugin.getProxy().getConsole().sendMessage((BaseComponent)new TextComponent("[" + this.plugin.getDescription().getName() + "] " + "WarningDataBase.yml created."));
            }
            catch (IOException e) {
                this.plugin.getProxy().getConsole().sendMessage((BaseComponent)new TextComponent("[" + this.plugin.getDescription().getName() + "] " + "WarningDataBase.yml can`t be created , please contact the developer!"));
                e.printStackTrace();
            }
        }
        this.loadConfig();
        this.set(this.config, "Purgatory-Server", "purgatory");
        this.set(this.config, "Hub-Server", "hub");
        this.set(this.config, "Remove-Warnings-On-Ban", true);
        this.set(this.config, "Command.Ban", "Ban");
        this.set(this.config, "Command.TempBan", "tempban");
        this.set(this.config, "Command.UnBan", "purge");
        this.set(this.config, "Command.Info", "info");
        this.set(this.config, "Command.Warning", "warning");
        this.set(this.config, "Command.tpp", "tpp");
        this.set(this.config, "Ban-Disconnect", false);
        this.set(this.config, "UnBan-Disconnect", false);
        this.set(this.config, "MaxWarnings", 5);
        this.saveConfig();
        this.loadMessages();
        this.set(this.messages, "NoPermission", "&4You don`t have permission!");
        this.set(this.messages, "Ban.isBan", "&4%player% is aleardy banned!");
        this.set(this.messages, "Ban.DefaultReason", "This is a default reason for ban");
        this.set(this.messages, "Ban.Format", "&4&bYou have been banned!%newline% &4Reason:&r %reason%");
        this.set(this.messages, "Ban.Broadcast", "&e%player% have been banned by %admin% because &e%reason%");
        this.set(this.messages, "PlayerOffline", "This player is offline!");
        this.set(this.messages, "UnBanFormat", "You have been unbanned by %admin%!");
        this.set(this.messages, "TempBan.DefaultReason", "This is a default reason for ban");
        this.set(this.messages, "TempBan.NotNumber", "%time% this is not a number!");
        this.set(this.messages, "TempBan.TempBanned", "%player% has been banned for %time% because %reason%");
        this.set(this.messages, "Purge.notBanned", "&4%player% is not aleardy banned!");
        this.set(this.messages, "Purge.Broadcast", "&e%player% has been purge by %admin%!");
        this.set(this.messages, "TasksCompleted", "Tasks Completed");
        this.set(this.messages, "TempBanExpired", "expire your tempban");
        this.set(this.messages, "InvalidCommand.Usage", "&eUsage : &a");
        this.set(this.messages, "InvalidCommand.Command", "This is the command!");
        this.set(this.messages, "InvalidCommand.Player", "Write the name of an online player");
        this.set(this.messages, "InvalidCommand.Reason", "You can write a reason if you choose to do so");
        this.set(this.messages, "InvalidCommand.Time", "This needs to be a number of seconds");
        this.set(this.messages, "Info.Format", "&4%player%'s Info%newline%&4Is banned: %isban% %newline%&4Reason: %reason% %newline%&4Warnings: %warnings%");
        this.set(this.messages, "Warning.isBanned", "&4%player% is aleardy banned!");
        this.set(this.messages, "Warning.Receive", "&4You have been warned(%warning%/%warning_max%) by %admin% because : %reason%");
        this.set(this.messages, "Warning.Send", "&4You warned %player% because : %reason%");
        this.set(this.messages, "Warning.broadcast", "&7[&aPurgatory&7]%admin% warned %player% for the reason : %reason%");
        this.set(this.messages, "Warning.DefaultReason", "This is a default reason for warnings");
        this.set(this.messages, "Yes", "yes");
        this.set(this.messages, "No", "no");
        this.saveMessages();
        this.loadMessages();
        this.loadConfig();
    }

    public Configuration getBans() {
        return this.ban;
    }

    public Configuration getMessages() {
        return this.messages;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public Configuration getWarnings() {
        return this.warning;
    }

    public void loadBans() {
        try {
            this.ban = ConfigurationProvider.getProvider(YamlConfiguration.class).load(this.BanDataBasefile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadMessages() {
        try {
            this.messages = ConfigurationProvider.getProvider(YamlConfiguration.class).load(this.messagesfile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadConfig() {
        try {
            this.config = ConfigurationProvider.getProvider(YamlConfiguration.class).load(this.configfile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadWarnings() {
        try {
            this.warning = ConfigurationProvider.getProvider(YamlConfiguration.class).load(this.WarningDataBasefile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveBans() {
        try {
            ConfigurationProvider.getProvider(YamlConfiguration.class).save(this.ban, this.BanDataBasefile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveWarnings() {
        try {
            ConfigurationProvider.getProvider(YamlConfiguration.class).save(this.warning, this.WarningDataBasefile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveConfig() {
        try {
            ConfigurationProvider.getProvider(YamlConfiguration.class).save(this.config, this.configfile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveMessages() {
        try {
            ConfigurationProvider.getProvider(YamlConfiguration.class).save(this.messages, this.messagesfile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void set(Configuration configuration, String path, Object value) {
        if (!configuration.contains(path)) {
            configuration.set(path, value);
        }
    }

    public String getString(Configuration configuration, String path) {
        return configuration.getString(path).replaceAll("%newline%", "\n");
    }

    public void saveTempBan() {
        if (this.plugin.getBanFactory().getTempBan().isEmpty()) {
            return;
        }
        this.loadBans();
        for (UUID uuid : this.plugin.getBanFactory().getTempBan().keySet()) {
            this.getBans().set(uuid + ".Time", (Object)this.plugin.getBanFactory().getTempBan().get(uuid));
        }
        this.saveBans();
    }

    public void loadTempBan() {
        this.loadBans();
        for (String str : this.getBans().getKeys()) {
            if (!this.plugin.getConfigManager().getBans().contains(String.valueOf(str) + ".Time")) continue;
            this.plugin.getBanFactory().getTempBan().put(UUID.fromString(str), this.plugin.getConfigManager().getBans().getInt(String.valueOf(str) + ".Time"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeFile(File file, String ... lines) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            FileWriter fileWriter = new FileWriter(file);
            try {
                try (BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
                    String[] stringArray = lines;
                    int n = lines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        bufferedWriter.write(line);
                        bufferedWriter.newLine();
                        ++n2;
                    }
                }
                if (fileWriter == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fileWriter == null) throw throwable;
                fileWriter.close();
                throw throwable;
            }
            fileWriter.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void loadConfigFromMetrics() throws IOException {
        Path configPath = this.plugin.getDataFolder().toPath().getParent().resolve("bStats");
        configPath.toFile().mkdirs();
        File configFile = new File(configPath.toFile(), "config.yml");
        if (!configFile.exists()) {
            this.writeFile(configFile, "#bStats collects some data for plugin authors like how many servers are using their plugins.", "#To honor their work, you should not disable it.", "#This has nearly no effect on the server performance!", "#Check out https://bStats.org/ to learn more :)", "enabled: true", "serverUuid: \"" + UUID.randomUUID().toString() + "\"", "logFailedRequests: false", "logSentData: false", "logResponseStatusText: false");
        }
        Configuration configuration = ConfigurationProvider.getProvider(YamlConfiguration.class).load(configFile);
    }
}

