/*
 * Decompiled with CFR 0.152.
 */
package support.protocol.accountslink.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Logger;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.plugin.Plugin;
import support.protocol.accountslink.AccountsLink;
import support.protocol.accountslink.database.ConnectionPoolManager;

public class Database {
    private final AccountsLink plugin;
    private final ConnectionPoolManager pool;
    private final Logger LOG;

    public Database(AccountsLink plugin) {
        this.plugin = plugin;
        this.pool = new ConnectionPoolManager(plugin);
        plugin.LOG.info(ChatColor.GREEN + "Successfully connected to Database.");
        this.LOG = plugin.LOG;
        this.setupTables();
        this.makeInitialCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean isLinked(String uuid) {
        Connection conn = null;
        try {
            boolean bl;
            Throwable throwable;
            ResultSet results;
            block17: {
                block18: {
                    conn = this.pool.getConnection();
                    PreparedStatement statement = conn.prepareStatement("SELECT * FROM accountslink WHERE main_uuid = ?", 1005, 1008);
                    statement.setString(1, uuid);
                    statement.closeOnCompletion();
                    results = statement.executeQuery();
                    throwable = null;
                    bl = results.next();
                    if (results == null) break block17;
                    if (throwable == null) break block18;
                    try {
                        results.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block17;
                }
                results.close();
            }
            return bl;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (results != null) {
                            if (throwable != null) {
                                try {
                                    results.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                results.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (SQLException e) {
                    this.LOG.severe("Error while checking if the specified UUID (" + uuid + ") is linked: " + e.getMessage());
                    e.printStackTrace();
                    boolean bl2 = false;
                    return bl2;
                }
            }
        }
        finally {
            this.pool.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int linkAccounts(UUID main, UUID secondary) {
        Connection conn = null;
        try {
            int n;
            Throwable throwable;
            ResultSet results;
            block24: {
                block25: {
                    block21: {
                        int n2;
                        block22: {
                            block23: {
                                conn = this.pool.getConnection();
                                PreparedStatement statement = conn.prepareStatement("SELECT * FROM accountslink WHERE main_uuid = ? AND secondary_uuid = ?", 1005, 1008);
                                statement.setString(1, main.toString());
                                statement.setString(2, secondary.toString());
                                statement.closeOnCompletion();
                                results = statement.executeQuery();
                                throwable = null;
                                if (results.next()) break block21;
                                results.moveToInsertRow();
                                results.updateString("main_uuid", main.toString());
                                results.updateString("secondary_uuid", secondary.toString());
                                results.insertRow();
                                this.plugin.accounts.put(secondary, main);
                                n2 = 1;
                                if (results == null) break block22;
                                if (throwable == null) break block23;
                                try {
                                    results.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block22;
                            }
                            results.close();
                        }
                        return n2;
                    }
                    n = 0;
                    if (results == null) break block24;
                    if (throwable == null) break block25;
                    try {
                        results.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block24;
                }
                results.close();
            }
            return n;
            catch (Throwable throwable4) {
                try {
                    try {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (results != null) {
                            if (throwable != null) {
                                try {
                                    results.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                results.close();
                            }
                        }
                        throw throwable5;
                    }
                }
                catch (SQLException e) {
                    this.LOG.severe("Error while setting up database tables: " + e.getMessage());
                    e.printStackTrace();
                    int n3 = -1;
                    return n3;
                }
            }
        }
        finally {
            this.pool.close(conn);
        }
    }

    public Optional<UUID> getMainAccount(UUID uuid) {
        return Optional.ofNullable(this.plugin.accounts.get(uuid));
    }

    public void shutdown() {
        this.LOG.info("Closing Database connection...");
        this.pool.shutdown();
        this.plugin.accounts.clear();
    }

    private void makeInitialCache() {
        this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, () -> {
            Connection conn = null;
            try {
                conn = this.pool.getConnection();
                PreparedStatement statement = conn.prepareStatement("SELECT * FROM accountslink", 1005, 1008);
                statement.closeOnCompletion();
                try (ResultSet results = statement.executeQuery();){
                    while (results.next()) {
                        UUID main = UUID.fromString(results.getString("main_uuid"));
                        UUID secondary = UUID.fromString(results.getString("secondary_uuid"));
                        this.plugin.accounts.put(secondary, main);
                    }
                }
            }
            catch (SQLException e) {
                this.LOG.severe("Error while caching accounts: " + e.getMessage());
                e.printStackTrace();
            }
            finally {
                this.pool.close(conn);
            }
        });
    }

    private void setupTables() {
        Connection conn = null;
        try {
            conn = this.pool.getConnection();
            PreparedStatement statement = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `accountslink`(main_uuid varchar(50) NOT NULL UNIQUE PRIMARY KEY, secondary_uuid varchar(50) NOT NULL UNIQUE)", 1005, 1008);
            statement.closeOnCompletion();
            statement.execute();
        }
        catch (SQLException e) {
            this.LOG.severe("Error while setting up database tables: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            this.pool.close(conn);
        }
    }
}

