/*
 * Decompiled with CFR 0.152.
 */
package support.protocol.accountslink.database;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import net.md_5.bungee.api.ChatColor;
import support.protocol.accountslink.AccountsLink;

class ConnectionPoolManager {
    private final AccountsLink plugin;
    private HikariDataSource hds;
    private boolean autoReconnect;
    private boolean useSSL;
    private boolean verifyServerCertificate;
    private int port;
    private String host;
    private String user;
    private String password;
    private String database;

    ConnectionPoolManager(AccountsLink plugin) {
        this.plugin = plugin;
        this.init();
        if (this.isConfigInvalid()) {
            plugin.LOG.severe(ChatColor.RED + "You haven't configured Database details in your config!");
            return;
        }
        this.setupPool();
    }

    private boolean isConfigInvalid() {
        return this.host.isEmpty() || this.user.isEmpty() || this.password.isEmpty() || this.database.isEmpty();
    }

    private void init() {
        this.autoReconnect = this.plugin.getConfig().autoReconnect();
        this.useSSL = this.plugin.getConfig().useSSL();
        this.verifyServerCertificate = this.plugin.getConfig().verifyServerCertificate();
        this.port = this.plugin.getConfig().getPort();
        this.host = this.plugin.getConfig().getDatabaseHost();
        this.user = this.plugin.getConfig().getDatabaseUser();
        this.password = this.plugin.getConfig().getDatabasePassword();
        this.database = this.plugin.getConfig().getDatabaseName();
    }

    private void setupPool() {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + "?autoReconnect=" + this.autoReconnect + "&useSSL=" + this.useSSL + "&verifyServerCertificate=" + this.verifyServerCertificate);
        config.setDriverClassName("com.mysql.jdbc.Driver");
        config.setUsername(this.user);
        config.setPassword(this.password);
        config.setPoolName("PSALB-Pool");
        this.setupDefaults(config);
        this.hds = new HikariDataSource(config);
    }

    private void setupDefaults(HikariConfig dbConfig) {
        dbConfig.addDataSourceProperty("cachePrepStmts", true);
        dbConfig.addDataSourceProperty("prepStmtCacheSize", 250);
        dbConfig.addDataSourceProperty("prepStmtCacheSqlLimit", 2048);
        dbConfig.addDataSourceProperty("useServerPrepStmts", true);
        dbConfig.addDataSourceProperty("useLocalSessionState", true);
        dbConfig.addDataSourceProperty("rewriteBatchedStatements", true);
        dbConfig.addDataSourceProperty("elideSetAutoCommits", true);
        dbConfig.addDataSourceProperty("maintainTimeStats", false);
        dbConfig.addDataSourceProperty("maximumPoolSize", 20);
        dbConfig.setInitializationFailTimeout(10000L);
        dbConfig.setValidationTimeout(15000L);
    }

    Connection getConnection() throws SQLException {
        return this.hds.getConnection();
    }

    void close(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    void shutdown() {
        if (this.hds != null && !this.hds.isClosed()) {
            this.hds.close();
        }
        this.plugin.LOG.info("Successfully closed Database connection.");
    }
}

