/*
 * Decompiled with CFR 0.152.
 */
package support.protocol.accountslink;

import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;
import support.protocol.accountslink.AccountsLink;
import support.protocol.accountslink.Utils;

public class GameAccountsCommand
extends Command {
    private final AccountsLink plugin;
    private final HashMap<String, UUID> codeToUUID = new HashMap();
    private final HashMap<UUID, String> uuidToCode = new HashMap();

    GameAccountsCommand(AccountsLink plugin) {
        super("accountslink");
        this.plugin = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (args.length < 1) {
            sender.sendMessage((BaseComponent)new TextComponent(ChatColor.GREEN + "ProtocolSupportAccountsLinkBungee\n" + ChatColor.YELLOW + "/accountslink code " + ChatColor.RESET + "- Get linking code for this account\n" + ChatColor.YELLOW + "/accountslink link " + ChatColor.RESET + "- Link this account using a code."));
            return;
        }
        if (!(sender instanceof ProxiedPlayer)) {
            sender.sendMessage((BaseComponent)new TextComponent(ChatColor.DARK_RED + "This command is only available to players"));
            return;
        }
        ProxiedPlayer player = (ProxiedPlayer)sender;
        switch (args[0].toLowerCase()) {
            case "code": {
                player.sendMessage((BaseComponent)new TextComponent("Use this code for linking alts to this account, code is valid for 2 minutes: " + this.generateCode(player.getUniqueId())));
                break;
            }
            case "link": {
                if (args.length < 2) {
                    player.sendMessage((BaseComponent)new TextComponent(ChatColor.DARK_RED + "Code is needed to use this command"));
                    break;
                }
                String code = args[1];
                UUID mainAccountUUID = this.codeToUUID.get(code);
                if (mainAccountUUID == null) {
                    sender.sendMessage((BaseComponent)new TextComponent(ChatColor.DARK_RED + "This code is invalid"));
                    break;
                }
                this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, () -> {
                    if (this.plugin.getDatabase().isLinked(mainAccountUUID.toString())) {
                        sender.sendMessage((BaseComponent)new TextComponent(ChatColor.RED + "This account is already linked!"));
                    } else {
                        int status = this.plugin.getDatabase().linkAccounts(mainAccountUUID, player.getUniqueId());
                        if (status == 0) {
                            sender.sendMessage((BaseComponent)new TextComponent(ChatColor.RED + "Unknown error occurred"));
                        } else if (status == 1) {
                            sender.sendMessage((BaseComponent)new TextComponent(ChatColor.GREEN + "Alt account added, you can now relog"));
                        } else if (status == -1) {
                            sender.sendMessage((BaseComponent)new TextComponent(ChatColor.RED + "An error occurred while saving to the database."));
                        }
                        this.removeCode(mainAccountUUID);
                    }
                });
            }
        }
    }

    private void removeCode(UUID uuid) {
        this.codeToUUID.remove(this.uuidToCode.remove(uuid));
    }

    private String generateCode(UUID uuid) {
        if (this.uuidToCode.containsKey(uuid)) {
            this.removeCode(uuid);
        }
        String randomCode = Utils.generateRandomString(10);
        this.uuidToCode.put(uuid, randomCode);
        this.codeToUUID.put(randomCode, uuid);
        this.plugin.getProxy().getScheduler().schedule((Plugin)this.plugin, () -> this.removeCode(uuid), TimeUnit.MINUTES.toSeconds(2L) * 20L, TimeUnit.SECONDS);
        return randomCode;
    }
}

