/*
 * Decompiled with CFR 0.152.
 */
package support.protocol.accountslink;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;
import support.protocol.accountslink.AccountsLink;

public class Config {
    private final Configuration config;

    Config(AccountsLink plugin) throws IOException {
        File dataFolder = plugin.getDataFolder();
        File file = new File(dataFolder, "config.yml");
        if (!dataFolder.exists()) {
            dataFolder.mkdir();
        }
        if (!file.exists()) {
            try (InputStream stream = plugin.getResourceAsStream("config.yml");){
                Files.copy(stream, file.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                plugin.getLogger().severe("Could not load config file: " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.config = ConfigurationProvider.getProvider(YamlConfiguration.class).load(file);
    }

    public boolean autoReconnect() {
        return this.config.getBoolean("autoReconnect");
    }

    public boolean useSSL() {
        return this.config.getBoolean("useSSL");
    }

    public boolean verifyServerCertificate() {
        return this.config.getBoolean("verifyServerCertificate");
    }

    public int getPort() {
        return this.config.getInt("port");
    }

    public String getDatabaseHost() {
        return this.config.getString("host");
    }

    public String getDatabaseUser() {
        return this.config.getString("user");
    }

    public String getDatabasePassword() {
        return this.config.getString("password");
    }

    public String getDatabaseName() {
        return this.config.getString("database");
    }
}

