/*
 * Decompiled with CFR 0.152.
 */
package support.protocol.accountslink;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import support.protocol.accountslink.Config;
import support.protocol.accountslink.GameAccountsCommand;
import support.protocol.accountslink.ProfileEventListener;
import support.protocol.accountslink.database.Database;

public class AccountsLink
extends Plugin {
    public Logger LOG;
    public Map<UUID, UUID> accounts = new HashMap<UUID, UUID>();
    private Config config;
    private Database db;
    private String pluginTag;

    public void onEnable() {
        this.LOG = this.getLogger();
        this.pluginTag = this.getDescription().getName() + " " + this.getDescription().getVersion();
        this.LOG.info("Enabling " + this.pluginTag + "...");
        try {
            this.config = new Config(this);
        }
        catch (IOException e) {
            this.LOG.severe(ChatColor.RED + "Error while loading the config file: " + e.getMessage());
            e.printStackTrace();
        }
        this.initDatabase();
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new ProfileEventListener(this));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new GameAccountsCommand(this));
        this.LOG.info(ChatColor.GREEN + "Enabled " + this.pluginTag);
    }

    public void onDisable() {
        this.LOG.info("Disabling " + this.pluginTag + "...");
        if (this.getDatabase() != null) {
            this.getDatabase().shutdown();
        }
    }

    private void initDatabase() {
        this.LOG.info("Connecting to MySQL Database...");
        this.db = new Database(this);
    }

    public Config getConfig() {
        return this.config;
    }

    Database getDatabase() {
        return this.db;
    }
}

