/*
 * Decompiled with CFR 0.152.
 */
package com.michaelinfernus.firstjoincommands;

import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class FirstJoinCommands
extends JavaPlugin
implements Listener,
CommandExecutor {
    private List<String> commandsOnFirstJoin;

    public void onEnable() {
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("FirstJoinCommand").setExecutor((CommandExecutor)this);
    }

    public void onDisable() {
    }

    private boolean loadConfig() {
        try {
            if (!this.getDataFolder().exists()) {
                this.getDataFolder().mkdirs();
            }
            this.saveDefaultConfig();
            this.reloadConfig();
            this.commandsOnFirstJoin = this.getConfig().getStringList("commandsOnFirstJoin");
            if (this.commandsOnFirstJoin == null) {
                return false;
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load config! Does it exist?");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            return false;
        }
        if (args[0].equalsIgnoreCase("reload") || sender.hasPermission("firstjoincommands.reload")) {
            boolean success = this.loadConfig();
            if (success) {
                sender.sendMessage(ChatColor.GREEN + "Successfully reloaded config!");
            } else {
                sender.sendMessage(ChatColor.RED + "Failed to reload config.");
            }
            return true;
        }
        return false;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        if (!player.hasPlayedBefore()) {
            for (String command : this.commandsOnFirstJoin) {
                command = command.replaceAll("\\{name}", player.getName());
                Bukkit.dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), (String)command);
            }
        }
    }
}

