/*
 * Decompiled with CFR 0.152.
 */
package dev.thecybercode.plugin.clearlag.code;

import dev.thecybercode.devapi.CyberDevAPI;
import dev.thecybercode.plugin.ChatHelper2.code.API;
import dev.thecybercode.plugin.ChatHelper2.code.metrics.Metrics;
import dev.thecybercode.plugin.clearlag.code.ClearLagTime;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Monster;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public class ClearLagCore
extends JavaPlugin {
    public int timer = this.getConfig().getInt("clear-interval");
    public int timeMin;
    private boolean silent;
    public static ClearLagCore plugin;
    boolean cAlert = false;

    public void onEnable() {
        plugin = this;
        this.setup();
        try {
            new Metrics((Plugin)this);
        }
        catch (Exception e) {
            Bukkit.getLogger().severe("Can't start Metrics (bStats)!");
            e.printStackTrace();
        }
        PluginDescriptionFile PDF = this.getDescription();
        Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3&l-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-"));
        Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&3&l                   " + PDF.getName())));
        Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3&l                Made by:&7 TheCyberCode"));
        Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&3&l                   Version: &7" + PDF.getVersion().replace("[", "").replace("]", ""))));
        Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3&l                "));
        Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&3&l  Depends on: &7" + PDF.getDepend().toString().replace("[", "").replace("]", ""))));
        Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&3&l  SoftDepends on: &7" + PDF.getSoftDepend().toString().replace("[", "").replace("]", ""))));
        Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&3&l  Loads before: &7" + PDF.getLoadBefore().toString().replace("[", "").replace("]", ""))));
        Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&3&l  Site: &7" + PDF.getWebsite().replace("[", "").replace("]", ""))));
        Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3&l-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-"));
    }

    public void setup() {
        this.loadConfigManager();
        if (this.getConfig().getBoolean("config-auto-refresh")) {
            this.configAuto();
        }
        this.silent = this.getConfig().getBoolean("silent");
        this.getCommand("clearlag").setExecutor((CommandExecutor)new ClearLagTime());
        this.clearLag();
    }

    protected void configAuto() {
        Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                ClearLagCore.this.reloadConfig();
            }
        }, 20L, 20L);
    }

    public void loadConfigManager() {
        PluginDescriptionFile PDF = this.getDescription();
        CyberDevAPI.Log((String)("[" + PDF.getPrefix().trim() + "] Copying Config Defaults."));
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.getConfig().set("Plugin-Ver", (Object)PDF.getVersion().toString());
        CyberDevAPI.Log((String)("[" + PDF.getPrefix().trim() + "] Saving Config Defaults."));
        this.saveConfig();
        CyberDevAPI.Log((String)("[" + PDF.getPrefix().trim() + "] Loading Config Defaults."));
        this.reloadConfig();
    }

    private void clearLag() {
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                if (ClearLagCore.this.timer == 0 || ClearLagCore.this.timer < 0) {
                    ClearLagCore.this.timer = ClearLagCore.this.getConfig().getInt("clear-interval");
                    ClearLagCore.this.clearNow();
                    return;
                }
                if (ClearLagCore.this.timer % 60 == 0) {
                    ClearLagCore.this.timeMin = ClearLagCore.this.timer / 60;
                    if (!ClearLagCore.this.silent) {
                        Bukkit.broadcastMessage((String)CyberDevAPI.ChatColour((String)ClearLagCore.this.getConfig().getString("time-remain").replace("%time%", Integer.toString(ClearLagCore.this.timeMin))));
                        if (Bukkit.getServer().getPluginManager().getPlugin("ChatHelper2").isEnabled()) {
                            API.seperatorSend((String)"&3");
                        }
                    }
                }
                --ClearLagCore.this.timer;
            }
        }, 20L, 20L);
    }

    public void clearNow() {
        Iterator iterator = Bukkit.getWorlds().iterator();
        if (iterator.hasNext()) {
            World world = (World)iterator.next();
            List entList = world.getEntities();
            int count = 0;
            for (Entity current : entList) {
                if (current instanceof Item && current.getTicksLived() > 600) {
                    current.remove();
                    ++count;
                }
                if (current instanceof Monster && current.getTicksLived() > 1200) {
                    current.remove();
                    ++count;
                }
                if (!plugin.getConfig().getList("Entities-To-Remove").contains(current.getType().toString()) || !current.isEmpty() || current.getTicksLived() <= 1200) continue;
                current.remove();
                ++count;
            }
            if (!this.silent) {
                Bukkit.broadcastMessage((String)CyberDevAPI.ChatColour((String)this.getConfig().getString("lag-cleared").replace("%count%", Integer.toString(count))));
                if (Bukkit.getServer().getPluginManager().getPlugin("ChatHelper2").isEnabled()) {
                    API.seperatorSend((String)"&3");
                }
            }
            return;
        }
    }
}

