/*
 * Decompiled with CFR 0.152.
 */
package me.theblockbender.xpboost.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import me.theblockbender.xpboost.Main;

public class UtilTime {
    private Main main;

    public UtilTime(Main main) {
        this.main = main;
    }

    public String translateTime(long time) {
        return this.convertString(time);
    }

    private String convertString(long time) {
        String text;
        double num;
        if (time == -1L) {
            return "0.0 " + this.main.getMessage("time-second") + this.main.getMessage("time-multiple");
        }
        int trim = 1;
        String type = time < 60000L ? "SECONDS" : (time < 3600000L ? "MINUTES" : (time < 86400000L ? "HOURS" : "DAYS"));
        switch (type) {
            case "DAYS": {
                num = this.trim(trim, (double)time / 8.64E7);
                text = num + " " + this.main.getMessage("time-day");
                break;
            }
            case "HOURS": {
                num = this.trim(trim, (double)time / 3600000.0);
                text = num + " " + this.main.getMessage("time-hour");
                break;
            }
            case "MINUTES": {
                num = this.trim(trim, (double)time / 60000.0);
                text = num + " " + this.main.getMessage("time-minute");
                break;
            }
            case "SECONDS": {
                num = this.trim(trim, (double)time / 1000.0);
                text = num + " " + this.main.getMessage("time-second");
                break;
            }
            default: {
                num = (int)this.trim(0, time);
                text = (int)num + " " + this.main.getMessage("time-millisecond");
            }
        }
        if (num != 1.0) {
            text = text + this.main.getMessage("time-multiple");
        }
        if (text.equalsIgnoreCase("-1.0 Seconds")) {
            return "0.0 " + this.main.getMessage("time-second") + this.main.getMessage("time-multiple");
        }
        return text;
    }

    private double trim(int degree, double d) {
        StringBuilder format = new StringBuilder("#.#");
        for (int i = 1; i < degree; ++i) {
            format.append("#");
        }
        DecimalFormatSymbols symb = new DecimalFormatSymbols(Locale.US);
        DecimalFormat twoDForm = new DecimalFormat(format.toString(), symb);
        return Double.valueOf(twoDForm.format(d));
    }
}

