/*
 * Decompiled with CFR 0.152.
 */
package me.theblockbender.xpboost.util;

import java.util.UUID;
import me.theblockbender.xpboost.Main;
import me.theblockbender.xpboost.util.BoosterType;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class Booster {
    private UUID owner;
    private String name;
    private Integer multiplier;
    private Long started_at;
    private Integer time;
    private Main main;
    private BoosterType type;

    public Booster(UUID uuid, Main main, BoosterType type, int multiplier) {
        this.main = main;
        this.owner = uuid;
        Player player = Bukkit.getPlayer((UUID)uuid);
        this.name = player == null ? main.getMessage("unknown") : player.getName();
        FileConfiguration config = main.getConfig();
        this.multiplier = multiplier;
        this.started_at = System.currentTimeMillis();
        this.time = config.getInt("Boosters." + type.name() + ".time");
        this.type = type;
    }

    public String getPlayerName() {
        return this.name;
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.owner);
    }

    public String getTimeLeft() {
        Long timeLeft = this.getRawTimeLeft();
        if (timeLeft <= 0L) {
            this.main.endActiveBooster(this);
            return "0.0 " + this.main.getMessage("time-second") + this.main.getMessage("time-multiple");
        }
        return this.main.utilTime.translateTime(timeLeft);
    }

    public Long getRawTimeLeft() {
        Long timeLasting = (long)this.time.intValue() * 1000L;
        Long timeLeft = this.started_at + timeLasting - System.currentTimeMillis();
        if (timeLeft <= 0L) {
            return 0L;
        }
        return timeLeft;
    }

    public Integer getMultiplier() {
        return this.multiplier;
    }

    public BoosterType getType() {
        return this.type;
    }
}

