/*
 * Decompiled with CFR 0.152.
 */
package me.theblockbender.xpboost.event;

import java.util.List;
import java.util.UUID;
import me.theblockbender.xpboost.Main;
import me.theblockbender.xpboost.util.BoosterType;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class InventoryListener
implements Listener {
    private Main main;

    public InventoryListener(Main main) {
        this.main = main;
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        this.main.openInventories.remove(uuid);
        this.main.clickCooldown.remove(uuid);
    }

    @EventHandler
    public void onInventoryItemClick(InventoryClickEvent event) {
        HumanEntity human = event.getWhoClicked();
        if (!(human instanceof Player)) {
            human.sendMessage(this.main.getMessage("command-from-console"));
            return;
        }
        Player player = (Player)human;
        UUID uuid = player.getUniqueId();
        if (!this.main.openInventories.contains(uuid)) {
            return;
        }
        event.setCancelled(true);
        if (this.main.clickCooldown.containsKey(uuid) && this.main.clickCooldown.get(uuid) > System.currentTimeMillis()) {
            return;
        }
        Inventory inventory = event.getInventory();
        int slot = event.getSlot();
        if (slot == -999) {
            return;
        }
        ItemStack item = inventory.getItem(slot);
        if (item == null) {
            return;
        }
        if (inventory instanceof PlayerInventory) {
            player.sendMessage(this.main.getMessage("event-wrong-inventory"));
            return;
        }
        player.playSound(player.getLocation(), Sound.ENTITY_ITEM_FRAME_ROTATE_ITEM, 0.2f, 1.0f);
        this.main.clickCooldown.put(uuid, System.currentTimeMillis() + 500L);
        Material bottle = this.main.getGuiMaterial("gui-booster.material");
        Material chest = this.main.getGuiMaterial("gui-shop.material");
        Material barrier = this.main.getGuiMaterial("gui-exit.material");
        if (item.getType() == bottle) {
            if (!item.hasItemMeta()) {
                return;
            }
            if (!item.getItemMeta().hasLore()) {
                return;
            }
            List lore = item.getItemMeta().getLore();
            BoosterType type = BoosterType.valueOf(((String)lore.get(lore.size() - 1)).replace("\u00a78booster:", "").toUpperCase());
            this.main.tryActivateBooster(player, type);
            player.closeInventory();
            return;
        }
        if (item.getType() == chest) {
            player.sendMessage(this.main.getMessage("store-divider"));
            player.sendMessage(" ");
            player.sendMessage(this.main.getMessage("store-url"));
            player.sendMessage(this.main.getMessage("store-info"));
            player.sendMessage(" ");
            player.sendMessage(this.main.getMessage("store-divider"));
            player.closeInventory();
            return;
        }
        if (item.getType() == barrier) {
            player.closeInventory();
        }
    }
}

