/*
 * Decompiled with CFR 0.152.
 */
package me.theblockbender.xpboost.command;

import me.theblockbender.xpboost.Main;
import me.theblockbender.xpboost.util.BoosterType;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BoosterCommand
implements CommandExecutor {
    private Main main;

    public BoosterCommand(Main main) {
        this.main = main;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        int amount;
        boolean isPlayer = false;
        if (sender instanceof Player) {
            isPlayer = true;
        }
        if (args.length == 0) {
            if (isPlayer) {
                if (!sender.hasPermission("xpboost.player")) {
                    sender.sendMessage(this.main.getMessage("command-no-permission"));
                    return true;
                }
                this.main.boostergui.open((Player)sender);
                return true;
            }
            this.sendHelp(sender, label);
            return true;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("boost")) {
            if (!isPlayer) {
                sender.sendMessage(this.main.getMessage("command-from-console"));
                return true;
            }
            if (!sender.hasPermission("xpboost.admin")) {
                sender.sendMessage(this.main.getMessage("command-no-permission"));
                return true;
            }
            BoosterType type = null;
            if (args[1].equalsIgnoreCase("minecraft")) {
                type = BoosterType.MINECRAFT;
                if (!this.main.isBoosterEnabled(BoosterType.MINECRAFT)) {
                    sender.sendMessage(this.main.getMessage("event-booster-disabled"));
                    return true;
                }
            }
            if (args[1].equalsIgnoreCase("skillapi")) {
                type = BoosterType.SKILLAPI;
                if (!this.main.isBoosterEnabled(BoosterType.SKILLAPI)) {
                    sender.sendMessage(this.main.getMessage("event-booster-disabled"));
                    return true;
                }
            }
            if (args[1].equalsIgnoreCase("mcmmo")) {
                type = BoosterType.MCMMO;
                if (!this.main.isBoosterEnabled(BoosterType.MCMMO)) {
                    sender.sendMessage(this.main.getMessage("event-booster-disabled"));
                    return true;
                }
            }
            if (args[1].equalsIgnoreCase("jobs")) {
                type = BoosterType.JOBS;
                if (!this.main.isBoosterEnabled(BoosterType.JOBS)) {
                    sender.sendMessage(this.main.getMessage("event-booster-disabled"));
                    return true;
                }
            }
            if (type == null) {
                sender.sendMessage(this.main.getMessage("command-invalid-type"));
                sender.sendMessage(this.main.getMessage("command-available-types"));
                return true;
            }
            this.main.cmdActivate((Player)sender, type);
            return true;
        }
        if (args.length < 3 || args.length > 4) {
            this.sendHelp(sender, label);
            return true;
        }
        String subcommand = args[0].toLowerCase();
        Player player = null;
        if ((subcommand.equalsIgnoreCase("give") || subcommand.equalsIgnoreCase("take") || subcommand.equalsIgnoreCase("reset")) && (player = Bukkit.getPlayer((String)args[1])) == null) {
            sender.sendMessage(this.main.getMessage("command-player-not-online").replace("{player}", args[1]));
            return true;
        }
        BoosterType type = null;
        if (args[2].equalsIgnoreCase("minecraft")) {
            type = BoosterType.MINECRAFT;
            if (!this.main.isBoosterEnabled(BoosterType.MINECRAFT)) {
                sender.sendMessage(this.main.getMessage("event-booster-disabled"));
                return true;
            }
        }
        if (args[2].equalsIgnoreCase("skillapi")) {
            type = BoosterType.SKILLAPI;
            if (!this.main.isBoosterEnabled(BoosterType.SKILLAPI)) {
                sender.sendMessage(this.main.getMessage("event-booster-disabled"));
                return true;
            }
        }
        if (args[2].equalsIgnoreCase("mcmmo")) {
            type = BoosterType.MCMMO;
            if (!this.main.isBoosterEnabled(BoosterType.MCMMO)) {
                sender.sendMessage(this.main.getMessage("event-booster-disabled"));
                return true;
            }
        }
        if (args[2].equalsIgnoreCase("jobs")) {
            type = BoosterType.JOBS;
            if (!this.main.isBoosterEnabled(BoosterType.JOBS)) {
                sender.sendMessage(this.main.getMessage("event-booster-disabled"));
                return true;
            }
        }
        if (type == null) {
            sender.sendMessage(this.main.getMessage("command-invalid-type"));
            sender.sendMessage(this.main.getMessage("command-available-types"));
            return true;
        }
        if (args.length == 3) {
            if (subcommand.equalsIgnoreCase("give")) {
                if (!sender.hasPermission("xpboost.admin")) {
                    sender.sendMessage(this.main.getMessage("command-no-permission"));
                    return true;
                }
                this.main.addBooster(player, 1, sender, type);
                return true;
            }
            if (subcommand.equalsIgnoreCase("take")) {
                if (!sender.hasPermission("xpboost.admin")) {
                    sender.sendMessage(this.main.getMessage("command-no-permission"));
                    return true;
                }
                this.main.takeBooster(player, 1, sender, type);
                return true;
            }
            if (subcommand.equalsIgnoreCase("reset")) {
                if (!sender.hasPermission("xpboost.admin")) {
                    sender.sendMessage(this.main.getMessage("command-no-permission"));
                    return true;
                }
                this.main.resetBooster(player, sender, type);
                return true;
            }
            this.sendHelp(sender, label);
            return true;
        }
        try {
            amount = Integer.parseInt(args[3]);
        }
        catch (NumberFormatException ex) {
            sender.sendMessage(this.main.getMessage("command-invalid-amount").replace("{amount}", args[3]));
            return true;
        }
        if (amount < 1 || amount > 100) {
            sender.sendMessage(this.main.getMessage("command-number-to-weird"));
            return true;
        }
        if (subcommand.equalsIgnoreCase("give")) {
            if (!sender.hasPermission("xpboost.admin")) {
                sender.sendMessage(this.main.getMessage("command-no-permission"));
                return true;
            }
            this.main.addBooster(player, amount, sender, type);
            return true;
        }
        if (subcommand.equalsIgnoreCase("take")) {
            if (!sender.hasPermission("xpboost.admin")) {
                sender.sendMessage(this.main.getMessage("command-no-permission"));
                return true;
            }
            this.main.takeBooster(player, amount, sender, type);
            return true;
        }
        this.sendHelp(sender, label);
        return true;
    }

    private void sendHelp(CommandSender sender, String label) {
        sender.sendMessage(this.main.getMessage("help-divider"));
        sender.sendMessage(this.main.getMessage("help-header"));
        sender.sendMessage(this.main.getMessage("help-gui").replace("{cmd}", label));
        sender.sendMessage(this.main.getMessage("help-give").replace("{cmd}", label));
        sender.sendMessage(this.main.getMessage("help-take").replace("{cmd}", label));
        sender.sendMessage(this.main.getMessage("help-reset").replace("{cmd}", label));
        sender.sendMessage(this.main.getMessage("help-start-booster").replace("{cmd}", label));
        sender.sendMessage(this.main.getMessage("help-divider"));
    }
}

